/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Stack;
import org.pf.file.DirectoryContents;
import org.pf.file.FileHandler;
import org.pf.file.FileInfo;
import org.pf.file.LoggerProvider;
import org.pf.file.TableOfContents;

class FileDirectoryScannerFileHandler
implements FileHandler {
    private Stack dirStack = null;
    private TableOfContents toc = null;
    private int baseDirLength = 0;

    protected Stack getDirStack() {
        return this.dirStack;
    }

    protected void setDirStack(Stack newValue) {
        this.dirStack = newValue;
    }

    protected TableOfContents toc() {
        return this.toc;
    }

    protected void toc(TableOfContents newValue) {
        this.toc = newValue;
    }

    protected int baseDirLength() {
        return this.baseDirLength;
    }

    protected void baseDirLength(int newValue) {
        this.baseDirLength = newValue;
    }

    protected FileDirectoryScannerFileHandler(String baseDir) throws IOException {
        this.initialize(baseDir);
    }

    public boolean directoryStart(File dir, int count) {
        String dirName = dir.getAbsolutePath();
        dirName = (dirName = this.normalizeDirName(dirName)).length() > this.baseDirLength() ? dirName.substring(this.baseDirLength()) : "";
        DirectoryContents dirContents = new DirectoryContents(dirName);
        this.toc().add(dirContents);
        this.setCurrentDirContents(dirContents);
        return true;
    }

    public boolean directoryEnd(File dir) {
        this.removeCurrentDirContents();
        return true;
    }

    public boolean handleException(Exception ex, File file) {
        LoggerProvider.getLogger().logError("Error on walking over file: " + file.getPath(), ex);
        return true;
    }

    public boolean handleFile(File file) {
        this.registerFileInfo(new FileInfo(file));
        return true;
    }

    protected void registerFileInfo(FileInfo fileInfo) {
        this.getCurrentDirContents().addFileInfo(fileInfo);
    }

    protected DirectoryContents getCurrentDirContents() {
        return (DirectoryContents)this.getDirStack().peek();
    }

    protected void setCurrentDirContents(DirectoryContents newValue) {
        this.getDirStack().push(newValue);
    }

    protected DirectoryContents removeCurrentDirContents() {
        return (DirectoryContents)this.getDirStack().pop();
    }

    protected String normalizeDirName(String dirName) {
        String pathName = null;
        pathName = dirName.replace('\\', '/');
        if (pathName.endsWith("/")) {
            pathName = pathName.substring(0, pathName.length() - 1);
        }
        return pathName;
    }

    protected void initialize(String baseDirName) throws IOException {
        File startDir = new File(baseDirName);
        if (!startDir.exists()) {
            throw new FileNotFoundException("Directory '" + baseDirName + "' not found.");
        }
        if (!startDir.isDirectory()) {
            throw new IOException("'" + baseDirName + "' is not a directory.");
        }
        String dirName = startDir.getAbsolutePath();
        dirName = this.normalizeDirName(dirName);
        int len = dirName.length();
        if (!dirName.endsWith("/")) {
            ++len;
        }
        this.setDirStack(new Stack());
        this.toc(new TableOfContents(baseDirName));
        this.baseDirLength(len);
    }
}

