/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.pf.file.FileInfo;
import org.pf.file.FileUtil;
import org.pf.util.NamedValue;
import org.pf.util.NamedValueList;

public class ArchiveTOC {
    private NamedValueList directories = null;
    private String zipFilename = null;

    protected NamedValueList directories() {
        return this.directories;
    }

    protected void directories(NamedValueList newValue) {
        this.directories = newValue;
    }

    protected String getZipFilename() {
        return this.zipFilename;
    }

    protected void setZipFilename(String newValue) {
        this.zipFilename = newValue;
    }

    public ArchiveTOC(String filename) throws IOException {
        this.directories(new NamedValueList());
        this.init(filename);
    }

    public ArchiveTOC(File archive) throws IOException {
        this(archive.getAbsolutePath());
    }

    public NamedValueList toc() {
        return this.directories();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void init(String filename) throws IOException {
        ZipFile zipFile = null;
        zipFile = new ZipFile(filename);
        try {
            this.readTOC(zipFile);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            FileUtil.current().close(zipFile);
            throw throwable;
        }
        {
            Object var3_5 = null;
            FileUtil.current().close(zipFile);
        }
        this.setZipFilename(filename);
    }

    protected void readTOC(ZipFile zipFile) throws IOException {
        Enumeration<? extends ZipEntry> entries = null;
        ZipEntry entry = null;
        FileInfo fileInfo = null;
        entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            if (this.isDirectory(entry)) continue;
            fileInfo = new FileInfo(zipFile.getName(), entry);
            this.add(fileInfo);
        }
        this.convertLists();
    }

    protected void convertLists() {
        NamedValue<V>[] dirs = this.directories().namedValueArray();
        int i = 0;
        while (i < dirs.length) {
            List infos = (List)dirs[i].value();
            FileInfo[] infoArray = infos.toArray(new FileInfo[0]);
            dirs[i].value(infoArray);
            ++i;
        }
    }

    protected void add(FileInfo info) {
        NamedValue<Object> pathEntry = this.directories().findNamedValue(info.getPath());
        if (pathEntry == null) {
            pathEntry = new NamedValue(info.getPath(), new ArrayList());
            this.directories().add(pathEntry);
        }
        List classList = (List)pathEntry.value();
        classList.add(info);
    }

    protected boolean isDirectory(ZipEntry entry) {
        return entry.isDirectory();
    }
}

