/*
 * Decompiled with CFR 0.152.
 */
package g2d.util;

import g2d.jlambda.Utils;
import g2d.util.IO;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.json.simple.JSONValue;

public class Fetch {
    static boolean VERBOSE;
    static boolean GULLIBLE;
    static String IANDEV;
    static String STELLA;
    static Map<String, String> serverPems;
    static Map<String, SSLContext> serverContextMap;

    private static void loadCertificates() {
        try {
            for (Map.Entry<String, String> entry : serverPems.entrySet()) {
                KeyStore keyStore;
                X509Certificate x509Certificate = Fetch.string2Certificate(Fetch.resource2String(entry.getValue()));
                if (x509Certificate == null || (keyStore = Fetch.certificate2KeyStore(x509Certificate)) == null) continue;
                KeyManager[] keyManagerArray = Fetch.keyStore2KeyManagers(keyStore);
                TrustManager[] trustManagerArray = Fetch.keyStore2TrustManagers(keyStore);
                if (keyManagerArray == null || trustManagerArray == null) continue;
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(keyManagerArray, trustManagerArray, null);
                serverContextMap.put(entry.getKey(), sSLContext);
            }
        }
        catch (Exception exception) {
            System.err.println("loadCertificates(): " + exception);
        }
    }

    private static void trustAllHosts() {
        Object object;
        block2: {
            System.err.println("Using trustAllHosts(): not good.");
            try {
                object = SSLContext.getInstance("TLS");
                ((SSLContext)object).init(null, new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
                SSLContext.setDefault((SSLContext)object);
                HttpsURLConnection.setDefaultSSLSocketFactory(((SSLContext)object).getSocketFactory());
            }
            catch (Exception exception) {
                System.err.println("trustAllHosts(): " + exception);
                if (!VERBOSE) break block2;
                exception.printStackTrace(System.err);
            }
        }
        object = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)object);
    }

    private static String resource2String(String string) {
        InputStream inputStream = Fetch.class.getResourceAsStream(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return Utils.reader2String(bufferedReader);
    }

    private static X509Certificate string2Certificate(String string) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        }
        catch (Exception exception) {
            System.err.println("string2Certificate(): " + exception);
            return null;
        }
    }

    private static KeyStore certificate2KeyStore(X509Certificate x509Certificate) {
        try {
            String string = x509Certificate.getSubjectX500Principal().getName();
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            keyStore.setCertificateEntry(string, x509Certificate);
            return keyStore;
        }
        catch (Exception exception) {
            System.err.println("certificate2KeyStore(): " + exception);
            return null;
        }
    }

    private static KeyManager[] keyStore2KeyManagers(KeyStore keyStore) {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(keyStore, null);
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception exception) {
            System.err.println("keyStore2KeyManagers(): " + exception);
            return null;
        }
    }

    private static TrustManager[] keyStore2TrustManagers(KeyStore keyStore) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("X509");
            trustManagerFactory.init(keyStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception exception) {
            System.err.println("keyStore2TrustManagers(): " + exception);
            return null;
        }
    }

    private static InputStream url2InputStream(URL uRL, boolean bl) throws Exception {
        if (bl) {
            Object object;
            if (GULLIBLE) {
                Fetch.trustAllHosts();
            } else {
                object = uRL.getHost();
                SSLContext sSLContext = serverContextMap.get(object);
                if (sSLContext != null) {
                    HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
                }
            }
            object = (HttpsURLConnection)uRL.openConnection();
            return ((URLConnection)object).getInputStream();
        }
        URLConnection uRLConnection = uRL.openConnection();
        return uRLConnection.getInputStream();
    }

    public static BufferedReader getReader(String string) {
        return new BufferedReader(new InputStreamReader(Fetch.getInputStream(string)));
    }

    public static InputStream getInputStream(String string) {
        boolean bl = string.startsWith("https://");
        try {
            URL uRL = new URL(string);
            return Fetch.url2InputStream(uRL, bl);
        }
        catch (Exception exception) {
            System.err.println("Error connecting to: " + string + " --  " + exception);
            if (VERBOSE) {
                exception.printStackTrace(System.err);
            }
            return null;
        }
    }

    public static BufferedImage getImage(String string) {
        try {
            return ImageIO.read(Fetch.getInputStream(string));
        }
        catch (IOException iOException) {
            System.err.println("Error connecting to: " + string + " --  " + iOException);
            if (VERBOSE) {
                iOException.printStackTrace(System.err);
            }
            return null;
        }
    }

    public static Object fetchJSON(String string) {
        try {
            System.err.println(String.format("Fetch.fetchJSON(%s)", string));
            String string2 = Fetch.fetchString(string);
            if (string2 == null) {
                System.err.println(String.format("Fetch.fetchJSON(%s) FAILED (is it time to renew the certificates?)!", string));
                return null;
            }
            return JSONValue.parse(string2);
        }
        catch (Exception exception) {
            System.err.println("Fetch.fetchJSON threw: " + exception);
            if (VERBOSE) {
                exception.printStackTrace(System.err);
            }
            return null;
        }
    }

    public static String fetchString(String string) {
        try {
            BufferedReader bufferedReader = Fetch.getReader(string);
            return IO.reader2String(bufferedReader);
        }
        catch (Exception exception) {
            System.err.println("Fetch.fetchString threw: " + exception);
            if (VERBOSE) {
                exception.printStackTrace(System.err);
            }
            return null;
        }
    }

    public static void main(String[] stringArray) {
        String string = "stella.csl.sri.com/plaonline/models";
        if (stringArray == null) {
            String string2 = "https://" + string;
            System.out.println("HTTPS:");
            BufferedReader bufferedReader = Fetch.getReader(string2);
            String string3 = IO.reader2String(bufferedReader);
            System.out.println(string3);
        } else {
            String string4 = "http://" + string;
            System.out.println("HTTP:");
            BufferedReader bufferedReader = Fetch.getReader(string4);
            String string5 = IO.reader2String(bufferedReader);
            System.out.println(string5);
        }
    }

    static {
        block2: {
            VERBOSE = false;
            GULLIBLE = false;
            IANDEV = "/g2d/util/iandev-expires-2023-02-08.pem";
            STELLA = "/g2d/util/stella-expires-2022-01-10.pem";
            serverPems = new HashMap<String, String>();
            serverContextMap = new HashMap<String, SSLContext>();
            serverPems.put("iandev.sri.com", "/g2d/util/iandev-expires-2023-02-08.pem");
            serverPems.put("stella.csl.sri.com", "/g2d/util/stella-expires-2022-01-10.pem");
            try {
                Fetch.loadCertificates();
            }
            catch (Exception exception) {
                System.err.println(String.format("Loading CSL certificates threw: %s", exception));
                if (!VERBOSE) break block2;
                exception.printStackTrace(System.err);
            }
        }
    }

    public static class DefaultTrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

