/*
 * Decompiled with CFR 0.152.
 */
package g2d.terms;

import g2d.terms.Algebra;
import g2d.terms.AppTerm;
import g2d.terms.Constructor;
import g2d.terms.HolePosition;
import g2d.terms.HoleTerm;
import g2d.terms.Sort;
import g2d.terms.Subsorter;
import g2d.terms.TermPosition;
import g2d.terms.VarTerm;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class Term {
    public abstract Sort sort();

    public abstract Set<Term> subterms();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toStringBuffer(stringBuffer);
        return stringBuffer.toString();
    }

    public abstract void toStringBuffer(StringBuffer var1);

    public abstract int length();

    public abstract int rank();

    public abstract int holeCount();

    public abstract Term copy();

    public Term expand(int n, Constructor constructor, Subsorter subsorter) {
        if (n <= this.holeCount()) {
            return this.expand(n, constructor.expand(subsorter), subsorter);
        }
        return null;
    }

    public abstract Term expand(int var1, Term var2, Subsorter var3);

    public static ArrayList<Term> expand(List<Term> list, int n, Term term, Subsorter subsorter) {
        boolean bl = false;
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (int i = 0; i < list.size(); ++i) {
            Term term2 = list.get(i);
            int n2 = term2.holeCount();
            if (bl) {
                arrayList.add(term2);
                continue;
            }
            if (n <= n2) {
                if (term2 instanceof HoleTerm) {
                    if (n != 1) {
                        System.err.println("hi = " + n);
                    }
                    if (!subsorter.isSubsort(term.sort(), term2.sort())) {
                        System.err.println(term.sort() + " not a subsort of " + term2.sort());
                    }
                    assert (n == 1 && subsorter.isSubsort(term.sort(), term2.sort()));
                    arrayList.add(term);
                } else if (term2 instanceof AppTerm) {
                    AppTerm appTerm = (AppTerm)term2;
                    Constructor constructor = appTerm.constructor;
                    ArrayList<Term> arrayList2 = Term.expand(appTerm.terms, n, term, subsorter);
                    arrayList.add(new AppTerm(constructor, arrayList2, subsorter));
                }
                bl = true;
                continue;
            }
            arrayList.add(term2);
            n -= n2;
        }
        return bl ? arrayList : null;
    }

    public Term expand(TermPosition termPosition, Term term, Subsorter subsorter) {
        Term term2 = termPosition.term;
        Term term3 = term.copy();
        if (this == term2) {
            return term3;
        }
        return this.expand(term2, term3, subsorter);
    }

    public abstract Term expand(Term var1, Term var2, Subsorter var3);

    public static ArrayList<Term> expand(List<Term> list, Term term, Term term2, Subsorter subsorter) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (int i = 0; i < list.size(); ++i) {
            Term term3 = list.get(i);
            int n = term3.rank();
            if (term.rank() <= n) {
                if (term == term3) {
                    arrayList.add(term2);
                    continue;
                }
                if (term.rank() < n && term3 instanceof AppTerm) {
                    AppTerm appTerm = (AppTerm)term3;
                    Constructor constructor = appTerm.constructor;
                    ArrayList<Term> arrayList2 = Term.expand(appTerm.terms, term, term2, subsorter);
                    arrayList.add(new AppTerm(constructor, arrayList2, subsorter));
                    continue;
                }
                arrayList.add(term3);
                continue;
            }
            arrayList.add(term3);
        }
        return arrayList;
    }

    public ArrayList<HolePosition> getHolePositions() {
        ArrayList<HolePosition> arrayList = new ArrayList<HolePosition>();
        this.getHolePositions(0, arrayList);
        int n = 1;
        for (HolePosition holePosition : arrayList) {
            holePosition.index = n++;
        }
        return arrayList;
    }

    public abstract int getHolePositions(int var1, ArrayList<HolePosition> var2);

    public ArrayList<TermPosition> getSubtermPositions() {
        ArrayList<TermPosition> arrayList = new ArrayList<TermPosition>();
        this.getSubtermPositions(0, null, arrayList);
        return arrayList;
    }

    public abstract int getSubtermPositions(int var1, Sort var2, ArrayList<TermPosition> var3);

    public static Term parse(Object object, Algebra algebra) {
        if (object == null) {
            throw new IllegalArgumentException("Term.parse does not accept null");
        }
        if (object instanceof String) {
            return Term.parseString((String)object, algebra);
        }
        if (object instanceof Object[]) {
            return Term.parseArray((Object[])object, algebra);
        }
        System.err.println("Term.parse: did not like: " + object);
        return null;
    }

    protected static Term parseString(String string, Algebra algebra) {
        if (string.indexOf(58) == -1) {
            return Term.parseConstructor(string, algebra);
        }
        return Term.parseVariable(string, algebra);
    }

    public static Term parseArray(Object[] objectArray, Algebra algebra) {
        if (objectArray.length > 0) {
            Object object = objectArray[0];
            if (!(object instanceof String)) {
                System.err.println("Term.parseArray: operator not a String: " + object);
                return null;
            }
            Constructor constructor = algebra.getConstructorByName((String)object);
            if (constructor == null) {
                System.err.println("Term.parseArray: operator not in algebra: " + object);
                return null;
            }
            ArrayList<Term> arrayList = new ArrayList<Term>();
            for (int i = 1; i < objectArray.length; ++i) {
                Term term = Term.parse(objectArray[i], algebra);
                if (term == null) {
                    return null;
                }
                arrayList.add(term);
            }
            return new AppTerm(constructor, arrayList, algebra.subsorter);
        }
        System.err.println("Term.parseArray: did not like the length of: " + objectArray);
        return null;
    }

    protected static Term parseConstructor(String string, Algebra algebra) {
        Constructor constructor = algebra.getConstructorByName(string);
        if (constructor == null) {
            System.err.println("Term.parseConstructor: operator not in algebra: " + string);
            return null;
        }
        if (constructor.arity != 0) {
            System.err.println("Term.parseConstructor: operator not a constant: " + string);
            return null;
        }
        return new AppTerm(constructor, new ArrayList<Term>(), algebra.subsorter);
    }

    protected static Term parseVariable(String string, Algebra algebra) {
        String[] stringArray = string.split(":");
        if (stringArray.length == 2) {
            String string2 = stringArray[0].trim();
            String string3 = stringArray[1].trim();
            return VarTerm.fromStrings(string2, string3);
        }
        System.err.println("Term.parseVariable: did not like: " + string);
        return null;
    }
}

