/*
 * Decompiled with CFR 0.152.
 */
package g2d.terms;

import g2d.terms.AppTerm;
import g2d.terms.Constructor;
import g2d.terms.Sort;
import g2d.terms.Subsorter;
import g2d.terms.Term;
import g2d.terms.TermPoolListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Algebra {
    public static final boolean debug = false;
    public final Sort[] sorts;
    public final Subsorter subsorter;
    public final Constructor[] ops;
    private final HashMap<String, Constructor> opsByName = new HashMap();
    private final HashMap<Sort, HashSet<Term>> termPool = new HashMap();
    private final ArrayList<TermPoolListener> termPoolListeners = new ArrayList();

    public Algebra(Sort[] sortArray, Subsorter subsorter, Constructor[] constructorArray) {
        this.sorts = sortArray;
        this.subsorter = subsorter;
        this.ops = constructorArray;
        this.processOps();
    }

    public Algebra(String[] stringArray, String[][] stringArray2, String[][] stringArray3) {
        Sort[] sortArray = new Sort[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            sortArray[i] = new Sort(stringArray[i]);
        }
        Constructor[] constructorArray = new Constructor[stringArray3.length];
        for (int i = 0; i < stringArray3.length; ++i) {
            constructorArray[i] = new Constructor(stringArray3[i]);
        }
        Subsorter subsorter = Subsorter.parse(stringArray2);
        this.sorts = sortArray;
        this.subsorter = subsorter;
        this.ops = constructorArray;
        this.processOps();
    }

    public Algebra(Sort[] sortArray, HashMap<Sort, Sort[]> hashMap, Constructor[] constructorArray) {
        this.sorts = sortArray;
        this.subsorter = Subsorter.fromMap(hashMap);
        this.ops = constructorArray;
        this.processOps();
    }

    public Constructor getConstructorByName(String string) {
        return this.opsByName.get(string);
    }

    public ArrayList<Constructor> getConstructorsBySubsort(Sort sort) {
        Sort[] sortArray;
        ArrayList<Constructor> arrayList = this.getConstructorsBySort(sort);
        for (Sort sort2 : sortArray = this.subsorter.subsorts(sort)) {
            if (sort2.equals(sort)) continue;
            arrayList.addAll(this.getConstructorsBySort(sort2));
        }
        return arrayList;
    }

    public ArrayList<Constructor> getConstructorsBySort(Sort sort) {
        ArrayList<Constructor> arrayList = new ArrayList<Constructor>();
        for (Constructor constructor : this.ops) {
            if (!constructor.sort.equals(sort)) continue;
            arrayList.add(constructor);
        }
        return arrayList;
    }

    public void addTerm2Pool(Term term) {
        if (term != null) {
            if (term instanceof AppTerm && ((AppTerm)term).constructor.arity == 0) {
                return;
            }
            Sort sort = term.sort();
            HashSet<Term> hashSet = this.termPool.get(sort);
            if (hashSet == null) {
                hashSet = new HashSet();
                this.termPool.put(sort, hashSet);
            }
            hashSet.add(term);
            for (TermPoolListener termPoolListener : this.termPoolListeners) {
                termPoolListener.termAdded(term);
            }
        }
    }

    public Set<Term> getPool(Sort sort) {
        HashSet<Term> hashSet = null;
        if (sort != null) {
            Sort[] sortArray;
            HashSet<Term> hashSet2 = this.termPool.get(sort);
            if (hashSet2 != null) {
                hashSet = new HashSet<Term>(hashSet2);
            }
            for (Sort sort2 : sortArray = this.subsorter.subsorts(sort)) {
                HashSet<Term> hashSet3;
                if (sort2.equals(sort) || (hashSet3 = this.termPool.get(sort2)) == null) continue;
                hashSet.addAll(hashSet3);
            }
        }
        return hashSet;
    }

    private final void processOps() {
        if (this.ops != null) {
            for (Constructor constructor : this.ops) {
                this.opsByName.put(constructor.name, constructor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTermPoolListener(TermPoolListener termPoolListener) {
        if (termPoolListener != null) {
            ArrayList<TermPoolListener> arrayList = this.termPoolListeners;
            synchronized (arrayList) {
                this.termPoolListeners.add(termPoolListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTermPoolListener(TermPoolListener termPoolListener) {
        if (termPoolListener != null) {
            ArrayList<TermPoolListener> arrayList = this.termPoolListeners;
            synchronized (arrayList) {
                this.termPoolListeners.remove(termPoolListener);
            }
        }
    }

    public static final Algebra union(Algebra algebra, Algebra algebra2) {
        Sort[] sortArray;
        ArrayList<Sort> arrayList;
        List<Sort> list;
        Object object;
        if (algebra.sorts.length > algebra2.sorts.length) {
            return Algebra.union(algebra2, algebra);
        }
        HashSet<Sort> hashSet = new HashSet<Sort>();
        hashSet.addAll(Arrays.asList(algebra.sorts));
        hashSet.addAll(Arrays.asList(algebra2.sorts));
        Sort[] sortArray2 = hashSet.toArray(new Sort[hashSet.size()]);
        HashSet<Constructor> hashSet2 = new HashSet<Constructor>();
        hashSet2.addAll(Arrays.asList(algebra.ops));
        hashSet2.addAll(Arrays.asList(algebra2.ops));
        Constructor[] constructorArray = hashSet2.toArray(new Constructor[hashSet2.size()]);
        HashSet<Sort> hashSet3 = new HashSet<Sort>();
        List<Sort> list2 = Arrays.asList(algebra2.sorts);
        for (Sort sort : algebra.sorts) {
            if (!list2.contains(sort)) continue;
            hashSet3.add(sort);
        }
        HashMap hashMap = new HashMap();
        for (Sort sort : algebra.sorts) {
            object = algebra.subsorter.subsorts(sort);
            list = Arrays.asList(object);
            arrayList = new ArrayList<Sort>(list);
            hashMap.put(sort, arrayList);
            for (Sort sort2 : list) {
                if (!hashSet3.contains(sort2)) continue;
                for (Sort sort3 : sortArray = algebra2.subsorter.subsorts(sort2)) {
                    if (arrayList.contains(sort3)) continue;
                    arrayList.add(sort3);
                }
            }
        }
        for (Sort sort : algebra2.sorts) {
            if (hashSet3.contains(sort)) continue;
            object = algebra2.subsorter.subsorts(sort);
            list = Arrays.asList(object);
            arrayList = new ArrayList<Sort>(list);
            hashMap.put(sort, arrayList);
            for (Sort sort2 : list) {
                if (!hashSet3.contains(sort2)) continue;
                for (Sort sort3 : sortArray = algebra.subsorter.subsorts(sort2)) {
                    if (arrayList.contains(sort3)) continue;
                    arrayList.add(sort3);
                }
            }
        }
        HashMap hashMap2 = new HashMap();
        Set set = hashMap.keySet();
        for (Sort sort : set) {
            object = (ArrayList)hashMap.get(sort);
            hashMap2.put(sort, ((ArrayList)object).toArray(new Sort[((ArrayList)object).size()]));
        }
        return new Algebra(sortArray2, hashMap2, constructorArray);
    }
}

