/*
 * Decompiled with CFR 0.152.
 */
package g2d.tabwin;

import g2d.Main;
import g2d.graph.GraphContainer;
import g2d.swing.WindowTreeIcon;
import g2d.tabwin.AppFrame;
import g2d.tabwin.TabFrame;
import g2d.tabwin.TabPanel;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class TabUtils {
    private static final HashMap<Integer, AppFrame> idFrameMap = new HashMap();

    public static TabFrame getTabFrame(Container container) {
        TabFrame tabFrame = null;
        if (container instanceof TabFrame) {
            tabFrame = (TabFrame)container;
        } else {
            Container container2 = SwingUtilities.getAncestorOfClass(TabFrame.class, container);
            if (container2 != null) {
                tabFrame = (TabFrame)container2;
            }
        }
        return tabFrame;
    }

    public static TabFrame getTabFrame(GraphContainer graphContainer) {
        TabFrame tabFrame = null;
        if (graphContainer instanceof Container) {
            tabFrame = TabUtils.getTabFrame((Container)((Object)graphContainer));
        }
        return tabFrame;
    }

    public static void register(AppFrame appFrame) {
        Integer n = new Integer(appFrame.id);
        if (idFrameMap.containsKey(n)) {
            throw new IllegalArgumentException("Can't re-register a AppFrame!");
        }
        idFrameMap.put(n, appFrame);
    }

    public static void unregister(AppFrame appFrame) {
        Integer n = new Integer(appFrame.id);
        if (!idFrameMap.containsKey(n)) {
            throw new IllegalArgumentException("Can't unregister a unregistered AppFrame!");
        }
        idFrameMap.remove(n);
        if (TabUtils.checkForGameOver()) {
            System.err.println("Game Over");
            System.exit(0);
        }
    }

    public static TabFrame getTabFrameAtLocation(Point point) {
        TabFrame tabFrame = null;
        for (Map.Entry<Integer, AppFrame> entry : idFrameMap.entrySet()) {
            TabFrame tabFrame2;
            AppFrame appFrame = entry.getValue();
            if (!(appFrame instanceof TabFrame) || !(tabFrame2 = (TabFrame)appFrame).containsLocationOnScreen(point)) continue;
            tabFrame = tabFrame2;
        }
        return tabFrame;
    }

    public static TabPanel launchTab(TabPanel tabPanel, String string, String string2) {
        TabPanel tabPanel2 = new TabPanel(string, string2);
        TabFrame tabFrame = null;
        if (tabPanel == null) {
            tabFrame = new TabFrame(tabPanel2);
            tabFrame.pack();
            tabFrame.setVisible(true);
        } else {
            tabFrame = TabUtils.getTabFrame(tabPanel);
            int n = tabFrame.indexOfTabPanel(tabPanel);
            tabFrame.addTabPanel(n + 1, tabPanel2);
        }
        return tabPanel2;
    }

    public static void launchTab(TabFrame tabFrame, int n, Point point) {
        if (tabFrame == null) {
            return;
        }
        int n2 = tabFrame.getTabPanelCount();
        if (n2 <= 1 || n == -1) {
            return;
        }
        TabPanel tabPanel = tabFrame.getTabPanelAt(n);
        tabFrame.removeTabPanelAt(n);
        TabFrame tabFrame2 = new TabFrame(tabPanel);
        tabFrame2.pack();
        tabFrame2.setLocation(point);
        tabFrame2.setVisible(true);
    }

    public static void transferTab(TabFrame tabFrame, int n, TabFrame tabFrame2) {
        if (tabFrame == null) {
            return;
        }
        if (tabFrame2 == null) {
            return;
        }
        int n2 = tabFrame.getTabPanelCount();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("Bad tab index: " + n + ", tabCount = " + n2);
        }
        TabPanel tabPanel = tabFrame.getTabPanelAt(n);
        tabFrame.removeTabPanelAt(n);
        tabFrame2.addTabPanel(tabPanel);
    }

    public static void constructViewMenu(AppFrame appFrame, JMenu jMenu) {
        for (Map.Entry<Integer, AppFrame> entry : idFrameMap.entrySet()) {
            AppFrame appFrame2 = entry.getValue();
            TabUtils.addTabMenu(jMenu, appFrame, appFrame2);
        }
    }

    private static boolean checkForGameOver() {
        return idFrameMap.values().size() == 0 && Main.isRemote() && !Main.isGadget();
    }

    private static void addTabMenu(JMenu jMenu, AppFrame appFrame, final AppFrame appFrame2) {
        String string = appFrame2.getTitle();
        if (appFrame.id == appFrame2.id) {
            string = string + " *";
        }
        JMenuItem jMenuItem = new JMenuItem(string);
        WindowTreeIcon windowTreeIcon = new WindowTreeIcon(jMenuItem, 0, new int[0]);
        jMenuItem.setIcon(windowTreeIcon);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                appFrame2.setVisible(true);
                appFrame2.toFront();
            }
        };
        jMenuItem.addActionListener(abstractAction);
        jMenu.add(jMenuItem);
        if (appFrame2 instanceof TabFrame) {
            TabFrame tabFrame = (TabFrame)appFrame2;
            int n = tabFrame.getTabPanelCount();
            for (int i = 0; i < n; ++i) {
                boolean bl = i + 1 == n;
                TabUtils.addTabMenuItem(jMenu, appFrame, tabFrame, i, bl);
            }
        }
    }

    private static void addTabMenuItem(JMenu jMenu, AppFrame appFrame, final TabFrame tabFrame, final int n, boolean bl) {
        TabPanel tabPanel = tabFrame.getTabPanelAt(n);
        String string = tabPanel.title;
        JMenuItem jMenuItem = new JMenuItem(string);
        int[] nArray = new int[]{1};
        WindowTreeIcon windowTreeIcon = new WindowTreeIcon(jMenuItem, 1, bl ? new int[]{} : nArray);
        jMenuItem.setIcon(windowTreeIcon);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                tabFrame.focusTabPanelAt(n);
                tabFrame.toFront();
            }
        };
        jMenuItem.addActionListener(abstractAction);
        jMenu.add(jMenuItem);
    }

    public static void closeAll() {
        AppFrame[] appFrameArray;
        Collection<AppFrame> collection = idFrameMap.values();
        for (AppFrame appFrame : appFrameArray = collection.toArray(new AppFrame[idFrameMap.size()])) {
            appFrame.setVisible(false);
            appFrame.dispose();
        }
    }
}

