/*
 * Decompiled with CFR 0.152.
 */
package g2d.swing;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JMenuItem;

public class WindowTreeIcon
implements Icon {
    private int height = 10;
    private int depth;
    private static final int widthInc = 15;
    private int[] branches;

    public WindowTreeIcon(JMenuItem jMenuItem, int n, int[] nArray) {
        this.depth = n;
        this.height = jMenuItem.getFontMetrics(jMenuItem.getFont()).getHeight();
        this.branches = nArray;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.depth > 0 && component instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)component;
            int n3 = jMenuItem.getIconTextGap();
            int n4 = n + (this.depth - 1) * 15 + n3 + 2;
            int n5 = n2 + this.getIconHeight() / 2;
            graphics.drawPolyline(new int[]{n4, n4, n + this.getIconWidth()}, new int[]{n2, n5, n5}, 3);
            for (int i = 0; i < this.branches.length; ++i) {
                int n6 = n + (this.branches[i] - 1) * 15 + n3 + 2;
                graphics.drawPolyline(new int[]{n6, n6}, new int[]{n2, n2 + this.getIconHeight()}, 2);
            }
        }
    }

    @Override
    public int getIconWidth() {
        return this.depth * 15;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }
}

