/*
 * Decompiled with CFR 0.152.
 */
package g2d.swing;

import g2d.glyph.Glyphish;
import g2d.graph.IOPGraph;
import g2d.jlambda.Closure;
import g2d.swing.IOPComponent;
import g2d.swing.IOPMenuItem;
import g2d.swing.IOPScrollPane;
import g2d.swing.IOPTextMenu;
import g2d.swing.IOPToolBar;
import g2d.swing.ZoomListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IOPView
extends JComponent
implements ZoomListener,
ChangeListener {
    private IOPToolBar toolBar = null;
    private IOPComponent iopComponent = null;
    private IOPScrollPane scrollIOP = null;
    private JPanel outputPanel = null;
    private JSplitPane splitPane;
    private HashSet<ZoomListener> listeners = new HashSet();

    public IOPView() {
        this(false, false, false);
    }

    public IOPView(Glyphish glyphish) {
        this();
        this.add(glyphish);
    }

    public IOPView(boolean bl, boolean bl2) {
        this(bl, bl2, false);
    }

    public IOPView(Glyphish glyphish, AffineTransform affineTransform) {
        this();
        this.add(glyphish, affineTransform);
    }

    public IOPView(boolean bl, boolean bl2, boolean bl3) {
        this.setLayout(new BorderLayout());
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setPreferredSize(new Dimension((int)((double)dimension.width * 0.4), (int)((double)dimension.height * 0.9)));
        this.iopComponent = new IOPComponent();
        this.iopComponent.setBackground(Color.white);
        this.iopComponent.addZoomListener(this);
        this.scrollIOP = new IOPScrollPane(this.iopComponent);
        if (!bl) {
            this.scrollIOP.setVerticalScrollBarPolicy(21);
            this.scrollIOP.setHorizontalScrollBarPolicy(31);
        }
        this.scrollIOP.setBackground(Color.white);
        this.scrollIOP.getViewport().setBackground(Color.white);
        this.add((Component)this.scrollIOP, "Center");
        if (bl3) {
            this.addOutput();
        }
        if (bl2) {
            this.addToolBar();
        }
        this.revalidate();
    }

    public IOPView(Glyphish glyphish, boolean bl, boolean bl2) {
        this(bl, bl2, false);
        this.add(glyphish);
    }

    public IOPView(Glyphish glyphish, boolean bl, boolean bl2, boolean bl3) {
        this(bl, bl2, bl3);
        this.add(glyphish);
    }

    public IOPComponent getIOPComponent() {
        return this.iopComponent;
    }

    public IOPToolBar getToolBar() {
        return this.toolBar;
    }

    public IOPScrollPane getScrollPane() {
        return this.scrollIOP;
    }

    public void addToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new IOPToolBar(this);
            this.add((Component)this.toolBar, "After");
            this.iopComponent.addMouseWheelListener(this.iopComponent);
            this.revalidate();
        }
    }

    public void addButton(AbstractButton abstractButton) {
        if (this.toolBar != null) {
            this.toolBar.add(abstractButton);
        }
    }

    public void addButton(AbstractButton abstractButton, int n) {
        if (this.toolBar != null) {
            this.toolBar.add((Component)abstractButton, n);
        }
    }

    public void addOutput() {
        if (this.outputPanel == null) {
            this.remove(this.scrollIOP);
            this.outputPanel = new JPanel();
            this.splitPane = new JSplitPane(0, this.scrollIOP, this.outputPanel);
            this.splitPane.setContinuousLayout(true);
            this.scrollIOP.setMinimumSize(new Dimension(0, 0));
            this.splitPane.setResizeWeight(1.0);
            this.add((Component)this.splitPane, "Center");
            this.revalidate();
        }
    }

    public void clearOutput() {
        this.updateOutput(new JPanel());
    }

    public void displayText(String string, String string2, boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 5));
        jPanel.add((Component)new JLabel(string), "First");
        JTextArea jTextArea = new JTextArea(string2);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(false);
        jTextArea.setRows(4);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setBackground(Color.white);
        Dimension dimension = jScrollPane.getPreferredSize();
        jScrollPane.setMinimumSize(dimension);
        jPanel.add((Component)jScrollPane, "Center");
        if (bl) {
            JPanel jPanel2 = new JPanel(new FlowLayout(4));
            CloseAction closeAction = new CloseAction();
            JButton jButton = new JButton(closeAction);
            jButton.setSelected(true);
            jButton.getInputMap(2).put(KeyStroke.getKeyStroke("ENTER"), "closeOutput");
            jButton.getActionMap().put("closeOutput", closeAction);
            this.propagateMaps(jButton.getInputMap(2), jButton.getActionMap());
            jPanel2.add(jButton);
            jPanel.add((Component)jPanel2, "Last");
        }
        this.updateOutput(jPanel);
    }

    public void displayTextMenu(String string, List<?> list) {
        IOPTextMenu iOPTextMenu = new IOPTextMenu(string, list);
        this.updateOutput(iOPTextMenu);
        this.propagateMaps(iOPTextMenu.getInputMap(2), iOPTextMenu.getActionMap());
    }

    private void propagateMaps(InputMap inputMap, ActionMap actionMap) {
        Window window = SwingUtilities.getWindowAncestor(this);
        Window[] windowArray = window.getOwnedWindows();
        block0: for (int i = 0; i < windowArray.length; ++i) {
            Component[] componentArray = windowArray[i].getComponents();
            for (int j = 0; j < componentArray.length; ++j) {
                if (!(componentArray[j] instanceof JComponent)) continue;
                ((JComponent)componentArray[j]).setInputMap(2, inputMap);
                ((JComponent)componentArray[j]).setActionMap(actionMap);
                continue block0;
            }
        }
    }

    private void updateOutput(JPanel jPanel) {
        if (this.outputPanel != null) {
            this.splitPane.remove(this.outputPanel);
            this.outputPanel = jPanel;
            this.splitPane.setBottomComponent(this.outputPanel);
            this.splitPane.resetToPreferredSizes();
            this.revalidate();
            this.repaint();
        }
    }

    public void addMItem(IOPMenuItem iOPMenuItem) {
        if (this.outputPanel instanceof IOPTextMenu) {
            ((IOPTextMenu)this.outputPanel).addMItem(iOPMenuItem);
        }
    }

    public void setGraph(IOPGraph iOPGraph) {
        this.iopComponent.setGraph(iOPGraph);
        iOPGraph.addChangeListener(this);
        this.iopComponent.checkSize();
        this.revalidate();
    }

    public void add(Glyphish glyphish) {
        this.iopComponent.add(glyphish);
        if (glyphish instanceof IOPGraph) {
            ((IOPGraph)glyphish).addChangeListener(this);
        }
        this.iopComponent.checkSize();
        this.revalidate();
    }

    public void add(Glyphish glyphish, AffineTransform affineTransform) {
        glyphish.transform(affineTransform);
        this.add(glyphish);
    }

    public void remove(Glyphish glyphish) {
        this.iopComponent.remove(glyphish);
        if (glyphish instanceof IOPGraph) {
            ((IOPGraph)glyphish).removeChangeListener(this);
        }
    }

    public void addZoomListener(ZoomListener zoomListener) {
        this.listeners.add(zoomListener);
    }

    public void removeZoomListener(ZoomListener zoomListener) {
        this.listeners.remove(zoomListener);
    }

    @Override
    public void zoomChanged(double d) {
        Iterator<ZoomListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().zoomChanged(d);
        }
    }

    public double getZoom() {
        return this.iopComponent.getZoomScale();
    }

    public void zoom(double d) {
        this.iopComponent.zoom(d);
    }

    public void zoomIn() {
        this.iopComponent.zoom(1.2);
    }

    public void zoomOut() {
        this.iopComponent.zoom(0.8);
    }

    public void zoomToFit() {
        Dimension dimension = this.getVisible();
        this.iopComponent.zoomToFit(dimension.width, dimension.height);
    }

    public void zoomToFit(Rectangle2D rectangle2D) {
        Dimension dimension = this.getVisible();
        this.iopComponent.zoomToFit(dimension.width, dimension.height, rectangle2D);
    }

    public void zoomToFit(double d, double d2) {
        this.iopComponent.zoomToFit(d, d2);
    }

    public void setMouseAction(int n, Closure closure) {
        this.iopComponent.setMouseAction(n, closure);
    }

    public void setKeyAction(int n, Closure closure) {
        this.iopComponent.setKeyAction(n, closure);
    }

    public void centerOn(Glyphish glyphish) {
        this.iopComponent.centerOn(glyphish.getBounds());
    }

    public void centerOn(Rectangle2D rectangle2D) {
        this.iopComponent.centerOn(rectangle2D);
    }

    public Dimension getVisible() {
        Dimension dimension = this.scrollIOP.getViewport().getExtentSize();
        dimension.width -= 5;
        dimension.height -= 5;
        return dimension;
    }

    public void setPreferredSize(int n, int n2) {
        this.setPreferredSize(new Dimension(n, n2));
    }

    public void checkSize() {
        this.iopComponent.checkSize();
    }

    @Override
    public void requestFocus() {
        this.iopComponent.requestFocus();
    }

    public Point2D zoomPoint(MouseEvent mouseEvent) {
        return this.iopComponent.zoomPoint(mouseEvent);
    }

    public Rectangle2D zoomBound(Rectangle2D rectangle2D) {
        return this.iopComponent.zoomBound(rectangle2D);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.repaint();
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super("Close Info");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IOPView.this.clearOutput();
        }
    }
}

