/*
 * Decompiled with CFR 0.152.
 */
package g2d.swing;

import g2d.swing.IOPComponent;
import g2d.swing.IOPView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;

public class IOPFrame
extends JFrame {
    public IOPFrame(String string) {
        super(string);
        this.getContentPane().setLayout(new BorderLayout());
    }

    public IOPFrame(String string, int n, int n2) {
        super(string);
        this.getContentPane().setLayout(new BorderLayout(n, n2));
    }

    public IOPFrame(String string, IOPView iOPView) {
        this(string);
        this.add(iOPView);
    }

    public IOPFrame(String string, IOPComponent iOPComponent) {
        this(string);
        this.add(iOPComponent);
    }

    public void add(IOPView iOPView) {
        this.getContentPane().add((Component)iOPView, "Center");
        this.validate();
        this.configure();
    }

    public void add(IOPView iOPView, String string) {
        this.getContentPane().add((Component)iOPView, string);
        this.validate();
        this.configure();
    }

    public void add(IOPView iOPView, int n) {
        this.getContentPane().add((Component)iOPView, n);
        this.validate();
        this.configure();
    }

    private void configure() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                IOPFrame.this.dispose();
            }
        });
        this.pack();
    }

    public void setSize(double d, double d2) {
        super.setSize((int)d, (int)d2);
    }

    public void setSize(Rectangle2D rectangle2D, double d) {
        Dimension dimension = this.getScreenSize();
        double d2 = d / 100.0 * (double)dimension.height;
        double d3 = rectangle2D.getHeight() - d2;
        double d4 = d3 < 0.0 ? rectangle2D.getHeight() : d2;
        double d5 = d4 / rectangle2D.getHeight() * rectangle2D.getWidth();
        this.setSize(d5, d4);
    }

    public Dimension getScreenSize() {
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        return new Dimension(rectangle.width, rectangle.height);
    }
}

