/*
 * Decompiled with CFR 0.152.
 */
package g2d.swing;

import g2d.graph.Dot;
import g2d.graph.GraphContainer;
import g2d.graph.IOPGraph;
import g2d.swing.IOPFileChooser;
import g2d.swing.ImageFilter;
import g2d.tabwin.TabFrame;
import g2d.tabwin.TabUtils;
import g2d.util.IO;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class ExportMenu
extends JMenu {
    private final GraphContainer panel;
    private IOPFileChooser chooser = new IOPFileChooser("graph_area", "graph_format", "graph_file");
    private FileFilter epsFilter = new ImageFilter("Encapsulated PostScript (*.eps)", Dot.DotFormat.EPS);
    private FileFilter pngFilter = new ImageFilter("Portable Network Graphics (*.png)", Dot.DotFormat.PNG);
    private FileFilter jpgFilter = new ImageFilter("Joint Photographic Experts Group (*.jpg)", Dot.DotFormat.JPG);
    private FileFilter dotFilter = new ImageFilter("Dot's native format (*.xdot)", Dot.DotFormat.DOT);
    private FileFilter svgFilter = new ImageFilter("Scalable vector graphics format (*.svg)", Dot.DotFormat.SVG);

    public ExportMenu(GraphContainer graphContainer) {
        super("Export");
        this.panel = graphContainer;
        this.setMnemonic(70);
        this.chooser.setDialogTitle("Export Graph As Image");
        this.chooser.setMultiSelectionEnabled(false);
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.addChoosableFileFilter(this.pngFilter);
        this.chooser.addChoosableFileFilter(this.jpgFilter);
        this.chooser.addChoosableFileFilter(this.dotFilter);
        this.chooser.addChoosableFileFilter(this.epsFilter);
        this.chooser.addChoosableFileFilter(this.svgFilter);
        this.chooser.situate();
        JMenuItem jMenuItem = new JMenuItem("Export Image...", 69);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IOPGraph iOPGraph = ExportMenu.this.panel.getGraph();
                if (iOPGraph == null) {
                    return;
                }
                TabFrame tabFrame = TabUtils.getTabFrame(ExportMenu.this.panel);
                int n = ExportMenu.this.chooser.showDialog(tabFrame, "Export");
                if (n != 0) {
                    return;
                }
                File file = ExportMenu.this.chooser.getSelectedFile();
                boolean bl = false;
                Dot.DotFormat dotFormat = Dot.DEFAULT_DOT_FORMAT;
                for (FileFilter fileFilter : ExportMenu.this.chooser.getChoosableFileFilters()) {
                    if (!fileFilter.accept(file)) continue;
                    dotFormat = ((ImageFilter)fileFilter).getType();
                    bl = true;
                    break;
                }
                if (!bl) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(tabFrame, "Cannot export to unknown file type of chosen file \"" + file.getName() + "\"", "Error", 0);
                } else {
                    String string = iOPGraph.makeDotInput();
                    if (dotFormat != Dot.DEFAULT_DOT_FORMAT) {
                        String string2 = Dot.askDot(dotFormat, string);
                        if (dotFormat.fileType == Dot.FileType.BINARY) {
                            IO.b64String2File(string2, file);
                        } else {
                            IO.string2File(string2, file);
                        }
                    } else {
                        IO.string2File(string, file);
                    }
                }
            }
        });
        this.add(jMenuItem);
    }
}

