/*
 * Decompiled with CFR 0.152.
 */
package g2d.subset;

import g2d.subset.Basis;
import g2d.subset.Binary;
import g2d.subset.DEvent;
import g2d.subset.Dictionary;
import g2d.subset.SEvent;
import g2d.subset.SListener;
import g2d.subset.StateSpace;
import g2d.subset.Urelement;
import g2d.util.IO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Universe {
    private Basis basis;
    public static final String LEXICAL = "Lexical";
    public static final String SPATIAL = "Spatial";
    private ArrayList<SListener> listeners = new ArrayList();
    private Dictionary index;
    protected int stringMax = 0;
    protected ArrayList<Urelement> universe;
    protected HashMap<String, Urelement> characteristic;
    protected StateSpace states;
    protected String name;

    public boolean hasBasis() {
        return this.basis != null;
    }

    public boolean basisAdd(String string) {
        return this.basis == null ? false : this.basis.add(string);
    }

    public boolean basisRemove(String string) {
        return this.basis == null ? false : this.basis.remove(string);
    }

    public boolean isDisabled(String string) {
        return this.basis == null ? false : this.basis.isDisabled(string);
    }

    public String basisAdd(ArrayList<Urelement> arrayList) {
        String string = null;
        if (this.basis == null) {
            return string;
        }
        boolean bl = false;
        int n = 0;
        for (Urelement urelement : arrayList) {
            if (bl) continue;
            String string2 = urelement.thing.toString();
            if (!this.basis.add(string2)) {
                string = string2;
                bl = true;
                continue;
            }
            ++n;
        }
        if (bl) {
            for (int i = arrayList.size() - 1; i >= n; --i) {
                arrayList.remove(i);
            }
        }
        return string;
    }

    private void init(Object[] objectArray) {
        this.stringMax = 0;
        this.universe = new ArrayList(objectArray.length);
        this.characteristic = new HashMap();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = objectArray[i].toString();
            int n = string.length();
            if (this.stringMax < n) {
                this.stringMax = n;
            }
            Urelement urelement = new Urelement(objectArray[i], i, this);
            this.universe.add(urelement);
            if (this.characteristic.containsKey(string)) {
                IO.err.println("Warning: Universe.init saw a duplicate entry " + string);
            }
            this.characteristic.put(string, urelement);
        }
        this.index = new Dictionary(this);
    }

    public Universe(String[] stringArray, String[] stringArray2, StateSpace stateSpace) {
        this.states = stateSpace;
        this.basis = new Basis(stringArray, stringArray2);
        this.init(stringArray);
    }

    public Universe(String[] stringArray, String[] stringArray2) {
        this.states = new Binary();
        this.basis = new Basis(stringArray, stringArray2);
        this.init(stringArray);
    }

    public Universe(String[] stringArray, String[][] stringArray2) {
        this.states = new Binary();
        this.basis = new Basis(stringArray, stringArray2);
        this.init(stringArray);
    }

    public Universe(Object[] objectArray, StateSpace stateSpace) {
        this.states = stateSpace;
        this.init(objectArray);
    }

    public Universe(Object[] objectArray) {
        this.states = new Binary();
        this.init(objectArray);
    }

    public ArrayList<Urelement> intersect(String[] stringArray) {
        ArrayList<Urelement> arrayList = new ArrayList<Urelement>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Urelement urelement = this.characteristic.get(string);
            if (urelement == null) continue;
            arrayList.add(urelement);
        }
        return arrayList;
    }

    public boolean setState(String string, int n) {
        Urelement urelement = this.characteristic.get(string);
        if (urelement != null) {
            urelement.setState(n);
            this.fireSEvent(new SEvent(urelement));
            return true;
        }
        return false;
    }

    private void delete(Urelement urelement) {
        this.characteristic.remove(urelement.toString());
        this.universe.remove(urelement);
        this.index.delete(urelement);
    }

    private void delete(ArrayList<Urelement> arrayList) {
        Iterator<Urelement> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.delete(iterator.next());
        }
    }

    private void insert(Urelement urelement) {
        int n = this.universe.size();
        for (int i = 0; i < n; ++i) {
            if (urelement.compareTo(this.universe.get(i)) >= 0) continue;
            this.universe.add(i, urelement);
            return;
        }
        this.universe.add(urelement);
    }

    private void add(Urelement urelement) {
        urelement.universe = this;
        if (this.basis != null) {
            this.basis.remove(urelement.thing.toString());
        }
        this.insert(urelement);
        this.characteristic.put(urelement.thing.toString(), urelement);
        this.index.insert(urelement);
    }

    private void add(ArrayList<Urelement> arrayList) {
        Iterator<Urelement> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public void add(Universe universe, int n) {
        ArrayList<Urelement> arrayList = universe.universe;
        int n2 = this.universe.size();
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            Urelement urelement = arrayList.get(i);
            if (urelement.getState() != n) continue;
            String string = urelement.thing.toString();
            if (this.characteristic.containsKey(string)) {
                IO.err.println("Warning: Universe.add duplicating entry " + string);
            }
            Urelement urelement2 = new Urelement(urelement, n2);
            this.add(urelement2);
            ++n2;
        }
    }

    public ArrayList<Urelement> beginsWith(String string) {
        return this.index.beginsWith(string);
    }

    public int getValency() {
        return StateSpace.valency;
    }

    public Object[] getSubset(int n) {
        int n2 = this.universe.size();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < n2; ++i) {
            Urelement urelement = this.universe.get(i);
            if (urelement == null || n != urelement.getState()) continue;
            arrayList.add(urelement.thing);
        }
        return arrayList.toArray();
    }

    private int getCount(int n) {
        int n2 = 0;
        int n3 = this.universe.size();
        for (int i = 0; i < n3; ++i) {
            Urelement urelement = this.universe.get(i);
            if (urelement == null || n != urelement.getState()) continue;
            ++n2;
        }
        return n2;
    }

    public ArrayList<Urelement> getSlice() {
        return this.getSlice(0);
    }

    public ArrayList<Urelement> getSlice(int n) {
        ArrayList<Urelement> arrayList = new ArrayList<Urelement>();
        for (Urelement urelement : this.universe) {
            if (urelement.getState() != n) continue;
            arrayList.add(new Urelement(urelement, 0));
        }
        return arrayList;
    }

    public String[] getStrings() {
        return this.getStrings(0);
    }

    public String[] getStrings(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Urelement urelement : this.universe) {
            if (urelement.getState() != n) continue;
            arrayList.add(urelement.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public int[] getIndices(int n) {
        int n2 = 0;
        int n3 = this.universe.size();
        int[] nArray = new int[this.getCount(n)];
        for (int i = 0; i < n3; ++i) {
            Urelement urelement = this.universe.get(i);
            if (urelement == null || n != urelement.getState()) continue;
            nArray[n2++] = i;
        }
        return nArray;
    }

    public Urelement getUrelement(int n) {
        if (0 <= n && n < this.universe.size()) {
            return this.universe.get(n);
        }
        return null;
    }

    public String toString() {
        int n;
        String string = "";
        int n2 = n = 0;
        do {
            string = string + "state = " + n2 + ": " + this.toString(n2) + "\n";
        } while ((n2 = this.states.next(n2)) != n);
        return string;
    }

    public String toString(int n) {
        Object[] objectArray = this.getSubset(n);
        String string = "{";
        for (int i = 0; i < objectArray.length; ++i) {
            string = string + objectArray[i].toString();
            if (i >= objectArray.length - 1) continue;
            string = string + " ";
        }
        string = string + "}";
        return string;
    }

    public void createSpatial() {
        for (Urelement urelement : this.universe) {
            String string = urelement.toString();
            int n = string.lastIndexOf(45);
            if (n == -1) continue;
            String string2 = string.substring(n + 1);
            urelement.classify(SPATIAL, string2);
        }
    }

    public void createLexical() {
        for (Urelement urelement : this.universe) {
            String string = urelement.toString();
            Character c = new Character(Character.toUpperCase(string.charAt(0)));
            urelement.classify(LEXICAL, c.toString());
        }
    }

    public void classify(String string, String[] stringArray, String[] stringArray2) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                Urelement urelement = this.characteristic.get(stringArray[i]);
                if (urelement == null) continue;
                urelement.classify(string, stringArray2[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSListener(SListener sListener) {
        ArrayList<SListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(sListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSListener(SListener sListener) {
        ArrayList<SListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(sListener);
        }
    }

    public void fireDEvent(DEvent dEvent) {
        switch (dEvent.type) {
            case 1: {
                this.add(dEvent.slice);
                break;
            }
            case 2: {
                this.delete(dEvent.slice);
            }
        }
        this.fireSEvent(new SEvent(dEvent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSEvent(SEvent sEvent) {
        ArrayList<SListener> arrayList = this.listeners;
        synchronized (arrayList) {
            Iterator<SListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().eventOccured(sEvent);
            }
        }
    }
}

