/*
 * Decompiled with CFR 0.152.
 */
package g2d.subset;

import g2d.subset.DEvent;
import g2d.subset.SEvent;
import g2d.subset.SListener;
import g2d.subset.STreeCellRenderer;
import g2d.subset.Universe;
import g2d.subset.Urelement;
import g2d.util.IO;
import g2d.util.Orderings;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class STree
extends JTree
implements TreeSelectionListener,
SListener {
    private HashMap<String, DefaultMutableTreeNode> categories;
    private DefaultTreeModel model;
    private boolean seeEvents = false;
    protected Universe universe;
    protected DefaultMutableTreeNode root;
    protected String tab;
    protected Comparator<Object> order = Orderings.LEXICAL_CASE_INSENSITIVE;

    public STree(String string, Universe universe) {
        this(universe, new DefaultMutableTreeNode(string), true, null);
    }

    public STree(String string, Universe universe, Comparator<Object> comparator) {
        this(universe, new DefaultMutableTreeNode(string), true, comparator);
    }

    public STree(String string, Universe universe, boolean bl) {
        this(universe, new DefaultMutableTreeNode(string), bl, null);
    }

    private STree(Universe universe, DefaultMutableTreeNode defaultMutableTreeNode, boolean bl, Comparator<Object> comparator) {
        super(defaultMutableTreeNode);
        this.root = defaultMutableTreeNode;
        this.universe = universe;
        if (comparator != null) {
            this.order = comparator;
        }
        this.categories = new HashMap();
        this.model = (DefaultTreeModel)this.getModel();
        this.model.setAsksAllowsChildren(true);
        this.addMouseListener(new STreeMouseListener());
        this.setCellRenderer(new STreeCellRenderer());
        this.getSelectionModel().setSelectionMode(4);
        this.addTreeSelectionListener(this);
        if (bl) {
            universe.addSListener(this);
        }
    }

    private void insert(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        DefaultMutableTreeNode defaultMutableTreeNode3;
        Object object;
        int n = 0;
        Object object2 = defaultMutableTreeNode2.getUserObject();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements() && Orderings.INTEGRAL_PREFIX.compare(object2, object = (defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement()).getUserObject()) >= 0) {
            ++n;
        }
        defaultMutableTreeNode.insert(defaultMutableTreeNode2, n);
    }

    public boolean addCategory(String string, int[] nArray) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        this.categories.put(string, defaultMutableTreeNode);
        for (int i = 0; i < nArray.length; ++i) {
            Urelement urelement = this.universe.getUrelement(nArray[i]);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(urelement);
            defaultMutableTreeNode2.setAllowsChildren(false);
            this.insert(defaultMutableTreeNode, defaultMutableTreeNode2);
        }
        this.insert(this.root, defaultMutableTreeNode);
        this.reset(this.root);
        return true;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Urelement urelement;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode.isLeaf() && object instanceof Urelement && ((urelement = (Urelement)object).isSelected() || !urelement.isDisabled())) {
            urelement.nextState();
            this.universe.fireSEvent(new SEvent(urelement));
            this.clearSelection();
        }
    }

    private void fireDEvent(ArrayList<Urelement> arrayList, int n) {
        switch (n) {
            case 1: {
                this.add(arrayList);
                break;
            }
            case 2: {
                this.delete(arrayList);
            }
        }
    }

    private void add(ArrayList<Urelement> arrayList) {
        Iterator<Urelement> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    private void delete(ArrayList<Urelement> arrayList) {
        if (this.seeEvents) {
            IO.err.println(this.toString() + ".delete(" + arrayList + ")");
        }
        for (Urelement urelement : arrayList) {
            this.delete(urelement);
        }
    }

    private void delete(Urelement urelement) {
        String string;
        if (this.seeEvents) {
            IO.err.println(this.toString() + ".delete(" + urelement + ")");
        }
        if ((string = urelement.getCategory(this.tab)) == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.categories.get(string);
        if (defaultMutableTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            Urelement urelement2;
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
            Object object = defaultMutableTreeNode3.getUserObject();
            if (!(object instanceof Urelement) || !(urelement2 = (Urelement)object).equals(urelement)) continue;
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
            break;
        }
        if (defaultMutableTreeNode2 != null) {
            if (this.seeEvents) {
                IO.err.println("Removing child!");
            }
            defaultMutableTreeNode.remove(defaultMutableTreeNode2);
            this.reset(defaultMutableTreeNode);
        }
        if (defaultMutableTreeNode.getChildCount() == 0) {
            if (this.seeEvents) {
                IO.err.println("Removing category!");
            }
            this.categories.remove(string);
            this.root.remove(defaultMutableTreeNode);
            this.reset(this.root);
        }
    }

    private void rebuild(SEvent sEvent) {
        DEvent dEvent = sEvent.cause();
        if (dEvent != null) {
            this.fireDEvent(dEvent.slice, dEvent.type);
        }
    }

    private void add(Urelement urelement) {
        Urelement urelement2;
        String string = urelement.getCategory(this.tab);
        if (string == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.categories.get(string);
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = new DefaultMutableTreeNode(string);
            this.categories.put(string, defaultMutableTreeNode);
            this.insert(this.root, defaultMutableTreeNode);
            this.reset(this.root);
        }
        if ((urelement2 = this.universe.characteristic.get(urelement.thing.toString())) != null) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(urelement2);
            defaultMutableTreeNode2.setAllowsChildren(false);
            this.insert(defaultMutableTreeNode, defaultMutableTreeNode2);
            this.reset(defaultMutableTreeNode);
        } else {
            IO.err.println("Urelement " + urelement + " has no clone in this world: " + this.universe.name);
        }
    }

    private void reset(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.model.nodeStructureChanged(defaultMutableTreeNode);
    }

    @Override
    public String toString() {
        return this.universe.name + ".STree(" + this.tab + ")";
    }

    @Override
    public void eventOccured(SEvent sEvent) {
        if (this.seeEvents) {
            IO.err.println(this.toString() + ".eventOccured(" + sEvent + ");");
        }
        if (sEvent.drastic) {
            this.rebuild(sEvent);
        }
        this.repaint();
    }

    public class STreeMouseListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!STree.this.universe.hasBasis()) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                int n3 = STree.this.getRowForLocation(n, n2);
                TreePath treePath = STree.this.getPathForLocation(n, n2);
                if (treePath != null) {
                    TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                    STreePopupMenu sTreePopupMenu = new STreePopupMenu(treeNode);
                    if (n3 != -1) {
                        if (mouseEvent.getClickCount() == 1) {
                            if (!treeNode.isLeaf()) {
                                sTreePopupMenu.show(STree.this, n, n2);
                            }
                        } else if (mouseEvent.getClickCount() == 2) {
                            // empty if block
                        }
                    }
                }
            }
        }
    }

    public class STreePopupMenu
    extends JPopupMenu {
        private final String[] items = new String[]{"All", "Invert", "None"};
        private TreeNode node;

        public STreePopupMenu(TreeNode treeNode) {
            this.node = treeNode;
            for (int i = 0; i < this.items.length; ++i) {
                final String string = this.items[i];
                this.add(new AbstractAction(string){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        STreePopupMenu.this.doSelection(string);
                    }
                });
            }
        }

        public void doSelection(Urelement urelement, String string) {
            if (string == "All") {
                urelement.setState();
            } else if (string == "None") {
                urelement.setState(0);
            } else if (string == "Invert") {
                urelement.toggleState();
            }
        }

        public void doSelection(TreeNode treeNode, String string) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                Object object = defaultMutableTreeNode.getUserObject();
                if (object instanceof Urelement) {
                    this.doSelection((Urelement)object, string);
                    continue;
                }
                this.doSelection(defaultMutableTreeNode, string);
            }
        }

        public void doSelection(String string) {
            this.doSelection(this.node, string);
            STree.this.universe.fireSEvent(new SEvent());
            STree.this.repaint();
        }
    }
}

