/*
 * Decompiled with CFR 0.152.
 */
package g2d.stats;

import g2d.jlambda.Attributable;
import g2d.jlambda.PrimitiveData;
import g2d.stats.StatisticsImpl;

public class nGenericApprox
extends StatisticsImpl {
    final double epsilon;
    final double delta;
    final int n;
    int rounds;
    double[] accumulator;
    int count = 0;

    public nGenericApprox(String string, double d, double d2, int n) {
        super(string);
        this.epsilon = d;
        this.delta = d2;
        this.n = n;
        this.accumulator = new double[this.n];
        this.rounds = (int)Math.ceil(Math.log(2.0 / d2) / (2.0 * d * d));
    }

    @Override
    public void recordRunResult(Object object) {
        super.recordRunResult(object);
        if (this.done()) {
            return;
        }
        System.err.println("value = " + object);
        if (object instanceof double[]) {
            this.recordRunResult((double[])object);
        } else if (object instanceof Object[]) {
            this.recordRunResult((Object[])object);
        } else if (object instanceof String[]) {
            this.recordRunResult((String[])object);
        } else {
            System.err.format("nGenericApprox.recordRunResult API violation. Need either double[] String[] or Object[] of length  %d\n", this.n);
        }
    }

    private void recordRunResult(double[] dArray) {
        if (dArray.length != this.n) {
            System.err.format("nGenericApprox.recordRunResult API violation. Array of length %d passed in, but not of required length %d\n", dArray.length, this.n);
        }
        for (int i = 0; i < this.n; ++i) {
            int n = i;
            this.accumulator[n] = this.accumulator[n] + dArray[i];
        }
        ++this.count;
    }

    private void recordRunResult(Object[] objectArray) {
        if (objectArray.length != this.n) {
            System.err.format("nGenericApprox.recordRunResult API violation. Array of length %d passed in, but not of required length %d\n", objectArray.length, this.n);
        }
        for (int i = 0; i < this.n; ++i) {
            Object object = objectArray[i];
            if (object instanceof Double) {
                int n = i;
                this.accumulator[n] = this.accumulator[n] + (Double)object;
                continue;
            }
            if (objectArray[i] instanceof PrimitiveData) {
                int n = i;
                this.accumulator[n] = this.accumulator[n] + (Double)PrimitiveData.unwrap(object);
                continue;
            }
            System.err.println("nGenericApprox.recordRunResult API violation. Mystery object: " + object);
        }
        ++this.count;
    }

    private void recordRunResult(String[] stringArray) {
        if (stringArray.length != this.n) {
            System.err.format("nGenericApprox.recordRunResult API violation. Array of length %d passed in, but not of required length %d\n", stringArray.length, this.n);
        }
        for (int i = 0; i < this.n; ++i) {
            int n = i;
            this.accumulator[n] = this.accumulator[n] + Double.parseDouble(stringArray[i]);
        }
        ++this.count;
    }

    @Override
    public boolean done() {
        super.done();
        return this.count >= this.rounds;
    }

    @Override
    public Attributable summary() {
        Attributable attributable = super.summary();
        Double[] doubleArray = new Double[this.n];
        for (int i = 0; i < this.n; ++i) {
            doubleArray[i] = new Double(this.accumulator[i] / (double)this.count);
            attributable.setAttribute("average_" + i, doubleArray[i]);
        }
        if (this.count > 0) {
            attributable.setAttribute("averages", doubleArray);
            attributable.setAttribute("accumulator", this.accumulator);
            attributable.setAttribute("rounds", new Integer(this.rounds));
            attributable.setAttribute("count", new Integer(this.count));
        }
        return attributable;
    }
}

