/*
 * Decompiled with CFR 0.152.
 */
package g2d.stats;

import g2d.jlambda.Attributable;
import g2d.stats.StatisticsImpl;

public class SeqTestApprox
extends StatisticsImpl {
    final double alpha;
    final double beta;
    final double theta;
    final double delta;
    private final double p0;
    private final double p1;
    private final double a;
    private final double b;
    double accumulator = 0.0;
    int count = 0;
    int h = 0;

    public SeqTestApprox(String string, double d, double d2, double d3, double d4) {
        super(string);
        this.alpha = d;
        this.beta = d2;
        this.theta = d3;
        this.delta = d4;
        this.p0 = d3 + d4;
        this.p1 = d3 - d4;
        this.a = (1.0 - d2) / d;
        this.b = d2 / (1.0 - d);
    }

    @Override
    public void recordRunResult(Object object) {
        super.recordRunResult(object);
        if (this.done()) {
            return;
        }
        if (object instanceof Double) {
            this.accumulator += ((Double)object).doubleValue();
        }
        ++this.count;
    }

    @Override
    public boolean done() {
        super.done();
        int n = (int)this.accumulator;
        double d = Math.pow(this.p1, n) * Math.pow(1.0 - this.p1, this.count - n);
        double d2 = Math.pow(this.p0, n) * Math.pow(1.0 - this.p0, this.count - n);
        double d3 = d / d2;
        if (d3 <= this.b) {
            this.h = 0;
            return true;
        }
        if (d3 >= this.a) {
            this.h = 1;
            return true;
        }
        return false;
    }

    @Override
    public Attributable summary() {
        Attributable attributable = super.summary();
        if (this.count > 0) {
            attributable.setAttribute("h", new Integer(this.h));
            attributable.setAttribute("average", new Double(this.accumulator / (double)this.count));
            attributable.setAttribute("count", new Integer(this.count));
        }
        return attributable;
    }
}

