/*
 * Decompiled with CFR 0.152.
 */
package g2d.stats;

import g2d.jlambda.Attributable;
import g2d.stats.StatisticsImpl;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.stat.StatUtils;

public class QAApprox
extends StatisticsImpl {
    public static boolean debug = false;
    final NormalDistribution normaldist = new NormalDistribution();
    final double alpha;
    final double delta;
    final double pval;
    final double rate;
    final int minsize;
    final int maxsize;
    final double[] val;
    final double[] bval;
    final double zScore;
    double accumulator = 0.0;
    int phase = 1;
    int round = 0;
    int loopcount = 0;
    int loopmax = 0;
    double d;
    boolean isDone = false;

    public QAApprox(String string, double d, double d2, double d3, int n, int n2, double d4) {
        super(string);
        this.alpha = d;
        this.delta = d2;
        this.pval = d3;
        this.rate = d4;
        this.minsize = n;
        this.maxsize = n2;
        this.val = new double[n2];
        this.bval = new double[n2];
        this.zScore = this.normaldist.inverseCumulativeProbability(1.0 - d / 2.0);
    }

    @Override
    public void recordRunResult(Object object) {
        super.recordRunResult(object);
        if (this.done()) {
            return;
        }
        if (object instanceof Double) {
            double d = (Double)object;
            this.accumulator += d;
            this.val[this.round] = d;
            ++this.round;
            if (this.phase != 1 || this.round >= this.minsize) {
                if (this.phase == 1 && this.round == this.minsize) {
                    this.bootstrap();
                    this.phase = 2;
                    return;
                }
                if (this.phase == 2) {
                    if (this.loopmax == 0) {
                        int n = (int)((double)this.round * this.rate);
                        this.loopmax = n > 1 ? n : 1;
                        this.loopcount = 1;
                    } else if (this.loopcount == this.loopmax) {
                        this.bootstrap();
                        if (this.jbTest()) {
                            this.phase = 3;
                            this.d = this.computeD();
                        } else {
                            this.loopmax = 0;
                        }
                    } else {
                        ++this.loopcount;
                    }
                } else if (this.phase == 3) {
                    if (this.loopmax == 0) {
                        int n = (int)((double)this.round * this.rate);
                        this.loopmax = n > 1 ? n : 1;
                        this.loopcount = 1;
                    } else if (this.loopcount == this.loopmax) {
                        this.bootstrap();
                        this.d = this.computeD();
                        if (this.d <= this.delta) {
                            this.phase = 4;
                        } else {
                            this.loopmax = 0;
                        }
                    } else {
                        ++this.loopcount;
                    }
                } else {
                    System.err.println("Illegal recordRunResult: phase = " + this.phase + " loopmax = " + this.loopmax + " loopcount = " + this.loopcount);
                }
            }
        }
    }

    @Override
    public boolean done() {
        super.done();
        return this.round >= this.maxsize || this.phase > 3;
    }

    @Override
    public Attributable summary() {
        Attributable attributable = super.summary();
        if (this.round > 0) {
            attributable.setAttribute("average", new Double(this.accumulator / (double)this.round));
            attributable.setAttribute("round", new Integer(this.round));
            attributable.setAttribute("confidence interval", new Double(this.d));
        }
        return attributable;
    }

    private boolean jbTest() {
        ChiSquaredDistribution chiSquaredDistribution;
        double d;
        double d2 = StatUtils.mean(this.bval, 0, this.round);
        double d3 = StatUtils.variance(this.bval, 0, this.round);
        double d4 = Math.sqrt(d3);
        double d5 = 0.0;
        for (int i = 0; i < this.round; ++i) {
            d5 += Math.pow(this.bval[i] - d2, 3.0);
        }
        double d6 = d5 / (Math.pow(d4, 3.0) * (double)this.round);
        d5 = 0.0;
        for (int i = 0; i < this.round; ++i) {
            d5 += Math.pow(this.bval[i] - d2, 4.0);
        }
        double d7 = d5 / (Math.pow(d4, 4.0) * (double)this.round);
        double d8 = (double)this.round * (Math.pow(d6, 2.0) / 6.0 + Math.pow(d7 - 3.0, 2.0) / 24.0);
        if (debug) {
            System.err.format("mean = %s\nvar = %s\nstddev = %s\nskew = %s\nkurato = %s\njb = %s\n", d2, d3, d4, d6, d7, d8);
        }
        return (d = 1.0 - (chiSquaredDistribution = new ChiSquaredDistribution(2.0)).cumulativeProbability(d8)) >= this.pval;
    }

    private void bootstrap() {
        for (int i = 0; i < this.round; ++i) {
            double d = 0.0;
            for (int j = 0; j < this.round; ++j) {
                d += this.val[(int)(Math.random() * (double)this.round)];
            }
            this.bval[i] = d / (double)this.round;
        }
    }

    private double computeD() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.round; ++i) {
            d += this.bval[i];
            d2 += this.bval[i] * this.bval[i];
        }
        double d3 = this.round;
        double d4 = Math.sqrt((d2 - d * d / d3) / (d3 - 1.0));
        return this.zScore * d4 / Math.sqrt(d3) / (d / d3);
    }
}

