/*
 * Decompiled with CFR 0.152.
 */
package g2d.stats;

import g2d.jlambda.Attributable;
import g2d.stats.StatisticsImpl;

public class OptimalApprox
extends StatisticsImpl {
    final double epsilon;
    final double delta;
    final double c;
    double gamma = 0.0;
    double mu = 0.0;
    int sat;
    int psat;
    int rounds = 0;
    double accumulator = 0.0;
    int phase = 0;
    int count = 0;
    int gcount = 0;
    Attributable retval = new Attributable();

    public OptimalApprox(String string, double d, double d2, double d3) {
        super(string);
        this.epsilon = d;
        this.delta = d2;
        this.c = d3;
        this.rounds = (int)Math.ceil(Math.log(2.0 / d2) / (2.0 * d * d));
    }

    @Override
    public void recordRunResult(Object object) {
        super.recordRunResult(object);
        if (this.done()) {
            return;
        }
        if (this.phase == 0 && this.count == 0) {
            this.phaseChange();
        }
        switch (this.phase) {
            case 1: 
            case 3: {
                if (!(object instanceof Double)) break;
                this.accumulator += ((Double)object).doubleValue();
                break;
            }
            case 2: {
                if (!(object instanceof Double)) break;
                boolean bl = (Double)object > 0.0;
                int n = this.sat = bl ? 1 : 0;
                if (this.count > 1) {
                    this.accumulator += (double)(this.sat - this.psat) * (double)(this.sat - this.psat) / 2.0;
                }
                this.psat = this.sat;
                break;
            }
            default: {
                System.err.println("Illegal recordRunResult\n");
                return;
            }
        }
        ++this.count;
        ++this.gcount;
        if (this.count == this.rounds) {
            this.phaseChange();
        }
    }

    @Override
    public boolean done() {
        super.done();
        return this.phase == 3 && this.count >= this.rounds;
    }

    @Override
    public Attributable summary() {
        Attributable attributable = super.summary();
        if (this.count > 0) {
            attributable.setAttribute("accumulator", new Double(this.accumulator));
            attributable.setAttribute("average", new Double(this.accumulator / (double)this.count));
            attributable.setAttribute("rounds", new Integer(this.rounds));
            attributable.setAttribute("count", new Integer(this.count));
            attributable.setAttribute("phase", new Integer(this.phase));
            attributable.setAttribute("gcount", new Integer(this.gcount));
        }
        return attributable;
    }

    private void phaseChange() {
        switch (this.phase) {
            case 0: {
                this.phase = 1;
                this.rounds = this.phaseOneRounds();
                this.count = 0;
                break;
            }
            case 1: {
                this.phase = 2;
                this.mu = this.accumulator / (double)this.rounds;
                this.rounds = this.phaseTwoRounds();
                this.accumulator = 0.0;
                this.count = 0;
                break;
            }
            case 2: {
                this.phase = 3;
                this.rounds = this.phaseThreeRounds();
                this.accumulator = 0.0;
                this.count = 0;
                break;
            }
            case 3: {
                break;
            }
            default: {
                System.err.println("Illegal phase change\n");
                return;
            }
        }
    }

    private int phaseOneRounds() {
        return (int)Math.ceil(1.0 + (1.0 + this.epsilon) * 4.0 * 0.72 * (Math.log(2.0 / this.delta) / (this.epsilon * this.epsilon)));
    }

    private int phaseTwoRounds() {
        this.gamma = 2.88 * (Math.log(2.0 / this.delta) / (this.epsilon * this.epsilon));
        return (int)Math.ceil(this.c * this.gamma * this.epsilon / this.mu);
    }

    private int phaseThreeRounds() {
        double d = Math.max(this.accumulator / (double)this.rounds, this.epsilon * this.mu);
        return (int)Math.ceil(this.c * this.gamma * d / (this.mu * this.mu));
    }
}

