/*
 * Decompiled with CFR 0.152.
 */
package g2d.stats;

import g2d.jlambda.Attributable;
import g2d.stats.StatisticsImpl;

public class GenericApprox
extends StatisticsImpl {
    final double epsilon;
    final double delta;
    int rounds;
    double accumulator = 0.0;
    int count = 0;

    public GenericApprox(String string, double d, double d2) {
        super(string);
        this.epsilon = d;
        this.delta = d2;
        this.rounds = (int)Math.ceil(Math.log(2.0 / d2) / (2.0 * d * d));
    }

    @Override
    public void recordRunResult(Object object) {
        super.recordRunResult(object);
        if (this.done()) {
            return;
        }
        if (object instanceof Double) {
            this.accumulator += ((Double)object).doubleValue();
        }
        ++this.count;
    }

    @Override
    public boolean done() {
        super.done();
        return this.count >= this.rounds;
    }

    @Override
    public Attributable summary() {
        Attributable attributable = super.summary();
        if (this.count > 0) {
            attributable.setAttribute("average", new Double(this.accumulator / (double)this.count));
            attributable.setAttribute("rounds", new Integer(this.rounds));
            attributable.setAttribute("count", new Integer(this.count));
        }
        return attributable;
    }
}

