/*
 * Decompiled with CFR 0.152.
 */
package g2d.stats;

import g2d.jlambda.Attributable;
import g2d.stats.StatisticsImpl;
import org.apache.commons.math3.distribution.BinomialDistribution;

public class BlackboxApprox
extends StatisticsImpl {
    static boolean debug = false;
    final double threshold;
    final int rounds;
    final BinomialDistribution binomial;
    double accumulator = 0.0;
    int count = 0;

    public BlackboxApprox(String string, double d, int n) {
        super(string);
        this.threshold = d;
        this.rounds = n;
        this.binomial = new BinomialDistribution(n, d);
    }

    @Override
    public void recordRunResult(Object object) {
        super.recordRunResult(object);
        if (this.done()) {
            return;
        }
        this.monitor(object);
        if (object instanceof Double) {
            this.accumulator += ((Double)object).doubleValue();
        }
        ++this.count;
    }

    @Override
    public boolean done() {
        super.done();
        return this.count >= this.rounds;
    }

    @Override
    public Attributable summary() {
        Attributable attributable = super.summary();
        int n = (int)this.accumulator;
        double d = this.binomial.cumulativeProbability(n);
        double d2 = this.count == 0 ? 0.0 : this.accumulator / (double)this.count;
        boolean bl = d2 > this.threshold;
        attributable.setAttribute("threshold", new Double(this.threshold));
        attributable.setAttribute("rounds", new Integer(this.rounds));
        attributable.setAttribute("count", new Integer(this.count));
        attributable.setAttribute("p-value", new Double(d));
        attributable.setAttribute("average", new Double(d2));
        attributable.setAttribute("status", new Boolean(bl));
        return attributable;
    }

    private void monitor(Object object) {
        if (debug) {
            System.err.println("recordRunResult(" + object + "): " + this.count + " out of " + this.rounds);
        }
    }
}

