/*
 * Decompiled with CFR 0.152.
 */
package g2d.pla.requestargs;

import g2d.graph.IOPGraph;
import g2d.graph.IOPNode;
import g2d.pla.requestargs.ExploreArg;
import g2d.pla.requestargs.ExploreRequestArgs;
import g2d.pla.requestargs.FocusPoint;
import g2d.pla.requestargs.FocusPointSequence;
import g2d.pla.requestargs.ModificationExplore;
import g2d.pla.requestargs.NetRequestArgs;
import g2d.pla.requestargs.NumericExplore;
import g2d.pla.requestargs.SimpleRequestArgs;

public abstract class RequestArgs {
    public abstract IOPNode focalPoint(IOPGraph var1);

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this instanceof NetRequestArgs) {
            NetRequestArgs netRequestArgs = (NetRequestArgs)this;
            stringBuilder.append("goals ");
            stringBuilder.append(netRequestArgs.goals);
            stringBuilder.append(" avoids ");
            stringBuilder.append(netRequestArgs.avoids);
            stringBuilder.append(" hides ");
            stringBuilder.append(netRequestArgs.hides);
        } else if (this instanceof ExploreRequestArgs) {
            ExploreRequestArgs exploreRequestArgs = (ExploreRequestArgs)this;
            boolean bl = true;
            stringBuilder.append("[");
            for (ExploreArg exploreArg : exploreRequestArgs.list) {
                if (!bl) {
                    stringBuilder.append(" ");
                } else {
                    bl = false;
                }
                RequestArgs.toString(stringBuilder, exploreArg);
            }
            stringBuilder.append("]");
        } else {
            SimpleRequestArgs simpleRequestArgs = (SimpleRequestArgs)this;
            stringBuilder.append(simpleRequestArgs.name);
        }
        return stringBuilder.toString();
    }

    public static String toString(StringBuilder stringBuilder, ExploreArg exploreArg) {
        if (exploreArg instanceof ModificationExplore) {
            ModificationExplore modificationExplore = (ModificationExplore)exploreArg;
            stringBuilder.append('(');
            stringBuilder.append((Object)modificationExplore.type);
            stringBuilder.append(' ');
            stringBuilder.append(modificationExplore.rules);
            stringBuilder.append(')');
        } else if (exploreArg instanceof NumericExplore) {
            NumericExplore numericExplore = (NumericExplore)exploreArg;
            stringBuilder.append('(');
            stringBuilder.append((Object)numericExplore.direction);
            stringBuilder.append(' ');
            stringBuilder.append(numericExplore.count);
            stringBuilder.append(')');
        } else if (exploreArg instanceof FocusPointSequence) {
            FocusPointSequence focusPointSequence = (FocusPointSequence)exploreArg;
            stringBuilder.append("(fps");
            for (FocusPoint focusPoint : focusPointSequence.fps) {
                stringBuilder.append(' ');
                stringBuilder.append('[');
                stringBuilder.append(focusPoint.node);
                stringBuilder.append(' ');
                stringBuilder.append((Object)focusPoint.direction);
                stringBuilder.append(']');
            }
            stringBuilder.append(')');
        } else {
            System.err.println("RequestArgs.toString(ExploreArg arg) was suprised by arg being " + exploreArg.getClass());
        }
        return exploreArg.toString();
    }
}

