/*
 * Decompiled with CFR 0.152.
 */
package g2d.pla.explorer;

import g2d.jlambda.Closure;
import g2d.swing.FastListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Explorer
extends JFrame {
    public static final String VERSION = "v 0.6";
    public Find current = null;
    public Closure completionClosure;
    public Closure netsClosure;
    public Closure rulesClosure;
    public Closure launchClosure;
    public Closure saveClosure;
    public final FastListModel<String> completionModel = new FastListModel();
    public final JList<String> completionResults = new JList<String>(this.completionModel);
    public final ListSelectionListener completionListener;
    public final FastListModel<String> findModel = new FastListModel();
    public final JList<String> findResults = new JList<String>(this.findModel);
    public final ListSelectionListener findListener;
    public final JPanel mainPanel = new JPanel(new GridLayout(2, 1));
    public final JPanel topPanel = new JPanel(new BorderLayout());
    public final JPanel bottomPanel = new JPanel(new BorderLayout());
    public final String statusPrefix = "Status: ";
    public final JLabel status = new JLabel("Status: ");
    public final JPanel topButtons = new JPanel();
    public final JPanel bottomButtons = new JPanel();
    public final JButton rules = new JButton("Find Rules");
    public final JButton nets = new JButton("Find Nets");
    public final JButton go = new JButton("Go");
    public final JButton save = new JButton("Save");
    public final JTextField editor = new JTextField();

    public Explorer() {
        this.setTitle("Model Browser v 0.6");
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                Explorer.this.doSearch();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                Explorer.this.doSearch();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                Explorer.this.doSearch();
            }
        };
        this.editor.getDocument().addDocumentListener(documentListener);
        this.completionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    boolean bl = Explorer.this.completionResults.getSelectedIndex() != -1;
                    Explorer.this.rules.setEnabled(bl);
                    Explorer.this.nets.setEnabled(bl);
                }
            }
        };
        this.completionResults.addListSelectionListener(this.completionListener);
        this.completionResults.setSelectionMode(0);
        this.findListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    boolean bl = Explorer.this.findResults.getSelectedIndex() != -1;
                    Explorer.this.go.setEnabled(bl);
                }
            }
        };
        this.findResults.addListSelectionListener(this.findListener);
        this.rules.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Explorer.this.find(Find.rules);
            }
        });
        this.nets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Explorer.this.find(Find.nets);
            }
        });
        this.go.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Explorer.this.go();
            }
        });
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Explorer.this.save();
            }
        });
        this.rules.setEnabled(false);
        this.nets.setEnabled(false);
        this.go.setEnabled(false);
        this.save.setEnabled(false);
        this.topButtons.add(this.rules);
        this.topButtons.add(this.nets);
        this.bottomButtons.add(this.go);
        this.bottomButtons.add(this.save);
        this.topPanel.add((Component)this.editor, "North");
        this.topPanel.add((Component)new JScrollPane(this.completionResults), "Center");
        this.topPanel.add((Component)this.topButtons, "South");
        this.bottomPanel.add((Component)this.status, "North");
        this.bottomPanel.add((Component)new JScrollPane(this.findResults), "Center");
        this.bottomPanel.add((Component)this.bottomButtons, "South");
        this.mainPanel.add(this.topPanel);
        this.mainPanel.add(this.bottomPanel);
        this.setContentPane(this.mainPanel);
        this.pack();
    }

    private void add2Model(FastListModel<String> fastListModel, AbstractCollection abstractCollection, boolean bl) {
        int n = abstractCollection.size();
        fastListModel.setListenersEnabled(false);
        if (bl) {
            fastListModel.removeAllElements();
        }
        fastListModel.ensureCapacity(n);
        for (Object e : abstractCollection) {
            fastListModel.addElement(e.toString());
        }
        fastListModel.setListenersEnabled(true);
        fastListModel.fireIntervalAdded(this, 0, n);
    }

    private void doSearch() {
        Object object;
        String string = this.editor.getText();
        if (this.completionClosure != null && (object = this.completionClosure.applyClosure(this, string)) instanceof AbstractCollection) {
            AbstractCollection abstractCollection = (AbstractCollection)object;
            int n = abstractCollection.size();
            this.setStatus("found " + n + " matches.");
            this.add2Model(this.completionModel, abstractCollection, true);
            this.completionResults.clearSelection();
            return;
        }
        System.err.println("Either your completion closure was null, or it didn't return an AbstractCollection!");
    }

    private void setStatus(String string) {
        this.status.setText("Status: " + string);
    }

    private void find(Find find) {
        String string = this.completionResults.getSelectedValue();
        Closure closure = null;
        boolean bl = false;
        switch (find) {
            case nets: {
                closure = this.netsClosure;
                bl = true;
                break;
            }
            case rules: {
                closure = this.rulesClosure;
                bl = false;
            }
        }
        if (closure != null) {
            this.current = find;
            Object object = closure.applyClosure(this, string);
            if (object instanceof AbstractCollection) {
                AbstractCollection abstractCollection = (AbstractCollection)object;
                this.setStatus("found " + abstractCollection.size() + " " + (Object)((Object)find));
                this.add2Model(this.findModel, abstractCollection, true);
                this.findResults.clearSelection();
                this.findResults.setSelectionMode(bl ? 0 : 2);
                this.save.setEnabled(true);
                return;
            }
        }
        System.err.println("Either your " + (Object)((Object)find) + " closure was null, or it didn't return an AbstractCollection!");
    }

    private void go() {
        if (this.launchClosure != null) {
            String string;
            int[] nArray = this.findResults.getSelectedIndices();
            int n = nArray.length;
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = ((String)this.findModel.getElementAt(nArray[i])).toString();
            }
            if (n == 1) {
                string = stringArray[0];
                this.setStatus("launching : " + string + ".");
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = false;
                for (String string2 : stringArray) {
                    if (bl) {
                        stringBuffer.append(" ");
                    } else {
                        bl = true;
                    }
                    stringBuffer.append(string2);
                }
                string = stringBuffer.toString();
            }
            this.launchClosure.applyClosure(this, string);
            return;
        }
        System.err.println("Your launch closure is null!");
    }

    private void save() {
        if (this.saveClosure != null) {
            Object[] objectArray = this.findModel.getElements();
            this.saveClosure.applyClosure(this, objectArray);
            return;
        }
        System.err.println("Your save closure is null!");
    }

    public static enum Find {
        rules,
        nets;

    }
}

