/*
 * Decompiled with CFR 0.152.
 */
package g2d.pla;

import g2d.graph.IOPGraph;
import g2d.graph.IOPNode;
import g2d.graphviewer.KeyStrokeDisplayer;
import g2d.pla.PLAGraphPanel;
import g2d.pla.PLAPanel;
import g2d.pla.SearchTabitaField;
import g2d.pla.list.NodeListModel;
import g2d.pla.list.NodeListRenderer;
import g2d.swing.IOPFileChooser;
import g2d.tabwin.TabFrame;
import g2d.tabwin.TabUtils;
import g2d.util.IO;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SearchTabita
extends JPanel {
    private static final String COMPLETE = "complete";
    private static final String FIND_SELECT = "find_and_select";
    private final PLAPanel owner;
    private final JTextField searchField;
    private final NodeListModel searchSpace = new NodeListModel();
    private final JList<IOPNode> searchList = new JList<IOPNode>(this.searchSpace);
    private final JCheckBox searchRegex = new JCheckBox();
    private final JLabel description;
    private int lastIndex;
    private boolean completionInProgress = false;
    private boolean completionRemove = false;
    private boolean completionInsert = false;

    public SearchTabita(String string, PLAPanel pLAPanel) {
        this(string, 0, pLAPanel, UIManager.getFont("Button.font").deriveFont(10.0f), false);
    }

    public SearchTabita(String string, int n, PLAPanel pLAPanel, Font font, boolean bl) {
        JLabel jLabel;
        Object object;
        Serializable serializable;
        this.owner = pLAPanel;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel.setOpaque(false);
        jPanel2.setOpaque(false);
        this.setOpaque(false);
        if (n != 0) {
            serializable = KeyStroke.getKeyStroke(n, 1 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            object = KeyStrokeDisplayer.displayKeyStroke((KeyStroke)serializable);
            jLabel = new JLabel("Find " + string + " (" + (String)object + "):");
        } else {
            jLabel = new JLabel("Find " + string + ":");
        }
        this.description = jLabel;
        this.description.setFont(font);
        jPanel.add((Component)this.description, "North");
        this.searchField = this.makeField(this.searchSpace, this.searchRegex, this.searchList, font);
        jPanel.add((Component)new SearchTabitaField(this.searchField, this.searchRegex), "Center");
        this.searchList.setSelectionMode(0);
        this.searchList.setVisibleRowCount(-1);
        this.searchList.addMouseListener(new FindListener(this.searchList, this.searchField));
        this.searchList.setFont(font);
        this.searchList.setCellRenderer(new NodeListRenderer(font, bl));
        serializable = new JScrollPane(this.searchList);
        ((JComponent)serializable).setBackground(Color.white);
        object = new JButton(this.searchField.getAction());
        ((JComponent)object).setToolTipText("Find node (or [ENTER] in text field)");
        ((JComponent)object).setOpaque(false);
        jPanel2.add((Component)object);
        object = this.makeSaveButton(this.searchList);
        jPanel2.add((Component)object);
        object = this.makeClickButton(this.searchList);
        jPanel2.add((Component)object);
        this.add((Component)jPanel, "North");
        this.add((Component)serializable, "Center");
        this.add((Component)jPanel2, "South");
        SelectingListener selectingListener = new SelectingListener(this.searchField, this.searchRegex, this.searchSpace, this.searchList);
        this.searchField.getDocument().addDocumentListener(selectingListener);
        this.searchField.getDocument().putProperty("SelectingListener", selectingListener);
    }

    private JTextField makeField(NodeListModel nodeListModel, JCheckBox jCheckBox, JList jList, Font font) {
        final JTextField jTextField = new JTextField(25);
        jTextField.setFont(font);
        jTextField.setFocusable(true);
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                super.focusGained(focusEvent);
                jTextField.setCaretPosition(0);
                jTextField.selectAll();
            }
        });
        jTextField.setAction(new FindAction(jTextField, jList, false));
        jTextField.setFocusTraversalKeysEnabled(false);
        jTextField.getInputMap().put(KeyStroke.getKeyStroke(9, 0), COMPLETE);
        jTextField.getActionMap().put(COMPLETE, new CompleteAction(jTextField, jCheckBox, nodeListModel));
        jTextField.getInputMap().put(KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), FIND_SELECT);
        jTextField.getActionMap().put(FIND_SELECT, new FindAction(jTextField, jList, true));
        return jTextField;
    }

    private JButton makeSaveButton(JList jList) {
        JButton jButton = new JButton(new SaveAction(this.searchSpace, this.owner, jList));
        jButton.setOpaque(false);
        jButton.setToolTipText("Save the list to a file");
        return jButton;
    }

    private JButton makeClickButton(JList jList) {
        JButton jButton = new JButton(new ClickAction(this.owner, jList));
        jButton.setOpaque(false);
        jButton.setToolTipText("Click on node");
        return jButton;
    }

    public void setRange(List<IOPNode> list) {
        this.searchSpace.setData(list);
    }

    public void setDescription(String string) {
        this.description.setText(string);
    }

    private void setTFText(JTextField jTextField, String string) {
        this.completionInProgress = false;
        SelectingListener selectingListener = (SelectingListener)jTextField.getDocument().getProperty("SelectingListener");
        jTextField.getDocument().removeDocumentListener(selectingListener);
        jTextField.setText(string);
        jTextField.getDocument().addDocumentListener(selectingListener);
    }

    class SelectingListener
    implements DocumentListener {
        private JTextField textField;
        private JCheckBox regex;
        private NodeListModel model;
        private JList list;

        public SelectingListener(JTextField jTextField, JCheckBox jCheckBox, NodeListModel nodeListModel, JList jList) {
            this.textField = jTextField;
            this.regex = jCheckBox;
            this.model = nodeListModel;
            this.list = jList;
        }

        private void selectInList() {
            String string = this.textField.getText();
            int n = 0;
            if (SearchTabita.this.completionInProgress) {
                n = SearchTabita.this.lastIndex;
            }
            if ((n = this.model.indexOfName(string, true, n)) != -1) {
                this.list.setSelectionBackground(UIManager.getColor("List.selectionBackground"));
                this.list.setSelectionInterval(n, n);
                this.list.ensureIndexIsVisible(n);
            } else {
                n = this.regex.isSelected() ? this.model.indexOfPattern(string, false, 0) : this.model.indexOfCompletion(string, 0);
                if (n == -1) {
                    this.list.setSelectionBackground(Color.LIGHT_GRAY);
                    this.list.setSelectionInterval(n, n);
                    this.list.ensureIndexIsVisible(n);
                }
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.selectInList();
            if (!SearchTabita.this.completionInsert) {
                SearchTabita.this.completionInProgress = false;
            }
            SearchTabita.this.completionInsert = false;
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.selectInList();
            if (!SearchTabita.this.completionRemove) {
                SearchTabita.this.completionInProgress = false;
            }
            SearchTabita.this.completionRemove = false;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    class FindListener
    extends MouseAdapter {
        private JList list;
        private JTextField textField;

        public FindListener(JList jList, JTextField jTextField) {
            this.list = jList;
            this.textField = jTextField;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 0) {
                this.list.setSelectionBackground(UIManager.getColor("List.selectionBackground"));
                int n = this.list.locationToIndex(mouseEvent.getPoint());
                if (n != -1) {
                    this.list.setSelectionInterval(n, n);
                    this.list.ensureIndexIsVisible(n);
                    SearchTabita.this.setTFText(this.textField, this.list.getSelectedValue().toString());
                    if (mouseEvent.getClickCount() == 2) {
                        this.textField.getAction().actionPerformed(new ActionEvent(this.list, 1001, ""));
                    }
                }
            }
        }
    }

    class CompleteAction
    extends AbstractAction {
        private JTextField textField;
        private JCheckBox regex;
        private NodeListModel model;
        private String toBeCompleted = "";
        private int firstIndex;

        public CompleteAction(JTextField jTextField, JCheckBox jCheckBox, NodeListModel nodeListModel) {
            this.textField = jTextField;
            this.regex = jCheckBox;
            this.model = nodeListModel;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            if (!SearchTabita.this.completionInProgress) {
                SearchTabita.this.completionInProgress = true;
                this.toBeCompleted = this.textField.getText();
                if (this.regex.isSelected()) {
                    SearchTabita.this.lastIndex = this.model.indexOfPattern(this.toBeCompleted, false, 0);
                } else {
                    SearchTabita.this.lastIndex = this.model.indexOfCompletion(this.toBeCompleted, 0);
                }
                this.firstIndex = SearchTabita.this.lastIndex;
                if (SearchTabita.this.lastIndex == -1) {
                    SearchTabita.this.completionInProgress = false;
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                string = this.model.getElementAt(SearchTabita.this.lastIndex).getLabel();
                if (this.textField.getText().equals(string)) {
                    ++this.firstIndex;
                    this.textField.dispatchEvent(new KeyEvent(this.textField, 401, 0L, 0, 9, '\uffff'));
                    return;
                }
            } else {
                if (this.regex.isSelected()) {
                    SearchTabita.this.lastIndex = this.model.indexOfPattern(this.toBeCompleted, false, SearchTabita.this.lastIndex + 1);
                } else {
                    SearchTabita.this.lastIndex = this.model.indexOfCompletion(this.toBeCompleted, SearchTabita.this.lastIndex + 1);
                }
                if (SearchTabita.this.lastIndex == -1) {
                    SearchTabita.this.lastIndex = this.firstIndex - 1;
                    string = this.toBeCompleted;
                } else {
                    string = this.model.getElementAt(SearchTabita.this.lastIndex).getLabel();
                }
            }
            SearchTabita.this.completionInsert = true;
            SearchTabita.this.completionRemove = true;
            this.textField.setText(string);
        }
    }

    class FindAction
    extends AbstractAction {
        private JTextField textField;
        private JList list;
        private boolean select;

        public FindAction(JTextField jTextField, JList jList, boolean bl) {
            super("Find");
            this.textField = jTextField;
            this.list = jList;
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object e = this.list.getSelectedValue();
            if (e instanceof IOPNode) {
                PLAGraphPanel pLAGraphPanel;
                IOPNode iOPNode = (IOPNode)e;
                if (iOPNode.getLabel().equalsIgnoreCase(this.textField.getText())) {
                    SearchTabita.this.setTFText(this.textField, iOPNode.getLabel());
                }
                if (SearchTabita.this.owner != null && (pLAGraphPanel = SearchTabita.this.owner.getGraphPanel()) != null) {
                    pLAGraphPanel.removeLastSelection();
                    if (((SearchTabita)SearchTabita.this).owner.displayable) {
                        pLAGraphPanel.highlight(iOPNode);
                        pLAGraphPanel.centerOn(iOPNode.getBounds().getBounds());
                        if (this.select) {
                            pLAGraphPanel.displayMenu(iOPNode);
                        }
                    } else {
                        pLAGraphPanel.displayContextMNode(SearchTabita.this.owner, iOPNode);
                        iOPNode.mouseClicked(null);
                    }
                    return;
                }
            }
            Toolkit.getDefaultToolkit().beep();
        }
    }

    class ClickAction
    extends AbstractAction {
        private final JList list;
        private final PLAPanel owner;
        private final PLAGraphPanel gp;

        public ClickAction(PLAPanel pLAPanel, JList jList) {
            super("Click");
            this.list = jList;
            this.owner = pLAPanel;
            this.gp = pLAPanel.getGraphPanel();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object e = this.list.getSelectedValue();
            if (e instanceof IOPNode) {
                IOPGraph iOPGraph = this.owner.graph;
                IOPNode iOPNode = (IOPNode)e;
                this.gp.removeLastSelection();
                if (iOPGraph != null && iOPGraph.getDisplayable()) {
                    this.gp.highlight(iOPNode);
                    this.gp.centerOn(iOPNode.getBounds().getBounds());
                }
                this.gp.mouseClicked(null, iOPNode, null);
                iOPNode.mouseClicked(null);
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        private final NodeListModel searchSpace;
        private final PLAPanel owner;
        private final IOPFileChooser chooser;

        public SaveAction(NodeListModel nodeListModel, PLAPanel pLAPanel, JList jList) {
            super("Save");
            this.searchSpace = nodeListModel;
            this.owner = pLAPanel;
            this.chooser = new IOPFileChooser("raw_text_area");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.chooser.setDialogTitle("Save List to File");
            this.chooser.setMultiSelectionEnabled(false);
            this.chooser.situate();
            TabFrame tabFrame = TabUtils.getTabFrame(this.owner);
            int n = this.chooser.showDialog(tabFrame, "Save");
            if (n != 0) {
                return;
            }
            File file = this.chooser.getSelectedFile();
            String[] stringArray = this.searchSpace.forSaving();
            IO.array2File(stringArray, file);
        }
    }
}

