/*
 * Decompiled with CFR 0.152.
 */
package g2d.pla;

import g2d.graph.Dot;
import g2d.graph.GraphItem;
import g2d.graph.IOPGraph;
import g2d.graph.IOPNode;
import g2d.graph.IOPSubgraph;
import g2d.graphviewer.TabInfo;
import g2d.graphviewer.Textual;
import g2d.pla.PLA;
import g2d.pla.PLAPanel;
import g2d.pla.SearchTabita;
import g2d.pla.SelectionTabita;
import g2d.pla.SubgraphTabita;
import g2d.pla.TabMenu;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkListener;

public class SEPanel
extends JTabbedPane
implements Textual,
ChangeListener {
    private static final String INFO_TAB = "Info";
    private static final String MENU_TAB = "Context Menu";
    private SearchTabita searchTabitaOccs;
    private SearchTabita searchTabitaRules;
    private SubgraphTabita subgraphTabita;
    private SelectionTabita selectionTabita;
    private TabInfo tabInfo;
    private TabMenu tabMenu;
    private HashSet<ChangeListener> listeners = new HashSet();

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public SEPanel(PLAPanel pLAPanel) {
        Font font = UIManager.getFont("Button.font").deriveFont(10.0f);
        this.searchTabitaOccs = new SearchTabita("Occurrence", 79, pLAPanel, font, false);
        this.addTab("Occurrences", null, this.searchTabitaOccs, "Find occurences in graph");
        this.searchTabitaRules = new SearchTabita("Rule", 82, pLAPanel, font, true);
        this.addTab("Rules", null, this.searchTabitaRules, "Find rules in graph");
        if (pLAPanel.allowsSelections()) {
            this.selectionTabita = new SelectionTabita(pLAPanel, font);
            this.addTab("Selections", null, this.selectionTabita, "Set goals, avoids, etc. of occurrences or rules");
        }
        if (PLA.subgraphs) {
            this.subgraphTabita = new SubgraphTabita(pLAPanel, font);
            this.addTab("Subgraphs", null, this.subgraphTabita, "Manipulate subgraphs");
        }
        this.tabMenu = new TabMenu(font, this);
        this.addTab(MENU_TAB, this.tabMenu);
        this.tabInfo = new TabInfo(font);
        this.addTab(INFO_TAB, this.tabInfo);
        this.setTabPlacement(4);
        this.setSelectedIndex(0);
    }

    private void _addChangeListener(Component component) {
        if (component instanceof ChangeListener) {
            this.listeners.add((ChangeListener)((Object)component));
        }
    }

    private void _removeChangeListener(Component component) {
        if (component instanceof ChangeListener) {
            this.listeners.remove((ChangeListener)((Object)component));
        }
    }

    @Override
    public void addTab(String string, Component component) {
        this._addChangeListener(component);
        super.addTab(string, component);
    }

    @Override
    public void addTab(String string, Icon icon, Component component) {
        this._addChangeListener(component);
        super.addTab(string, icon, component);
    }

    @Override
    public void addTab(String string, Icon icon, Component component, String string2) {
        this._addChangeListener(component);
        super.addTab(string, icon, component, string2);
    }

    @Override
    public void remove(Component component) {
        this._removeChangeListener(component);
        super.remove(component);
    }

    @Override
    public void remove(int n) {
        Component component = this.getTabComponentAt(n);
        this._removeChangeListener(component);
        super.remove(n);
    }

    @Override
    public void removeAll() {
        this.listeners.clear();
    }

    public Component getTab(String string) {
        Component component = null;
        int n = this.indexOfTab(string);
        if (n != -1) {
            component = this.getComponentAt(n);
        }
        return component;
    }

    public void selectTab(String string) {
        int n = this.indexOfTab(string);
        if (n != -1) {
            this.setSelectedIndex(n);
        }
    }

    public TabMenu getTabMenu() {
        return this.tabMenu;
    }

    public TabInfo getTabInfo() {
        return this.tabInfo;
    }

    public boolean hasSettings() {
        return this.selectionTabita != null;
    }

    public void setHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.tabInfo.setHyperlinkListener(hyperlinkListener);
    }

    public void update(IOPGraph iOPGraph) {
        if (iOPGraph != null) {
            IOPNode[] iOPNodeArray = iOPGraph.getNodesInArray();
            IOPSubgraph[] iOPSubgraphArray = iOPGraph.getSubgraphsInArray();
            ArrayList<IOPNode> arrayList = new ArrayList<IOPNode>();
            ArrayList<IOPNode> arrayList2 = new ArrayList<IOPNode>();
            ArrayList<GraphItem> arrayList3 = new ArrayList<GraphItem>();
            for (IOPSubgraph graphItem : iOPSubgraphArray) {
                arrayList3.add(graphItem);
            }
            for (GraphItem graphItem : iOPNodeArray) {
                if (((IOPNode)graphItem).type == IOPNode.NodeType.OCC) {
                    arrayList.add((IOPNode)graphItem);
                    continue;
                }
                if (((IOPNode)graphItem).type != IOPNode.NodeType.RULE) continue;
                arrayList2.add((IOPNode)graphItem);
            }
            Collections.sort(arrayList, IOPNode.OCC_COMPARATOR);
            Collections.sort(arrayList2, IOPNode.RULE_COMPARATOR);
            Collections.sort(arrayList3, GraphItem.COMPARATOR);
            System.err.println("SEPanel -- Rule count: " + arrayList2.size());
            this.searchTabitaOccs.setRange(arrayList);
            this.searchTabitaRules.setRange(arrayList2);
            if (this.selectionTabita != null) {
                this.selectionTabita.setRange(arrayList, arrayList2);
            }
            this.searchTabitaOccs.setRange(arrayList);
            if (PLA.subgraphs) {
                this.subgraphTabita.populate(arrayList, arrayList2, arrayList3);
            }
        }
    }

    @Override
    public void displayText(String string, String string2) {
        this.tabInfo.displayText(string, string2);
        int n = this.indexOfTab(INFO_TAB);
        if (n != -1) {
            this.setSelectedIndex(n);
        }
    }

    public void displayMenu(String string, List<AbstractButton> list) {
        this.displayMenu(string, list, null, true);
    }

    public void displayMenu(String string, List<AbstractButton> list, ButtonGroup buttonGroup, boolean bl) {
        this.tabMenu.displayMenu(string, list, buttonGroup, bl);
        int n = this.indexOfTab(MENU_TAB);
        if (n != -1) {
            this.setSelectedIndex(n);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof Dot || object instanceof IOPGraph || object instanceof GraphItem) {
            Iterator<ChangeListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().stateChanged(changeEvent);
            }
        }
    }

    public void resetAllSelections() {
        if (this.tabMenu != null) {
            this.tabMenu.resetAllSelections();
        }
    }
}

