/*
 * Decompiled with CFR 0.152.
 */
package g2d.pla;

import g2d.graph.IOPGraph;
import g2d.graph.IOPNode;
import g2d.pla.PLAPanel;
import g2d.pla.RuleRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class RuleTabita
extends JPanel {
    private final PLAPanel owner;
    private final RuleTableModel ruleModel;
    private final RuleTable ruleTable;
    private final JLabel description;

    public RuleTabita(String string, PLAPanel pLAPanel) {
        this(string, pLAPanel, UIManager.getFont("Button.font").deriveFont(10.0f), false);
    }

    public RuleTabita(String string, PLAPanel pLAPanel, Font font, boolean bl) {
        this.owner = pLAPanel;
        this.ruleModel = new RuleTableModel();
        this.ruleTable = new RuleTable(this.ruleModel);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel.setOpaque(false);
        jPanel2.setOpaque(false);
        this.setOpaque(false);
        this.description = new JLabel("Rule Selection Chooser");
        this.description.setFont(font);
        jPanel.add((Component)this.description, "North");
        this.ruleTable.setFont(font);
        JScrollPane jScrollPane = new JScrollPane(this.ruleTable);
        jScrollPane.setBackground(Color.white);
        this.add((Component)jPanel, "North");
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel2, "South");
    }

    public void setRange(List<IOPNode> list) {
        this.ruleModel.setRange(list);
    }

    public void setDescription(String string) {
        this.description.setText(string);
    }

    class RuleTable
    extends JTable {
        private final TableColumnModel columnModel;

        public RuleTable(TableModel tableModel) {
            super(tableModel);
            this.columnModel = this.getColumnModel();
            this.setSelectionMode(0);
            this.setDefaultRenderer(IOPNode.class, new RuleRenderer());
            this.setCellSelectionEnabled(true);
            this.setColumnSizes();
            this.addCellSelectionHandler(this);
        }

        private void setColumnSizes() {
            TableColumn tableColumn = this.columnModel.getColumn(0);
            tableColumn.setPreferredWidth(50);
            tableColumn.setMaxWidth(50);
            tableColumn.setResizable(false);
            this.columnModel.getColumn(1).setPreferredWidth(100);
        }

        private void addCellSelectionHandler(final RuleTable ruleTable) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n = ruleTable.rowAtPoint(mouseEvent.getPoint());
                    int n2 = ruleTable.columnAtPoint(mouseEvent.getPoint());
                    if (n >= 0 && n2 >= 0 && n2 == 1) {
                        IOPNode iOPNode = (IOPNode)ruleTable.getModel().getValueAt(n, n2);
                        System.err.println("Centering on rule " + iOPNode.getLabel());
                        RuleTabita.this.owner.centerOnAndHighlight(iOPNode);
                    }
                }
            });
        }
    }

    class RuleTableModel
    extends AbstractTableModel {
        private final String[] headers = new String[]{"Hide", "Rule"};
        private final String[] attrs = new String[]{"avoid"};
        private final List<IOPNode> elements = new ArrayList<IOPNode>();

        RuleTableModel() {
        }

        protected void setRange(List<IOPNode> list) {
            this.elements.clear();
            this.elements.addAll(list);
        }

        @Override
        public int getRowCount() {
            return this.elements.size();
        }

        @Override
        public int getColumnCount() {
            return this.headers.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.headers[n];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return IOPNode.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            IOPNode iOPNode = this.elements.get(n);
            if (n2 == 0) {
                return this.getSelected(iOPNode, n2);
            }
            return iOPNode;
        }

        private boolean getSelected(IOPNode iOPNode, int n) {
            return iOPNode.getAttributeAsString("status", "none").equals(this.attrs[n]);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            IOPNode iOPNode = this.elements.get(n);
            if (n2 == 0) {
                iOPNode.setSelected((Boolean)object);
                boolean bl = this.getSelected(iOPNode, n2);
                if (RuleTabita.this.owner != null) {
                    IOPGraph iOPGraph = RuleTabita.this.owner.getGraph();
                    iOPNode.setAttribute("status", bl ? "none" : this.attrs[n2]);
                    iOPNode.updateFillColor();
                    iOPGraph.fireChange(iOPNode);
                }
                this.fireTableCellUpdated(n, 0);
                ((RuleTabita)RuleTabita.this).owner.graphPanel.repaint();
            }
        }
    }
}

