/*
 * Decompiled with CFR 0.152.
 */
package g2d.pla;

import g2d.graph.IOPGraph;
import g2d.graph.IOPNode;
import g2d.pla.PLAGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RuleRanks {
    public static final String hasRanks = "hasRanks";
    public static final String usingRanks = "usingRanks";
    private final ArrayList<ArrayList<String>> ranks;

    public RuleRanks(PLAGraph pLAGraph) {
        ArrayList<ArrayList<String>> arrayList = this.getRanks(pLAGraph.graph);
        if (arrayList == null) {
            arrayList = this.getRanks(pLAGraph.rules, pLAGraph.parent);
        }
        this.ranks = arrayList;
    }

    public int size() {
        return this.ranks == null ? 0 : this.ranks.size();
    }

    public String toString() {
        if (this.ranks == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ArrayList<String> arrayList : this.ranks) {
            this.toString(stringBuilder, arrayList);
        }
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder, ArrayList<String> arrayList) {
        if (arrayList.size() > 0) {
            stringBuilder.append("{rank=same; ");
            for (String string : arrayList) {
                stringBuilder.append(string);
                stringBuilder.append("; ");
            }
            stringBuilder.append("}\n");
        }
    }

    private ArrayList<ArrayList<String>> getRanks(IOPGraph iOPGraph) {
        ArrayList<ArrayList<String>> arrayList = null;
        Object[] objectArray = (Object[])iOPGraph.getAttribute("ruleRanks");
        if (objectArray != null && objectArray.length > 0) {
            arrayList = new ArrayList<ArrayList<String>>();
            for (int i = 0; i < objectArray.length; ++i) {
                String[] object = (String[])objectArray[i];
                List<String> list = Arrays.asList(object);
                if (list.size() <= 0) continue;
                arrayList.add(new ArrayList<String>(list));
            }
            for (ArrayList arrayList2 : arrayList) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    arrayList2.set(i, iOPGraph.getIOPNode((String)((String)arrayList2.get((int)i))).id);
                }
            }
        }
        return arrayList;
    }

    private ArrayList<ArrayList<String>> getRanks(List<IOPNode> list, IOPGraph iOPGraph) {
        ArrayList arrayList = null;
        if (iOPGraph == null) {
            return null;
        }
        PLAGraph pLAGraph = PLAGraph.getPLAGraph(iOPGraph);
        if (pLAGraph == null) {
            return null;
        }
        RuleRanks ruleRanks = pLAGraph.ruleRanks;
        if (ruleRanks == null) {
            return null;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (IOPNode object : list) {
            arrayList2.add(object.id);
        }
        if (ruleRanks.ranks != null) {
            arrayList = new ArrayList();
            for (ArrayList arrayList3 : ruleRanks.ranks) {
                ArrayList arrayList4 = new ArrayList(arrayList3);
                arrayList4.retainAll(arrayList2);
                if (arrayList4.size() <= 0) continue;
                arrayList.add(arrayList4);
            }
        }
        return arrayList;
    }
}

