/*
 * Decompiled with CFR 0.152.
 */
package g2d.pla;

import g2d.graph.IOPGraph;
import g2d.jlambda.Closure;
import g2d.pla.GraphIndex;
import g2d.pla.PLAPanel;
import g2d.pla.menus.CompareMenu;
import g2d.swing.HierarchyMenu;
import g2d.swing.HierarchyMenuBuilder;
import g2d.swing.WindowTreeIcon;
import g2d.tabwin.TabFrame;
import g2d.tabwin.TabUtils;
import g2d.util.ActorMsg;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JMenuItem;

public class PLAUtils
extends TabUtils
implements HierarchyMenuBuilder {
    private static final GraphIndex index = new GraphIndex("PLA Graph Index");
    protected static final ArrayList<IOPGraph> roots = new ArrayList();
    private static final HashMap<String, PLAPanel> name2PanelMap = new HashMap();
    private static final HashMap<String, IOPGraph> name2GraphMap = new HashMap();
    private static final HashMap<String, Boolean> name2AllowsSelections = new HashMap();

    public static void showIndex(boolean bl) {
        index.setVisible(bl);
    }

    public static PLAPanel launchTab(IOPGraph iOPGraph, boolean bl) {
        return PLAUtils.launchTab(iOPGraph, bl, true);
    }

    public static PLAPanel launchTab(IOPGraph iOPGraph, boolean bl, boolean bl2) {
        Closure closure;
        Closure closure2;
        IOPGraph iOPGraph2 = iOPGraph.getParent();
        String string = iOPGraph.title;
        String string2 = iOPGraph.description;
        PLAPanel pLAPanel = new PLAPanel(iOPGraph, string, string2, bl, bl2);
        Closure closure3 = iOPGraph.toolBarClosure;
        if (closure3 != null) {
            closure3.applyClosure(pLAPanel, iOPGraph);
        }
        if ((closure2 = iOPGraph.menuBarClosure) != null) {
            closure2.applyClosure(pLAPanel, iOPGraph);
        }
        if ((closure = iOPGraph.panelClosure) != null) {
            closure.applyClosure(pLAPanel, iOPGraph);
        }
        TabFrame tabFrame = null;
        PLAPanel pLAPanel2 = null;
        if (iOPGraph2 != null) {
            pLAPanel2 = name2PanelMap.get(iOPGraph2.name);
        }
        if (pLAPanel2 == null) {
            tabFrame = new TabFrame(pLAPanel);
            tabFrame.pack();
            tabFrame.setVisible(true);
        } else {
            tabFrame = TabUtils.getTabFrame(pLAPanel2);
            int n = tabFrame.indexOfTabPanel(pLAPanel2);
            tabFrame.addTabPanel(n + 1, pLAPanel, true);
        }
        PLAUtils.noteGraphAndPanel(iOPGraph, iOPGraph2, bl, pLAPanel);
        return pLAPanel;
    }

    private static void noteGraphAndPanel(IOPGraph iOPGraph, IOPGraph iOPGraph2, boolean bl, PLAPanel pLAPanel) {
        String string = iOPGraph.name;
        name2PanelMap.put(string, pLAPanel);
        name2GraphMap.put(string, iOPGraph);
        name2AllowsSelections.put(string, bl);
        index.addGraph(iOPGraph);
        if (iOPGraph2 == null && !roots.contains(iOPGraph)) {
            roots.add(iOPGraph);
        }
    }

    public static void dispose(IOPGraph iOPGraph) {
        name2PanelMap.put(iOPGraph.name, null);
        index.removeGraph(iOPGraph);
    }

    public static void bringToFront(IOPGraph iOPGraph) {
        PLAPanel pLAPanel = name2PanelMap.get(iOPGraph.name);
        if (pLAPanel == null) {
            return;
        }
        TabFrame tabFrame = TabUtils.getTabFrame(pLAPanel);
        if (tabFrame == null) {
            return;
        }
        tabFrame.focusTabPanel(pLAPanel);
        tabFrame.toFront();
    }

    public static PLAPanel getPLAPanel(IOPGraph iOPGraph) {
        PLAPanel pLAPanel = name2PanelMap.get(iOPGraph.name);
        return pLAPanel;
    }

    public static TabFrame getTabFrame(IOPGraph iOPGraph) {
        TabFrame tabFrame = null;
        PLAPanel pLAPanel = name2PanelMap.get(iOPGraph.name);
        if (pLAPanel != null) {
            tabFrame = TabUtils.getTabFrame(pLAPanel);
        }
        return tabFrame;
    }

    public static void constructCompareMenu(PLAPanel pLAPanel, CompareMenu compareMenu) {
        IOPGraph iOPGraph = pLAPanel.graph;
        for (IOPGraph iOPGraph2 : roots) {
            PLAUtils.addCompareMenuItems(compareMenu, iOPGraph, iOPGraph2, 0, new int[0]);
        }
    }

    private static void addCompareMenuItems(CompareMenu compareMenu, final IOPGraph iOPGraph, final IOPGraph iOPGraph2, int n, int[] nArray) {
        JMenuItem jMenuItem = new JMenuItem(iOPGraph2.title);
        jMenuItem.setEnabled(false);
        WindowTreeIcon windowTreeIcon = new WindowTreeIcon(jMenuItem, n, nArray);
        jMenuItem.setIcon(windowTreeIcon);
        jMenuItem.setDisabledIcon(windowTreeIcon);
        if (iOPGraph2 != iOPGraph) {
            jMenuItem.setEnabled(true);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ActorMsg.send("maude", iOPGraph.getUID(), "compareGraphs " + iOPGraph2.getUID());
                }
            });
        }
        compareMenu.add(jMenuItem);
        IOPGraph[] iOPGraphArray = iOPGraph2.getChildren();
        int n2 = iOPGraphArray.length;
        if (n2 > 0) {
            for (int i = 0; i < n2 - 1; ++i) {
                int[] nArray2 = new int[nArray.length + 1];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray2[nArray2.length - 1] = n + 1;
                PLAUtils.addCompareMenuItems(compareMenu, iOPGraph, iOPGraphArray[i], n + 1, nArray2);
            }
            PLAUtils.addCompareMenuItems(compareMenu, iOPGraph, iOPGraphArray[n2 - 1], n + 1, nArray);
        }
    }

    @Override
    public void constructHierarchyMenu(HierarchyMenu hierarchyMenu) {
        for (IOPGraph iOPGraph : roots) {
            PLAUtils.addHierarchyMenuItems(hierarchyMenu, iOPGraph, 0, new int[0]);
        }
    }

    private static void addHierarchyMenuItems(HierarchyMenu hierarchyMenu, final IOPGraph iOPGraph, int n, int[] nArray) {
        final boolean bl = name2PanelMap.get(iOPGraph.name) != null;
        String string = bl ? iOPGraph.title : iOPGraph.title + " !";
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setOpaque(true);
        if (!bl) {
            jMenuItem.setForeground(Color.red);
        }
        WindowTreeIcon windowTreeIcon = new WindowTreeIcon(jMenuItem, n, nArray);
        jMenuItem.setIcon(windowTreeIcon);
        jMenuItem.setEnabled(true);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!bl) {
                    PLAUtils.launchTab(iOPGraph, (Boolean)name2AllowsSelections.get(iOPGraph.name));
                } else {
                    PLAUtils.bringToFront(iOPGraph);
                }
            }
        });
        hierarchyMenu.add(jMenuItem);
        IOPGraph[] iOPGraphArray = iOPGraph.getChildren();
        int n2 = iOPGraphArray.length;
        if (n2 > 0) {
            for (int i = 0; i < n2 - 1; ++i) {
                int[] nArray2 = new int[nArray.length + 1];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray2[nArray2.length - 1] = n + 1;
                PLAUtils.addHierarchyMenuItems(hierarchyMenu, iOPGraphArray[i], n + 1, nArray2);
            }
            PLAUtils.addHierarchyMenuItems(hierarchyMenu, iOPGraphArray[n2 - 1], n + 1, nArray);
        }
    }
}

