/*
 * Decompiled with CFR 0.152.
 */
package g2d.npa.launcher;

import g2d.jlambda.Closure;
import g2d.swing.FastListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Launcher
extends JFrame {
    public static final String VERSION = "v 0.1";
    public Closure launchClosure;
    public final FastListModel<Object> protocolModel = new FastListModel();
    public final JList<Object> protocols = new JList<Object>(this.protocolModel);
    public final ListSelectionListener protocolsListener;
    public final JPanel mainPanel = new JPanel(new GridLayout(1, 1));
    public final JPanel topPanel = new JPanel(new BorderLayout());
    public final String statusPrefix = "Status: ";
    public final JLabel status = new JLabel("Status: ");
    public final JPanel buttons = new JPanel();
    public final JButton go = new JButton("Go");

    public Launcher() {
        this.setTitle("Protocol Browser v 0.1");
        this.protocols.setSelectionMode(0);
        this.protocolsListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    boolean bl = Launcher.this.protocols.getSelectedIndex() != -1;
                    Launcher.this.go.setEnabled(bl);
                }
            }
        };
        this.protocols.addListSelectionListener(this.protocolsListener);
        this.go.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Launcher.this.go();
            }
        });
        this.go.setEnabled(false);
        this.buttons.add(this.go);
        this.topPanel.add((Component)this.status, "North");
        this.topPanel.add((Component)new JScrollPane(this.protocols), "Center");
        this.topPanel.add((Component)this.buttons, "South");
        this.mainPanel.add(this.topPanel);
        this.setContentPane(this.mainPanel);
        this.pack();
    }

    public void add2Model(AbstractCollection abstractCollection, boolean bl) {
        int n = abstractCollection.size();
        this.protocolModel.setListenersEnabled(false);
        if (bl) {
            this.protocolModel.removeAllElements();
        }
        this.protocolModel.ensureCapacity(n);
        for (Object e : abstractCollection) {
            this.protocolModel.addElement(e);
        }
        this.protocolModel.setListenersEnabled(true);
        this.protocolModel.fireIntervalAdded(this, 0, n);
    }

    private void setStatus(String string) {
        this.status.setText("Status: " + string);
    }

    private void go() {
        if (this.launchClosure != null) {
            String string = null;
            int[] nArray = this.protocols.getSelectedIndices();
            if (nArray.length == 1) {
                string = this.protocolModel.getElementAt(nArray[0]).toString();
                this.setStatus("launching : " + string + ".");
            }
            this.launchClosure.applyClosure(this, string);
            return;
        }
        System.err.println("Your launch closure is null!");
    }
}

