/*
 * Decompiled with CFR 0.152.
 */
package g2d.npa;

import g2d.npa.AttackEditor;
import g2d.terms.Algebra;
import g2d.terms.Term;
import g2d.terms.TermEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

class SyntaxInput
extends JPanel {
    private final JButton button;
    private final JPanel buttonPanel = new JPanel();
    private final AttackEditor editor;
    private final Algebra algebra;
    private AbstractAction addTermAction = new AbstractAction("Add Term"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SyntaxInput.this.addTerm();
        }
    };

    private void addTerm() {
        JDialog jDialog = new JDialog((Frame)this.editor, true);
        TermEditor termEditor = new TermEditor((Window)jDialog, this.algebra, true);
        AttackEditor.npaPreferences.manageJDialog(jDialog, "NPATermDialog");
        jDialog.getContentPane().add((Component)termEditor, "Center");
        jDialog.pack();
        jDialog.setVisible(true);
        Term term = termEditor.getTerm();
        if (term == null) {
            this.editor.setStatus("Your term was null.", true);
        } else if (term.holeCount() > 0) {
            this.editor.setStatus("Your term still had holes.", true);
        } else {
            this.editor.addTerm(term);
        }
    }

    SyntaxInput(AttackEditor attackEditor) {
        super(new BorderLayout(10, 10));
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.editor = attackEditor;
        this.algebra = this.editor.syntax.attackAlgebra;
        this.button = new JButton(this.addTermAction);
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 2));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.buttonPanel.add(this.button);
        this.add((Component)this.buttonPanel, "Center");
    }

    public void enableInput() {
        this.button.setEnabled(true);
    }

    public void disableInput() {
        this.button.setEnabled(false);
    }
}

