/*
 * Decompiled with CFR 0.152.
 */
package g2d.npa;

import g2d.npa.AttackEditor;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class SyntaxHierarchy
extends JPanel {
    public static final int _MAX_WIDTH = 200;
    public static final int _MAX_HEIGHT = 200;
    private BufferedImage image = null;
    private Image thumbNail = null;
    private Dimension containerSize;
    private Insets insets = new Insets(0, 0, 0, 0);

    public SyntaxHierarchy(AttackEditor attackEditor) {
        this(attackEditor, 200, 200);
    }

    public SyntaxHierarchy(AttackEditor attackEditor, int n, int n2) {
        this.containerSize = new Dimension(n, n2);
        this.setMinimumSize(new Dimension(150, 100));
        this.setImage(attackEditor.syntax.makeImage());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                SyntaxHierarchy.this.resizeThumb(SyntaxHierarchy.this.getSize());
            }
        });
    }

    public void resizeThumb(Dimension dimension) {
        if (dimension == null) {
            throw new IllegalArgumentException("Cannot resize thumb nail to size NULL.");
        }
        this.containerSize = dimension;
        Dimension dimension2 = this.getPreferredSize();
        if (this.thumbNail == null) {
            this.makeThumbNail();
        }
        if (this.thumbNail != null) {
            boolean bl = true;
            double d = (double)dimension2.width / (double)dimension2.height;
            if (new Rectangle(dimension).contains(new Rectangle(dimension2))) {
                if (d < 1.0) {
                    if (dimension2.height == dimension.height) {
                        bl = false;
                    } else if (dimension2.width == dimension.width) {
                        bl = false;
                    }
                } else if (dimension2.width == dimension.width) {
                    bl = false;
                } else if (dimension2.width == dimension.width) {
                    bl = false;
                }
            }
            if (bl) {
                this.makeThumbNail();
            }
        } else {
            this.setPreferredSize(this.containerSize);
        }
        this.revalidate();
        this.repaint();
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        this.makeThumbNail();
        this.revalidate();
        this.repaint();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeThumbNail() {
        if (this.image != null) {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), BorderFactory.createMatteBorder(4, 4, 4, 4, Color.WHITE)));
            this.insets = this.getBorder().getBorderInsets(this);
            int n = this.containerSize.width - this.insets.left - this.insets.right;
            int n2 = this.containerSize.height - this.insets.top - this.insets.bottom;
            if (n > 0 && n2 > 0) {
                MediaTracker mediaTracker = new MediaTracker(this);
                this.setCursor(Cursor.getPredefinedCursor(3));
                double d = (double)this.image.getWidth() / (double)this.image.getHeight();
                double d2 = (double)n / (double)n2;
                this.thumbNail = d2 < d ? this.image.getScaledInstance(n, -1, 4) : this.image.getScaledInstance(-1, n2, 4);
                mediaTracker.addImage(this.thumbNail, 0);
                try {
                    mediaTracker.waitForID(0);
                    if (mediaTracker.isErrorID(0)) {
                        throw new IllegalArgumentException();
                    }
                }
                catch (InterruptedException interruptedException) {
                    System.err.println(interruptedException);
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                }
                this.setPreferredSize(new Dimension(this.thumbNail.getWidth(null) + this.insets.left + this.insets.right, this.thumbNail.getHeight(null) + this.insets.top + this.insets.bottom));
            } else {
                this.thumbNail = null;
            }
        } else {
            this.setBorder(null);
            this.insets = new Insets(0, 0, 0, 0);
            this.thumbNail = null;
        }
    }

    @Override
    public synchronized void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.thumbNail != null) {
            graphics.drawImage(this.thumbNail, this.insets.left, this.insets.top, Color.white, null);
        }
    }
}

