/*
 * Decompiled with CFR 0.152.
 */
package g2d.npa;

import g2d.npa.AttackEditor;
import g2d.npa.SortedTermTableModel;
import g2d.terms.Algebra;
import g2d.terms.Sort;
import g2d.terms.Term;
import g2d.terms.TermPoolListener;
import javax.swing.JTable;

public class SortedTermTable
extends JTable {
    private final boolean debug = false;
    private final AttackEditor editor;
    private final SortedTermTableModel model;
    private final Algebra algebra;

    public SortedTermTable(AttackEditor attackEditor) {
        this.editor = attackEditor;
        this.model = new SortedTermTableModel(attackEditor);
        this.algebra = this.editor.syntax.attackAlgebra;
        this.setModel(this.model);
        this.getTableHeader().setReorderingAllowed(false);
        this.algebra.addTermPoolListener(new TermPoolListener(){

            @Override
            public void termAdded(Term term) {
                SortedTermTable.this.addTerm(term, term.sort());
            }
        });
    }

    public void addTerm(Term term, Sort sort) {
        if (term != null && !this.model.terms.contains(term)) {
            this.model.addTerm(term, sort);
        }
    }
}

