/*
 * Decompiled with CFR 0.152.
 */
package g2d.npa;

import g2d.npa.AttackEditor;
import g2d.npa.RoleTableModel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RoleTable
extends JTable {
    private final AttackEditor editor;
    private final RoleTableModel model;

    public RoleTable(AttackEditor attackEditor) {
        this.editor = attackEditor;
        this.model = new RoleTableModel(attackEditor);
        this.setModel(this.model);
        this.setSelectionMode(0);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(false);
        this.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = RoleTable.this.getSelectedColumn();
                    if (n == -1) {
                        return;
                    }
                    String string = RoleTable.this.getColumnName(n);
                    AttackEditor.Tabs tabs = ((RoleTable)RoleTable.this).editor.mode;
                    boolean bl = false;
                    if (tabs == AttackEditor.Tabs.STRANDS) {
                        String string2 = "Would you like to add the role " + string + " to the attack strand?";
                        bl = RoleTable.this.confirmAddition(string2);
                    } else {
                        bl = tabs == AttackEditor.Tabs.PATTERNS ? RoleTable.this.verifyAddition(string) : RoleTable.this.explainAddition(string, tabs);
                    }
                    if (bl) {
                        RoleTable.this.editor.addRoleToAttack(string);
                    }
                    RoleTable.this.clearSelection();
                }
            }
        });
        this.getTableHeader().setReorderingAllowed(false);
    }

    boolean verifyAddition(String string) {
        boolean bl = this.editor.neverPatterns.hasSelectedPattern();
        if (bl) {
            String string2 = "Would you like to add the role " + string + " to the selected never pattern(s)?";
            return this.confirmAddition(string2);
        }
        String string3 = "To add the role " + string + " to the \"Never Patterns\" tab,\nyou need to create and select a particular never pattern.";
        return this.explainAddition(string3);
    }

    boolean explainAddition(String string, AttackEditor.Tabs tabs) {
        String string2 = "To add the role " + string + ", you need to either select the \"Stands\" tab,\n or else select the \"Never Patterns\" tab, and then\n (create and) select a particular never pattern.";
        return this.explainAddition(string2);
    }

    boolean explainAddition(String string) {
        JOptionPane.showMessageDialog(this.editor, string);
        return false;
    }

    boolean confirmAddition(String string) {
        Object[] objectArray = new Object[]{"Cancel", "Add to Table"};
        int n = JOptionPane.showOptionDialog(this.editor, string, "Attack Query", 0, 3, null, objectArray, objectArray[1]);
        return n == 1;
    }
}

