/*
 * Decompiled with CFR 0.152.
 */
package g2d.npa;

import g2d.npa.Role;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class Protocol {
    protected final HashMap<String, Role> rolesByName = new HashMap();
    protected final ArrayList<Role> roles;

    public Protocol(Role[] roleArray) {
        this.roles = new ArrayList<Role>(Arrays.asList(roleArray));
        for (Role role : roleArray) {
            this.rolesByName.put(role.name, role);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append("(\n");
        for (Role role : this.roles) {
            stringBuffer.append("\t");
            stringBuffer.append(role);
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n)");
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public Role getRole(String string) {
        return this.rolesByName.get(string);
    }

    public boolean addRole(Role role) {
        System.err.println("Protocol.addRole(" + role + ")");
        if (role != null) {
            this.rolesByName.put(role.name, role);
            this.roles.add(role);
            return true;
        }
        return false;
    }

    public boolean deleteRole(String string) {
        Role role;
        System.err.println("Protocol.deleteRole(" + string + ")");
        if (string != null && (role = this.getRole(string)) != null) {
            this.roles.remove(role);
            this.rolesByName.remove(string);
            return true;
        }
        return false;
    }
}

