/*
 * Decompiled with CFR 0.152.
 */
package g2d.netviewer;

import g2d.graph.GraphItem;
import g2d.graph.IOPGraph;
import g2d.graphviewer.GraphPanel;
import g2d.jlambda.Closure;
import g2d.jlambda.PrimitiveData;
import g2d.netviewer.NetContainer;
import g2d.netviewer.Utils;
import g2d.swing.IOPFileChooser;
import g2d.tabwin.TabFrame;
import g2d.util.IO;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TabFindGraphItem
extends JPanel
implements ChangeListener {
    private static final String COMPLETE = "complete";
    private static final String FIND_SELECT = "find_and_select";
    private final NetContainer owner;
    public final Font font;
    private final Closure filter;
    private final Closure renderer;
    private final JLabel description;
    private final JTextField graphItemField;
    private final ListModel graphItems = new ListModel();
    private final JList<GraphItem> graphItemList = new JList<GraphItem>(this.graphItems);
    private int lastIndex;
    private boolean completionInProgress = false;
    private boolean completionRemove = false;
    private boolean completionInsert = false;

    public TabFindGraphItem(NetContainer netContainer, Closure closure, Closure closure2) {
        this(netContainer, UIManager.getFont("Button.font").deriveFont(10.0f), closure, closure2);
    }

    public TabFindGraphItem(NetContainer netContainer, Font font, Closure closure) {
        this(netContainer, font, null, closure);
    }

    public TabFindGraphItem(NetContainer netContainer, Font font) {
        this(netContainer, font, null, null);
    }

    public TabFindGraphItem(NetContainer netContainer, Font font, Closure closure, Closure closure2) {
        this.owner = netContainer;
        this.font = font;
        this.filter = closure;
        this.renderer = closure2;
        this.graphItemList.setFont(font);
        this.graphItemList.setCellRenderer(new ListRenderer());
        this.graphItemField = this.makeField(this.graphItems, this.graphItemList);
        this.description = new JLabel("Find GraphItem:");
        this.description.setFont(this.font);
        this.init();
        this.stateChanged();
    }

    public String renderObject(Object object) {
        String string = "";
        string = this.renderer != null && object instanceof GraphItem ? this.renderer.applyClosure(object).toString() : object.toString();
        return string;
    }

    public boolean filterObject(Object object) {
        Object object2;
        boolean bl = true;
        if (this.filter != null && object instanceof GraphItem && (object2 = this.filter.applyClosure(object)) != null) {
            bl = (object2 = PrimitiveData.unwrap(object2)) instanceof Boolean && (Boolean)object2 != false;
        }
        return bl;
    }

    public void stateChanged() {
        this.stateChanged(new ChangeEvent(this));
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        IOPGraph iOPGraph = this.owner.getGraph();
        if (iOPGraph != null) {
            Collection<GraphItem> collection = iOPGraph.getGraphItemsInCollection();
            ArrayList<GraphItem> arrayList = new ArrayList<GraphItem>(collection);
            if (this.filter != null) {
                ArrayList<GraphItem> arrayList2 = new ArrayList<GraphItem>();
                for (GraphItem graphItem : collection) {
                    if (!this.filterObject(graphItem)) continue;
                    arrayList2.add(graphItem);
                }
                arrayList = arrayList2;
            }
            Collections.sort(arrayList, GraphItem.COMPARATOR);
            this.setGraphItems((List<GraphItem>)arrayList);
        }
    }

    public void setCellRendererClosure() {
        this.graphItemList.setCellRenderer(new ListRenderer());
    }

    private void init() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel.setOpaque(false);
        jPanel2.setOpaque(false);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        jPanel.add((Component)this.description, "North");
        jPanel.add((Component)this.graphItemField, "Center");
        this.configureList(this.graphItemList, this.graphItemField);
        JScrollPane jScrollPane = new JScrollPane(this.graphItemList);
        jScrollPane.setBackground(Color.white);
        this.add((Component)jPanel, "North");
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel2, "South");
        JButton jButton = new JButton(this.graphItemField.getAction());
        jButton.setToolTipText("Find graphItem (or [ENTER] in text field)");
        jButton.setOpaque(false);
        jPanel2.add(jButton);
        jButton = this.makeSaveButton();
        jPanel2.add(jButton);
        SelectingListener selectingListener = new SelectingListener(this.graphItemField, this.graphItems, this.graphItemList);
        this.graphItemField.getDocument().addDocumentListener(selectingListener);
        this.graphItemField.getDocument().putProperty("SelectingListener", selectingListener);
    }

    private JButton makeSaveButton() {
        JButton jButton = new JButton(new SaveAction());
        jButton.setOpaque(false);
        jButton.setToolTipText("Save the list to a file");
        return jButton;
    }

    private JTextField makeField(ListModel listModel, JList jList) {
        final JTextField jTextField = new JTextField(25);
        jTextField.setFont(this.font);
        jTextField.setFocusable(true);
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                super.focusGained(focusEvent);
                jTextField.setCaretPosition(0);
                jTextField.selectAll();
            }
        });
        jTextField.setAction(new FindAction(jTextField, jList));
        jTextField.setFocusTraversalKeysEnabled(false);
        jTextField.getInputMap().put(KeyStroke.getKeyStroke(9, 0), COMPLETE);
        jTextField.getActionMap().put(COMPLETE, new CompleteAction(jTextField, listModel));
        jTextField.getInputMap().put(KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), FIND_SELECT);
        jTextField.getActionMap().put(FIND_SELECT, new FindAction(jTextField, jList));
        return jTextField;
    }

    private void configureList(JList jList, JTextField jTextField) {
        jList.setSelectionMode(0);
        jList.setVisibleRowCount(-1);
        jList.addMouseListener(new FindListener(jList, jTextField));
    }

    public void setGraphItems(List<GraphItem> list) {
        this.graphItems.setData(list);
    }

    public void setGraphItems(Collection<GraphItem> collection) {
        ArrayList<GraphItem> arrayList = new ArrayList<GraphItem>(collection);
        this.graphItems.setData(arrayList);
    }

    private void setTFText(JTextField jTextField, String string) {
        this.completionInProgress = false;
        SelectingListener selectingListener = (SelectingListener)jTextField.getDocument().getProperty("SelectingListener");
        jTextField.getDocument().removeDocumentListener(selectingListener);
        jTextField.setText(string);
        jTextField.getDocument().addDocumentListener(selectingListener);
    }

    public void focus(boolean bl) {
        this.graphItemField.requestFocus();
    }

    public void wait4VisibleNFocus(boolean bl) {
        Visible2Focus visible2Focus = new Visible2Focus(this.graphItemField);
        this.addComponentListener(visible2Focus);
    }

    class ListRenderer
    extends JLabel
    implements ListCellRenderer<GraphItem> {
        public ListRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(10);
            this.setVerticalAlignment(0);
            this.setFont(TabFindGraphItem.this.font);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends GraphItem> jList, GraphItem graphItem, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            String string = TabFindGraphItem.this.renderObject(graphItem);
            this.setText(string);
            this.revalidate();
            this.setSize(this.getPreferredSize());
            return this;
        }
    }

    class ListModel
    extends AbstractListModel<GraphItem> {
        protected List<GraphItem> data = new ArrayList<GraphItem>();

        ListModel() {
        }

        public void setData(List<? extends GraphItem> list) {
            int n = this.getSize() - 1;
            this.data.clear();
            if (n >= 0) {
                this.fireIntervalRemoved(this, 0, n);
            }
            this.data = list == null ? new ArrayList<GraphItem>() : new ArrayList<GraphItem>(list);
            if (this.getSize() > 0) {
                this.fireIntervalAdded(this, 0, this.getSize() - 1);
            }
        }

        public int indexOfName(String string, boolean bl, int n) {
            int n2 = -1;
            if (n >= 0 && n <= this.data.size()) {
                ListIterator<GraphItem> listIterator = this.data.listIterator(n);
                while (listIterator.hasNext()) {
                    String string2 = TabFindGraphItem.this.renderObject(listIterator.next());
                    if (!bl && string2.equalsIgnoreCase(string) || string2.equals(string)) {
                        n2 = n;
                        break;
                    }
                    ++n;
                }
            }
            return n2;
        }

        public int indexOfCompletion(String string, int n) {
            int n2 = -1;
            if (string != null && !string.equals("")) {
                ListIterator<GraphItem> listIterator = this.data.listIterator(n);
                while (listIterator.hasNext()) {
                    String string2 = TabFindGraphItem.this.renderObject(listIterator.next());
                    if (string2.toLowerCase().startsWith(string.toLowerCase())) {
                        n2 = n;
                        break;
                    }
                    ++n;
                }
            }
            return n2;
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public GraphItem getElementAt(int n) {
            return this.data.get(n);
        }
    }

    class SelectingListener
    implements DocumentListener {
        private JTextField textField;
        private ListModel model;
        private JList list;

        public SelectingListener(JTextField jTextField, ListModel listModel, JList jList) {
            this.textField = jTextField;
            this.model = listModel;
            this.list = jList;
        }

        private void selectInList() {
            String string = this.textField.getText();
            int n = 0;
            if (TabFindGraphItem.this.completionInProgress) {
                n = TabFindGraphItem.this.lastIndex;
            }
            if ((n = this.model.indexOfName(string, true, n)) != -1) {
                this.list.setSelectionBackground(UIManager.getColor("List.selectionBackground"));
                this.list.setSelectionInterval(n, n);
                this.list.ensureIndexIsVisible(n);
            } else {
                n = this.model.indexOfCompletion(string, 0);
                if (n == -1) {
                    this.list.clearSelection();
                } else {
                    this.list.setSelectionBackground(Color.LIGHT_GRAY);
                    this.list.setSelectionInterval(n, n);
                    this.list.ensureIndexIsVisible(n);
                }
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.selectInList();
            if (!TabFindGraphItem.this.completionInsert) {
                TabFindGraphItem.this.completionInProgress = false;
            }
            TabFindGraphItem.this.completionInsert = false;
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.selectInList();
            if (!TabFindGraphItem.this.completionRemove) {
                TabFindGraphItem.this.completionInProgress = false;
            }
            TabFindGraphItem.this.completionRemove = false;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    class FindListener
    extends MouseAdapter {
        private JList list;
        private JTextField textField;

        public FindListener(JList jList, JTextField jTextField) {
            this.list = jList;
            this.textField = jTextField;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 0) {
                this.list.setSelectionBackground(UIManager.getColor("List.selectionBackground"));
                int n = this.list.locationToIndex(mouseEvent.getPoint());
                if (n != -1) {
                    this.list.setSelectionInterval(n, n);
                    this.list.ensureIndexIsVisible(n);
                    Object e = this.list.getSelectedValue();
                    String string = TabFindGraphItem.this.renderObject(e);
                    TabFindGraphItem.this.setTFText(this.textField, string);
                    if (mouseEvent.getClickCount() == 2) {
                        this.textField.getAction().actionPerformed(new ActionEvent(this.list, 1001, ""));
                    }
                }
            }
        }
    }

    class CompleteAction
    extends AbstractAction {
        private JTextField textField;
        private ListModel model;
        private String toBeCompleted = "";
        private int firstIndex;

        public CompleteAction(JTextField jTextField, ListModel listModel) {
            this.textField = jTextField;
            this.model = listModel;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            if (!TabFindGraphItem.this.completionInProgress) {
                TabFindGraphItem.this.completionInProgress = true;
                this.toBeCompleted = this.textField.getText();
                TabFindGraphItem.this.lastIndex = this.model.indexOfCompletion(this.toBeCompleted, 0);
                this.firstIndex = TabFindGraphItem.this.lastIndex;
                if (TabFindGraphItem.this.lastIndex == -1) {
                    TabFindGraphItem.this.completionInProgress = false;
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                string = TabFindGraphItem.this.renderObject(this.model.getElementAt(TabFindGraphItem.this.lastIndex));
                if (this.textField.getText().equals(string)) {
                    ++this.firstIndex;
                    this.textField.dispatchEvent(new KeyEvent(this.textField, 401, 0L, 0, 9, '\uffff'));
                    return;
                }
            } else {
                TabFindGraphItem.this.lastIndex = this.model.indexOfCompletion(this.toBeCompleted, TabFindGraphItem.this.lastIndex + 1);
                if (TabFindGraphItem.this.lastIndex == -1) {
                    TabFindGraphItem.this.lastIndex = this.firstIndex - 1;
                    string = this.toBeCompleted;
                } else {
                    string = TabFindGraphItem.this.renderObject(this.model.getElementAt(TabFindGraphItem.this.lastIndex));
                }
            }
            TabFindGraphItem.this.completionInsert = true;
            TabFindGraphItem.this.completionRemove = true;
            this.textField.setText(string);
        }
    }

    class FindAction
    extends AbstractAction {
        private JTextField textField;
        private JList list;

        public FindAction(JTextField jTextField, JList jList) {
            super("Find");
            this.textField = jTextField;
            this.list = jList;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object e = this.list.getSelectedValue();
            if (e instanceof GraphItem) {
                GraphPanel graphPanel;
                GraphItem graphItem = (GraphItem)e;
                String string = TabFindGraphItem.this.renderObject(graphItem);
                if (string.equalsIgnoreCase(this.textField.getText())) {
                    TabFindGraphItem.this.setTFText(this.textField, string);
                }
                if (TabFindGraphItem.this.owner != null && (graphPanel = TabFindGraphItem.this.owner.getGraphPanel()) != null && graphPanel.getGraph() != null) {
                    graphPanel.removeLastSelection();
                    graphPanel.highlight(graphItem);
                    graphPanel.centerOn(graphItem.getBounds().getBounds());
                }
                return;
            }
            Toolkit.getDefaultToolkit().beep();
        }
    }

    class Visible2Focus
    extends ComponentAdapter {
        JTextField textField;

        public Visible2Focus(JTextField jTextField) {
            this.textField = jTextField;
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            this.textField.requestFocus();
            TabFindGraphItem.this.removeComponentListener(this);
        }
    }

    class SaveAction
    extends AbstractAction {
        private final IOPFileChooser chooser;

        public SaveAction() {
            super("Save");
            this.chooser = new IOPFileChooser("raw_text_area");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.chooser.setDialogTitle("Save List to File");
            this.chooser.setMultiSelectionEnabled(false);
            this.chooser.situate();
            TabFrame tabFrame = Utils.getTabFrame(TabFindGraphItem.this.owner.getGraph());
            int n = this.chooser.showDialog(tabFrame, "Save");
            if (n != 0) {
                return;
            }
            File file = this.chooser.getSelectedFile();
            String[] stringArray = new String[((TabFindGraphItem)TabFindGraphItem.this).graphItems.data.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = TabFindGraphItem.this.renderObject(((TabFindGraphItem)TabFindGraphItem.this).graphItems.data.get(i));
            }
            IO.array2File(stringArray, file);
        }
    }
}

