/*
 * Decompiled with CFR 0.152.
 */
package g2d.netviewer;

import g2d.graph.IOPGraph;
import g2d.graph.IOPNode;
import g2d.graphviewer.GraphPanel;
import g2d.jlambda.Closure;
import g2d.jlambda.PrimitiveData;
import g2d.netviewer.NetContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TabFind
extends JPanel
implements ChangeListener {
    private static final String COMPLETE = "complete";
    private static final String FIND_SELECT = "find_and_select";
    private final NetContainer owner;
    public final Font font;
    private final Closure filter;
    private final Closure renderer;
    private final JTextField nodeField;
    private final ListModel nodes = new ListModel();
    private final JList<Object> nodeList = new JList<Object>(this.nodes);
    private int lastIndex;
    private boolean completionInProgress = false;
    private boolean completionRemove = false;
    private boolean completionInsert = false;

    public TabFind(NetContainer netContainer, Closure closure, Closure closure2) {
        this(netContainer, UIManager.getFont("Button.font").deriveFont(10.0f), closure, closure2);
    }

    public TabFind(NetContainer netContainer, Font font, Closure closure) {
        this(netContainer, font, null, closure);
    }

    public TabFind(NetContainer netContainer, Font font) {
        this(netContainer, font, null, null);
    }

    public TabFind(NetContainer netContainer, Font font, Closure closure, Closure closure2) {
        this.owner = netContainer;
        this.font = font;
        this.filter = closure;
        this.renderer = closure2;
        this.nodeList.setFont(font);
        this.nodeList.setCellRenderer(new ListRenderer());
        this.nodeField = this.makeField(this.nodes, this.nodeList);
        this.init();
    }

    public String renderObject(Object object) {
        String string = "";
        string = this.renderer != null && object instanceof IOPNode ? this.renderer.applyClosure(object).toString() : object.toString();
        return string;
    }

    public boolean filterObject(Object object) {
        Object object2;
        boolean bl = true;
        if (this.filter != null && object instanceof IOPNode && (object2 = this.filter.applyClosure(object)) != null) {
            bl = (object2 = PrimitiveData.unwrap(object2)) instanceof Boolean && (Boolean)object2 != false;
        }
        return bl;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        IOPGraph iOPGraph = this.owner.getGraph();
        if (iOPGraph != null) {
            Collection<IOPNode> collection = iOPGraph.getNodesInCollection();
            if (this.filter != null) {
                ArrayList<IOPNode> arrayList = new ArrayList<IOPNode>();
                for (IOPNode iOPNode : collection) {
                    if (!this.filterObject(iOPNode)) continue;
                    arrayList.add(iOPNode);
                }
                this.setNodes((List<IOPNode>)arrayList);
            } else {
                this.setNodes(collection);
            }
        }
    }

    public void setCellRendererClosure() {
        this.nodeList.setCellRenderer(new ListRenderer());
    }

    private void init() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 6, 3, 6);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        JLabel jLabel = new JLabel("Find Node:");
        jLabel.setFont(this.font);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.nodeField, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.configureList(this.nodeList, this.nodeField);
        JScrollPane jScrollPane = new JScrollPane(this.nodeList);
        jScrollPane.setBackground(Color.white);
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        JButton jButton = new JButton(this.nodeField.getAction());
        jButton.setToolTipText("Find node (or [ENTER] in text field)");
        jButton.setOpaque(false);
        this.add((Component)jButton, gridBagConstraints);
        SelectingListener selectingListener = new SelectingListener(this.nodeField, this.nodes, this.nodeList);
        this.nodeField.getDocument().addDocumentListener(selectingListener);
        this.nodeField.getDocument().putProperty("SelectingListener", selectingListener);
    }

    private JTextField makeField(ListModel listModel, JList jList) {
        final JTextField jTextField = new JTextField(25);
        jTextField.setFont(this.font);
        jTextField.setFocusable(true);
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                super.focusGained(focusEvent);
                jTextField.setCaretPosition(0);
                jTextField.selectAll();
            }
        });
        jTextField.setAction(new FindAction(jTextField, jList));
        jTextField.setFocusTraversalKeysEnabled(false);
        jTextField.getInputMap().put(KeyStroke.getKeyStroke(9, 0), COMPLETE);
        jTextField.getActionMap().put(COMPLETE, new CompleteAction(jTextField, listModel));
        jTextField.getInputMap().put(KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), FIND_SELECT);
        jTextField.getActionMap().put(FIND_SELECT, new FindAction(jTextField, jList));
        return jTextField;
    }

    private void configureList(JList jList, JTextField jTextField) {
        jList.setSelectionMode(0);
        jList.setVisibleRowCount(-1);
        jList.addMouseListener(new FindListener(jList, jTextField));
    }

    public void setNodes(List<IOPNode> list) {
        this.nodes.setData(list);
    }

    public void setNodes(Collection<IOPNode> collection) {
        ArrayList<IOPNode> arrayList = new ArrayList<IOPNode>(collection);
        this.nodes.setData(arrayList);
    }

    private void setTFText(JTextField jTextField, String string) {
        this.completionInProgress = false;
        SelectingListener selectingListener = (SelectingListener)jTextField.getDocument().getProperty("SelectingListener");
        jTextField.getDocument().removeDocumentListener(selectingListener);
        jTextField.setText(string);
        jTextField.getDocument().addDocumentListener(selectingListener);
    }

    public void focus(boolean bl) {
        this.nodeField.requestFocus();
    }

    public void wait4VisibleNFocus(boolean bl) {
        Visible2Focus visible2Focus = new Visible2Focus(this.nodeField);
        this.addComponentListener(visible2Focus);
    }

    class ListRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        public ListRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(10);
            this.setVerticalAlignment(0);
            this.setFont(TabFind.this.font);
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof IOPNode) {
                if (bl) {
                    this.setBackground(jList.getSelectionBackground());
                    this.setForeground(jList.getSelectionForeground());
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                }
                String string = TabFind.this.renderObject(object);
                this.setText(string);
                this.revalidate();
                this.setSize(this.getPreferredSize());
                return this;
            }
            return null;
        }
    }

    class ListModel
    extends AbstractListModel<Object> {
        private List<IOPNode> data = new ArrayList<IOPNode>();

        ListModel() {
        }

        public void setData(List<? extends IOPNode> list) {
            this.setData(list, true);
        }

        public void setData(List<? extends IOPNode> list, boolean bl) {
            int n = this.getSize() - 1;
            this.data.clear();
            if (n >= 0) {
                this.fireIntervalRemoved(this, 0, n);
            }
            this.data = list == null ? new ArrayList<IOPNode>() : new ArrayList<IOPNode>(list);
            if (bl) {
                Collections.sort(this.data);
            }
            if (this.getSize() > 0) {
                this.fireIntervalAdded(this, 0, this.getSize() - 1);
            }
        }

        public int indexOfName(String string, boolean bl, int n) {
            int n2 = -1;
            if (n >= 0 && n <= this.data.size()) {
                ListIterator<IOPNode> listIterator = this.data.listIterator(n);
                while (listIterator.hasNext()) {
                    String string2 = TabFind.this.renderObject(listIterator.next());
                    if (!bl && string2.equalsIgnoreCase(string) || string2.equals(string)) {
                        n2 = n;
                        break;
                    }
                    ++n;
                }
            }
            return n2;
        }

        public int indexOfCompletion(String string, int n) {
            int n2 = -1;
            if (string != null && !string.equals("")) {
                ListIterator<IOPNode> listIterator = this.data.listIterator(n);
                while (listIterator.hasNext()) {
                    String string2 = TabFind.this.renderObject(listIterator.next());
                    if (string2.toLowerCase().startsWith(string.toLowerCase())) {
                        n2 = n;
                        break;
                    }
                    ++n;
                }
            }
            return n2;
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public Object getElementAt(int n) {
            return this.data.get(n);
        }
    }

    class SelectingListener
    implements DocumentListener {
        private JTextField textField;
        private ListModel model;
        private JList list;

        public SelectingListener(JTextField jTextField, ListModel listModel, JList jList) {
            this.textField = jTextField;
            this.model = listModel;
            this.list = jList;
        }

        private void selectInList() {
            String string = this.textField.getText();
            int n = 0;
            if (TabFind.this.completionInProgress) {
                n = TabFind.this.lastIndex;
            }
            if ((n = this.model.indexOfName(string, true, n)) != -1) {
                this.list.setSelectionBackground(UIManager.getColor("List.selectionBackground"));
                this.list.setSelectionInterval(n, n);
                this.list.ensureIndexIsVisible(n);
            } else {
                n = this.model.indexOfCompletion(string, 0);
                if (n == -1) {
                    this.list.clearSelection();
                } else {
                    this.list.setSelectionBackground(Color.LIGHT_GRAY);
                    this.list.setSelectionInterval(n, n);
                    this.list.ensureIndexIsVisible(n);
                }
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.selectInList();
            if (!TabFind.this.completionInsert) {
                TabFind.this.completionInProgress = false;
            }
            TabFind.this.completionInsert = false;
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.selectInList();
            if (!TabFind.this.completionRemove) {
                TabFind.this.completionInProgress = false;
            }
            TabFind.this.completionRemove = false;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    class FindListener
    extends MouseAdapter {
        private JList list;
        private JTextField textField;

        public FindListener(JList jList, JTextField jTextField) {
            this.list = jList;
            this.textField = jTextField;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 0) {
                this.list.setSelectionBackground(UIManager.getColor("List.selectionBackground"));
                int n = this.list.locationToIndex(mouseEvent.getPoint());
                if (n != -1) {
                    this.list.setSelectionInterval(n, n);
                    this.list.ensureIndexIsVisible(n);
                    Object e = this.list.getSelectedValue();
                    String string = TabFind.this.renderObject(e);
                    TabFind.this.setTFText(this.textField, string);
                    if (mouseEvent.getClickCount() == 2) {
                        this.textField.getAction().actionPerformed(new ActionEvent(this.list, 1001, ""));
                    }
                }
            }
        }
    }

    class CompleteAction
    extends AbstractAction {
        private JTextField textField;
        private ListModel model;
        private String toBeCompleted = "";
        private int firstIndex;

        public CompleteAction(JTextField jTextField, ListModel listModel) {
            this.textField = jTextField;
            this.model = listModel;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            if (!TabFind.this.completionInProgress) {
                TabFind.this.completionInProgress = true;
                this.toBeCompleted = this.textField.getText();
                TabFind.this.lastIndex = this.model.indexOfCompletion(this.toBeCompleted, 0);
                this.firstIndex = TabFind.this.lastIndex;
                if (TabFind.this.lastIndex == -1) {
                    TabFind.this.completionInProgress = false;
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                string = TabFind.this.renderObject(this.model.getElementAt(TabFind.this.lastIndex));
                if (this.textField.getText().equals(string)) {
                    ++this.firstIndex;
                    this.textField.dispatchEvent(new KeyEvent(this.textField, 401, 0L, 0, 9, '\uffff'));
                    return;
                }
            } else {
                TabFind.this.lastIndex = this.model.indexOfCompletion(this.toBeCompleted, TabFind.this.lastIndex + 1);
                if (TabFind.this.lastIndex == -1) {
                    TabFind.this.lastIndex = this.firstIndex - 1;
                    string = this.toBeCompleted;
                } else {
                    string = TabFind.this.renderObject(this.model.getElementAt(TabFind.this.lastIndex));
                }
            }
            TabFind.this.completionInsert = true;
            TabFind.this.completionRemove = true;
            this.textField.setText(string);
        }
    }

    class FindAction
    extends AbstractAction {
        private JTextField textField;
        private JList list;

        public FindAction(JTextField jTextField, JList jList) {
            super("Find");
            this.textField = jTextField;
            this.list = jList;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IOPNode iOPNode;
            String string;
            Object e = this.list.getSelectedValue();
            if (e instanceof IOPNode && (string = TabFind.this.renderObject(iOPNode = (IOPNode)e)).equalsIgnoreCase(this.textField.getText())) {
                GraphPanel graphPanel;
                TabFind.this.setTFText(this.textField, string);
                if (TabFind.this.owner != null && (graphPanel = TabFind.this.owner.getGraphPanel()) != null && graphPanel.getGraph() != null) {
                    graphPanel.removeLastSelection();
                    graphPanel.highlight(iOPNode);
                    graphPanel.centerOn(iOPNode.getBounds().getBounds());
                }
                return;
            }
            Toolkit.getDefaultToolkit().beep();
        }
    }

    class Visible2Focus
    extends ComponentAdapter {
        JTextField textField;

        public Visible2Focus(JTextField jTextField) {
            this.textField = jTextField;
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            this.textField.requestFocus();
            TabFind.this.removeComponentListener(this);
        }
    }
}

