/*
 * Decompiled with CFR 0.152.
 */
package g2d.jlambda.code;

import g2d.jlambda.Analyse;
import g2d.jlambda.Code;
import g2d.jlambda.antlr4.visitor.Parser;
import java.util.ArrayList;

public abstract class CodeVisitor {
    private Object current;

    public static void visit(String string, CodeVisitor codeVisitor) {
        ArrayList arrayList = Parser.parseFromFile(string);
        if (arrayList != null) {
            for (Object e : arrayList) {
                codeVisitor.visit(e);
            }
        }
    }

    public Object visit(Object object) {
        this.current = object;
        if (object instanceof Code) {
            this.visitCode((Code)object);
        } else if (object instanceof String) {
            this.visitLiteral((String)object);
        } else {
            System.err.println("CodeVisitor.visit: Unexpected object type " + object.getClass());
        }
        return null;
    }

    public final Object getCurrentExpression() {
        return this.current;
    }

    protected abstract Object visitLiteral(String var1);

    protected abstract Object visitDefine(String var1, Code var2, Object var3);

    protected abstract Object visitLambda(Code var1, Object var2);

    protected abstract Object visitLet(Code var1, Object var2);

    protected abstract Object visitSeq(Code var1);

    protected abstract Object visitApply(Code var1);

    protected abstract Object visitIf(Object var1, Object var2, Object var3);

    protected abstract Object visitObject(Object var1);

    protected abstract Object visitFor(String var1, Object var2, Object var3);

    protected abstract Object visitTry(Object var1, Code var2);

    protected abstract Object visitCatch(String var1, Object var2);

    protected abstract Object visitOperation(String var1, Code var2);

    protected abstract Object visitData(String var1, String var2);

    protected abstract Object visitQuote(String var1);

    protected abstract Object visitDo(Code var1, Code var2, Code var3);

    private Object visitCode(Code code) {
        block24: {
            String string = null;
            try {
                Object object;
                if (code == null || code.isEmpty() || !((object = code.car()) instanceof String)) break block24;
                string = (String)object;
                if (Analyse.isPrimitiveForm(string)) {
                    String string2 = (String)code.cadr();
                    this.visitData(string, string2);
                    break block24;
                }
                if (Analyse.isUnaryForm(string)) {
                    this.visitOperation(string, (Code)code.cdr());
                    break block24;
                }
                if (Analyse.isBinaryForm(string)) {
                    this.visitOperation(string, (Code)code.cdr());
                    break block24;
                }
                if (Analyse.canBeNullaryForm(string)) {
                    if (string == "seq") {
                        this.visitSeq((Code)code.cdr());
                    } else {
                        this.visitOperation(string, (Code)code.cdr());
                    }
                    break block24;
                }
                if (this.isOperation(string)) {
                    this.visitOperation(string, (Code)code.cdr());
                    break block24;
                }
                if (string == "apply") {
                    this.visitApply((Code)code.cdr());
                    break block24;
                }
                if (string == "define") {
                    if (code.size() == 3) {
                        this.visitDefine((String)code.cadr(), null, code.caddr());
                    } else {
                        this.visitDefine((String)code.cadr(), (Code)code.caddr(), code.cddr().cadr());
                    }
                    break block24;
                }
                if (string == "if") {
                    if (code.size() == 3) {
                        this.visitIf(code.cadr(), code.caddr(), null);
                    } else {
                        this.visitIf(code.cadr(), code.caddr(), code.cddr().cadr());
                    }
                    break block24;
                }
                if (string == "do") {
                    this.visitDo((Code)code.cadr(), (Code)code.caddr(), (Code)code.cddr().cadr());
                    break block24;
                }
                if (string == "for") {
                    this.visitFor((String)code.cadr(), code.caddr(), (Code)code.cddr().cadr());
                    break block24;
                }
                if (string == "lambda") {
                    this.visitLambda((Code)code.cadr(), code.caddr());
                    break block24;
                }
                if (string == "let") {
                    this.visitLet((Code)code.cadr(), code.caddr());
                    break block24;
                }
                if (string == "object") {
                    this.visitObject(code.cadr());
                    break block24;
                }
                if (string == "quote") {
                    this.visitQuote((String)code.cadr());
                    break block24;
                }
                if (string == "try") {
                    this.visitTry(code.cadr(), (Code)code.caddr());
                    break block24;
                }
                if (string == "catch") {
                    this.visitCatch((String)code.cadr(), code.caddr());
                    break block24;
                }
                String string3 = "CodeVisitor.visitCode: Unexpected operation: " + string;
                throw new RuntimeException(string3);
            }
            catch (Exception exception) {
                String string4 = String.format("CodeVisitor.visitCode(%s : %d): %s  %s\n", string, code.size(), code, exception);
                throw new RuntimeException(string4);
            }
        }
        return null;
    }

    private boolean isOperation(String string) {
        boolean bl = string == "and" || string == "array" || string == "aset" || string == "getattr" || string == "invoke" || string == "-" || string == "mkarray" || string == "or" || string == "setattr" || string == "sinvoke" || string == "supdate" || string == "update";
        return bl;
    }
}

