/*
 * Decompiled with CFR 0.152.
 */
package g2d.jlambda;

import g2d.jlambda.Code;
import g2d.jlambda.Constants;
import g2d.jlambda.Debugger;
import g2d.jlambda.Evaluate;
import g2d.jlambda.SyntaxError;
import g2d.jlambda.Utils;
import g2d.jlambda.antlr4.visitor.ParseError;
import g2d.jlambda.antlr4.visitor.Parser;
import java.io.BufferedInputStream;
import java.util.ArrayList;

public final class ReadEvalPrintLoop {
    public static boolean FULL_DFNS = false;
    private static final int WAIT_IN_MILLISECS = 100;
    public static final String PROMPT = "\n> ";
    public static final String EMPTY = "";
    public static final String Q = "q";
    public static final String HELP = "?";
    public static final String DFNS = "d";
    public static final String UIDS = "u";
    public static final String SHOW = "s ";
    public static final String TOGGLE = "v";
    public static final String QUIT = "quit";
    public static final char OPENP = '(';
    private static final String WELCOME = "\nWelcome to the JLambda interface to Java (version 3447), type ? for help.\n";
    private static final String INSTRUCTIONS = "Type one of the following:\n\tany valid jlambda expression to be evaluated, or\n\tq to quit  (or quit)\n\t? to see these instructions\n\td to see the current definitions\n\ts <name> to see the raw definition of <name>\n\tu to see the current uids\n\tv to toggle the degree of verbosity in error reports\n";

    public static String snarf(BufferedInputStream bufferedInputStream, int n) {
        try {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n2 = bufferedInputStream.read()) != -1) {
                stringBuffer.append((char)n2);
                if (n2 != 10) continue;
                Thread.sleep(n);
                int n3 = bufferedInputStream.available();
                if (n3 != 0) continue;
                break;
            }
            String string = stringBuffer.toString();
            return string;
        }
        catch (Exception exception) {
            Utils.err.println(exception.getMessage());
            return null;
        }
    }

    private ReadEvalPrintLoop() {
    }

    public static void main(String[] stringArray) {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(Utils.in);
        if (stringArray.length == 0 || stringArray.length > 2) {
            Utils.out.println("Usage: java g2d/jlambda/ReadEvalPrintLoop <iop bin dir> [filename]");
            return;
        }
        Constants.setBinaryDirectory(stringArray[0]);
        if (stringArray.length == 2) {
            ReadEvalPrintLoop.loadFile(stringArray[1]);
        }
        Utils.err.println(WELCOME);
        while (true) {
            Utils.err.print(PROMPT);
            String string = ReadEvalPrintLoop.snarf(bufferedInputStream, 100).trim();
            Object object = null;
            if (string == null || string.equals(EMPTY)) continue;
            if (string.equalsIgnoreCase(Q) || string.equalsIgnoreCase(QUIT)) {
                System.exit(0);
            }
            if (string.equalsIgnoreCase(HELP)) {
                Utils.err.println(INSTRUCTIONS);
                continue;
            }
            if (string.equalsIgnoreCase(DFNS)) {
                Evaluate.printDefinitions(FULL_DFNS);
                continue;
            }
            if (string.equalsIgnoreCase(UIDS)) {
                Evaluate.printUIDs();
                continue;
            }
            if (string.startsWith(SHOW)) {
                Evaluate.showDefinition(string);
                continue;
            }
            if (string.equalsIgnoreCase(TOGGLE)) {
                Utils.err.println("Error logging verbosity is now: " + Debugger.toggleVerbosity());
                continue;
            }
            try {
                object = Evaluate.evaluateText(string + "\n");
            }
            catch (ParseError parseError) {
                Utils.err.println(parseError);
                continue;
            }
            catch (SyntaxError syntaxError) {
                Utils.err.println(syntaxError);
                continue;
            }
            catch (Exception exception) {
                Utils.err.println(exception);
                continue;
            }
            try {
                if (object == null) continue;
                Utils.err.print(object.toString());
                continue;
            }
            catch (Exception exception) {
                Utils.err.println("Printing result threw: " + exception);
                continue;
            }
            break;
        }
    }

    private static void loadFile(String string) {
        try {
            ArrayList arrayList = Parser.parseFromFile(string);
            for (Object e : arrayList) {
                if (!(e instanceof Code)) continue;
                Evaluate.evaluate((Code)e);
            }
        }
        catch (Exception exception) {
            Utils.err.println(exception);
        }
    }
}

