/*
 * Decompiled with CFR 0.152.
 */
package g2d.jlambda;

import g2d.jlambda.Continuation;
import g2d.jlambda.Environment;
import g2d.jlambda.EvaluateError;
import g2d.jlambda.Interpreter;
import java.lang.ref.WeakReference;

public final class Closure {
    public final Object body;
    public final Environment env;
    public final int arity;
    private final WeakReference<Interpreter> engineRef;

    private Object callMe(Environment environment) {
        Interpreter interpreter = (Interpreter)this.engineRef.get();
        if (interpreter != null) {
            return interpreter.evaluate(this.body, environment);
        }
        System.err.println("Closure lost it's interpreter: " + this.toString());
        return null;
    }

    protected Closure(int n, Object object, Environment environment, Continuation continuation, Interpreter interpreter) throws EvaluateError {
        this.engineRef = new WeakReference<Interpreter>(interpreter);
        if (environment == null) {
            String string = "Closure.Closure(): env is null";
            throw new EvaluateError(string, continuation.info());
        }
        if (n < 0) {
            String string = "Closure.Closure(): arity is negative";
            throw new EvaluateError(string, continuation.info());
        }
        this.env = environment;
        this.body = object;
        this.arity = n;
    }

    public String toString() {
        String string = "<(lambda ";
        string = string + this.arity + " ";
        string = string + this.body + "), ";
        string = string + this.env + ">";
        return string;
    }

    protected Object getBody() {
        return this.body;
    }

    protected Environment getEnv() {
        return this.env;
    }

    public int getArity() {
        return this.arity;
    }

    public Object applyClosure() {
        assert (this.arity == 0);
        return this.callMe(this.env);
    }

    public Object applyClosure(Object object) {
        assert (this.arity == 1);
        Object[] objectArray = new Object[]{object};
        return this.callMe(this.env.extend(objectArray));
    }

    public Object applyClosure(Object object, Object object2) {
        assert (this.arity == 2);
        Object[] objectArray = new Object[]{object, object2};
        return this.callMe(this.env.extend(objectArray));
    }

    public Object applyClosure(Object object, Object object2, Object object3) {
        assert (this.arity == 3);
        Object[] objectArray = new Object[]{object, object2, object3};
        return this.callMe(this.env.extend(objectArray));
    }

    public Object applyClosure(Object object, Object object2, Object object3, Object object4) {
        assert (this.arity == 4);
        Object[] objectArray = new Object[]{object, object2, object3, object4};
        return this.callMe(this.env.extend(objectArray));
    }

    public Object applyClosure(Object object, Object object2, Object object3, Object object4, Object object5) {
        assert (this.arity == 4);
        Object[] objectArray = new Object[]{object, object2, object3, object4};
        objectArray[4] = object5;
        return this.callMe(this.env.extend(objectArray));
    }
}

