/*
 * Decompiled with CFR 0.152.
 */
package g2d.jlambda;

final class Char {
    public static final int HEXIDECIMAL = 16;
    public static final int DECIMAL = 10;
    public static final int OCTAL = 8;

    private Char() {
    }

    static char integerStringToChar(String string, int n) {
        if (string == null) {
            return '\u0000';
        }
        try {
            int n2 = Integer.parseInt(string, n);
            return (char)n2;
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("integerStringToChar: warning -- " + numberFormatException);
            return '\u0000';
        }
    }

    static Character stringToCharacter(String string) {
        return new Character(Char.stringToChar(string));
    }

    static char stringToChar(String string) {
        if (string == null) {
            return '\u0000';
        }
        int n = string.length();
        if (n == 0) {
            return '\u0000';
        }
        if (string.charAt(0) == '\'' && string.charAt(n - 1) == '\'') {
            if (n == 3) {
                char c = string.charAt(1);
                if (c == '\'' || c == '\\') {
                    System.err.println("stringToChar: illegal single character literal: " + c);
                    return '\u0000';
                }
                return c;
            }
            if (string.charAt(1) != '\\') {
                return Char.integerStringToChar(string, 10);
            }
            if (n == 4) {
                switch (string.charAt(2)) {
                    case 'b': {
                        return '\b';
                    }
                    case 't': {
                        return '\t';
                    }
                    case 'n': {
                        return '\n';
                    }
                    case 'f': {
                        return '\f';
                    }
                    case 'r': {
                        return '\r';
                    }
                    case '\"': {
                        return '\"';
                    }
                    case '\'': {
                        return '\'';
                    }
                    case '\\': {
                        return '\\';
                    }
                }
                System.err.println("stringToChar: unrecognized escape sequence : " + string);
                return '\u0000';
            }
            if (n == 6) {
                String string2 = string.substring(2, n - 1);
                return Char.integerStringToChar(string2, 8);
            }
            if (n == 8 && string.charAt(2) == 'u') {
                String string3 = string.substring(3, n - 1);
                return Char.integerStringToChar(string3, 16);
            }
            return Char.integerStringToChar(string, 10);
        }
        return Char.integerStringToChar(string, 10);
    }

    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length != 1) {
            System.out.println("Usage: java Char <string>");
            return;
        }
        System.out.println("Character is: " + Char.stringToChar(stringArray[0]));
    }
}

