/*
 * Decompiled with CFR 0.152.
 */
package g2d.jlambda;

import g2d.jlambda.Closure;
import g2d.jlambda.Identifiable;
import g2d.jlambda.JMap;
import java.io.PrintStream;
import java.util.Map;
import java.util.Set;

public class Attributable
extends Identifiable {
    private static final Map<String, Object> staticAttributes = new JMap().makeMap();
    private final Map<String, Object> attributes = new JMap().makeMap();

    public Attributable() {
    }

    public Attributable(Attributable attributable) {
        Set<String> set = attributable.attributes.keySet();
        for (String string : set) {
            this.attributes.put(string, attributable.attributes.get(string));
        }
    }

    public void showAttributes(PrintStream printStream) {
        Set<String> set = this.attributes.keySet();
        for (String string : set) {
            printStream.println(string + " ===> " + this._toString(this.attributes.get(string)));
        }
    }

    public void showAttributes(StringBuffer stringBuffer) {
        Set<String> set = this.attributes.keySet();
        for (String string : set) {
            stringBuffer.append(string).append(" ===> ");
            this.toStringBuffer(stringBuffer, this.attributes.get(string));
            stringBuffer.append("\n");
        }
    }

    private void toStringBuffer(StringBuffer stringBuffer, Object object) {
        if (object instanceof Object[]) {
            boolean bl = true;
            stringBuffer.append("[ ");
            for (Object object2 : (Object[])object) {
                if (!bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this._toString(object2));
                bl = false;
            }
            stringBuffer.append("]");
        } else if (object instanceof String[]) {
            boolean bl = true;
            stringBuffer.append("[ ");
            for (String string : (String[])object) {
                if (!bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string);
                bl = false;
            }
            stringBuffer.append("]");
        } else {
            stringBuffer.append(object == null ? "null" : object.toString());
        }
    }

    private String _toString(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        this.toStringBuffer(stringBuffer, object);
        return stringBuffer.toString();
    }

    public void setAttribute(String string, Object object) {
        this._setAttribute(string, object);
    }

    public final void _setAttribute(String string, Object object) {
        if (object == null) {
            this.attributes.remove(string);
        } else {
            this.attributes.put(string, object);
        }
    }

    public boolean isAttribute(String string) {
        return this.attributes.containsKey(string);
    }

    public Object getAttribute(String string) {
        return this._getAttribute(string);
    }

    public final Object _getAttribute(String string) {
        return this.attributes.get(string);
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    public void removeAllAttributes() {
        this.attributes.clear();
    }

    public String[] getKeys() {
        Set<String> set = this.attributes.keySet();
        return set.toArray(new String[set.size()]);
    }

    public void setStaticAttribute(String string, Object object) {
        staticAttributes.put(string, object);
    }

    public boolean isStaticAttribute(String string) {
        return staticAttributes.containsKey(string);
    }

    public Object getStaticAttribute(String string) {
        return staticAttributes.get(string);
    }

    public void removeStaticAttribute(String string) {
        staticAttributes.remove(string);
    }

    public void removeAllStaticAttributes() {
        staticAttributes.clear();
    }

    public String[] getStaticKeys() {
        Set<String> set = staticAttributes.keySet();
        return set.toArray(new String[set.size()]);
    }

    public byte getAttributeAsByte(String string, byte by) {
        Object object = this.getAttribute(string);
        return object instanceof Byte ? (Byte)object : by;
    }

    public boolean getAttributeAsBoolean(String string, boolean bl) {
        Object object = this.getAttribute(string);
        return object instanceof Boolean ? (Boolean)object : bl;
    }

    public char getAttributeAsChar(String string, char c) {
        Object object = this.getAttribute(string);
        return object instanceof Character ? ((Character)object).charValue() : c;
    }

    public double getAttributeAsDouble(String string, double d) {
        Object object = this.getAttribute(string);
        return object instanceof Double ? (Double)object : d;
    }

    public float getAttributeAsFloat(String string, float f) {
        Object object = this.getAttribute(string);
        return object instanceof Float ? ((Float)object).floatValue() : f;
    }

    public int getAttributeAsInt(String string, int n) {
        Object object = this.getAttribute(string);
        return object instanceof Integer ? (Integer)object : n;
    }

    public short getAttributeAsShort(String string, short s) {
        Object object = this.getAttribute(string);
        return object instanceof Short ? (Short)object : s;
    }

    public String getAttributeAsString(String string, String string2) {
        Object object = this.getAttribute(string);
        return object instanceof String ? (String)object : string2;
    }

    public Closure getAttributeAsClosure(String string, Closure closure) {
        Object object = this.getAttribute(string);
        return object instanceof Closure ? (Closure)object : closure;
    }
}

