/*
 * Decompiled with CFR 0.152.
 */
package g2d.jlambda;

import g2d.jlambda.Continuation;
import g2d.jlambda.EvaluateError;

final class Arithmetic {
    public static final String BYTE = "byte";
    public static final String SHORT = "short";
    public static final String CHAR = "char";
    public static final String INT = "int";
    public static final String LONG = "long";
    public static final String FLOAT = "float";
    public static final String DOUBLE = "double";
    public static final int MINUS = 0;
    public static final int PLUS = 1;
    public static final int TIMES = 2;
    public static final int DIVIDE = 3;
    public static final int MODULO = 4;
    public static final int EQUALS = 5;
    public static final int NEQ = 6;
    public static final int LT = 7;
    public static final int LEQ = 8;
    public static final int GT = 9;
    public static final int GEQ = 10;

    private Arithmetic() {
    }

    public static Number minus(Number number) {
        assert (number != null);
        if (number instanceof Double) {
            return new Double(-number.floatValue());
        }
        if (number instanceof Float) {
            return new Float(-number.floatValue());
        }
        if (number instanceof Long) {
            return new Long(-number.longValue());
        }
        return new Integer(-number.intValue());
    }

    public static int binop(int n, int n2, int n3, Continuation continuation) throws EvaluateError {
        switch (n) {
            case 0: {
                return n2 - n3;
            }
            case 1: {
                return n2 + n3;
            }
            case 2: {
                return n2 * n3;
            }
            case 3: {
                return n2 / n3;
            }
            case 4: {
                return n2 % n3;
            }
        }
        String string = "Arithmetic.binop: unknown type -- " + n;
        throw new EvaluateError(string, continuation.info());
    }

    public static long binop(int n, long l, long l2, Continuation continuation) throws EvaluateError {
        switch (n) {
            case 0: {
                return l - l2;
            }
            case 1: {
                return l + l2;
            }
            case 2: {
                return l * l2;
            }
            case 3: {
                return l / l2;
            }
            case 4: {
                return l % l2;
            }
        }
        String string = "Arithmetic.binop: unknown type -- " + n;
        throw new EvaluateError(string, continuation.info());
    }

    public static float binop(int n, float f, float f2, Continuation continuation) throws EvaluateError {
        switch (n) {
            case 0: {
                return f - f2;
            }
            case 1: {
                return f + f2;
            }
            case 2: {
                return f * f2;
            }
            case 3: {
                return f / f2;
            }
            case 4: {
                return f % f2;
            }
        }
        String string = "Arithmetic.binop: unknown type -- " + n;
        throw new EvaluateError(string, continuation.info());
    }

    public static double binop(int n, double d, double d2, Continuation continuation) throws EvaluateError {
        switch (n) {
            case 0: {
                return d - d2;
            }
            case 1: {
                return d + d2;
            }
            case 2: {
                return d * d2;
            }
            case 3: {
                return d / d2;
            }
            case 4: {
                return d % d2;
            }
        }
        String string = "Arithmetic.binop: unknown type -- " + n;
        throw new EvaluateError(string, continuation.info());
    }

    public static Number binop(int n, Number number, Number number2, Continuation continuation) throws EvaluateError {
        assert (number != null && number2 != null);
        if (number instanceof Double || number2 instanceof Double) {
            return new Double(Arithmetic.binop(n, number.doubleValue(), number2.doubleValue(), continuation));
        }
        if (number instanceof Float || number2 instanceof Float) {
            return new Float(Arithmetic.binop(n, number.floatValue(), number2.floatValue(), continuation));
        }
        if (number instanceof Long || number2 instanceof Long) {
            return new Long(Arithmetic.binop(n, number.longValue(), number2.longValue(), continuation));
        }
        return new Integer(Arithmetic.binop(n, number.intValue(), number2.intValue(), continuation));
    }

    public static boolean binrel(int n, int n2, int n3, Continuation continuation) throws EvaluateError {
        switch (n) {
            case 9: {
                return n2 < n3;
            }
            case 10: {
                return n2 <= n3;
            }
            case 7: {
                return n2 > n3;
            }
            case 8: {
                return n2 >= n3;
            }
            case 5: {
                return n2 == n3;
            }
            case 6: {
                return n2 != n3;
            }
        }
        String string = "Arithmetic.binrel: unknown type -- " + n;
        throw new EvaluateError(string, continuation.info());
    }

    public static boolean binrel(int n, long l, long l2, Continuation continuation) throws EvaluateError {
        switch (n) {
            case 9: {
                return l < l2;
            }
            case 10: {
                return l <= l2;
            }
            case 7: {
                return l > l2;
            }
            case 8: {
                return l >= l2;
            }
            case 5: {
                return l == l2;
            }
            case 6: {
                return l != l2;
            }
        }
        String string = "Arithmetic.binrel: unknown type -- " + n;
        throw new EvaluateError(string, continuation.info());
    }

    public static boolean binrel(int n, float f, float f2, Continuation continuation) throws EvaluateError {
        switch (n) {
            case 9: {
                return f < f2;
            }
            case 10: {
                return f <= f2;
            }
            case 7: {
                return f > f2;
            }
            case 8: {
                return f >= f2;
            }
            case 5: {
                return f == f2;
            }
            case 6: {
                return f != f2;
            }
        }
        String string = "Arithmetic.binrel: unknown type -- " + n;
        throw new EvaluateError(string, continuation.info());
    }

    public static boolean binrel(int n, double d, double d2, Continuation continuation) throws EvaluateError {
        switch (n) {
            case 9: {
                return d < d2;
            }
            case 10: {
                return d <= d2;
            }
            case 7: {
                return d > d2;
            }
            case 8: {
                return d >= d2;
            }
            case 5: {
                return d == d2;
            }
            case 6: {
                return d != d2;
            }
        }
        String string = "Arithmetic.binrel: unknown type -- " + n;
        throw new EvaluateError(string, continuation.info());
    }

    public static Boolean binrel(int n, Number number, Number number2, Continuation continuation) throws EvaluateError {
        assert (number != null && number2 != null);
        if (number instanceof Double || number2 instanceof Double) {
            return new Boolean(Arithmetic.binrel(n, number.doubleValue(), number2.doubleValue(), continuation));
        }
        if (number instanceof Float || number2 instanceof Float) {
            return new Boolean(Arithmetic.binrel(n, number.floatValue(), number2.floatValue(), continuation));
        }
        if (number instanceof Long || number2 instanceof Long) {
            return new Boolean(Arithmetic.binrel(n, number.longValue(), number2.longValue(), continuation));
        }
        return new Boolean(Arithmetic.binrel(n, number.intValue(), number2.intValue(), continuation));
    }

    public static Object narrow(Object object, String string, Continuation continuation) throws EvaluateError {
        if (object instanceof Character) {
            return Arithmetic.narrow((Character)object, string, continuation);
        }
        if (object instanceof Number) {
            if (object instanceof Byte) {
                return Arithmetic.narrow((Byte)object, string, continuation);
            }
            if (object instanceof Short) {
                return Arithmetic.narrow((Short)object, string, continuation);
            }
            if (object instanceof Integer) {
                return Arithmetic.narrow((Integer)object, string, continuation);
            }
            if (object instanceof Long) {
                return Arithmetic.narrow((Long)object, string, continuation);
            }
            if (object instanceof Float) {
                return Arithmetic.narrow((Float)object, string, continuation);
            }
            if (object instanceof Double) {
                return Arithmetic.narrow((Double)object, string, continuation);
            }
        }
        String string2 = "Arithmetic.narrow: source not numeric -- " + object;
        throw new EvaluateError(string2, continuation.info());
    }

    public static Object narrow(Byte by, String string, Continuation continuation) throws EvaluateError {
        byte by2 = by;
        if (string.equals(CHAR)) {
            return new Character((char)by2);
        }
        String string2 = "Arithmetic.narrow(Byte): not a narrowing -- " + string;
        throw new EvaluateError(string2, continuation.info());
    }

    public static Object narrow(Short s, String string, Continuation continuation) throws EvaluateError {
        short s2 = s;
        if (string.equals(BYTE)) {
            return new Byte((byte)s2);
        }
        if (string.equals(CHAR)) {
            return new Character((char)s2);
        }
        String string2 = "Arithmetic.narrow(Short): not a narrowing -- " + string;
        throw new EvaluateError(string2, continuation.info());
    }

    public static Object narrow(Character c, String string, Continuation continuation) throws EvaluateError {
        char c2 = c.charValue();
        if (string.equals(BYTE)) {
            return new Byte((byte)c2);
        }
        if (string.equals(SHORT)) {
            return new Short((short)c2);
        }
        String string2 = "Arithmetic.narrow(Character): not a narrowing: " + string;
        throw new EvaluateError(string2, continuation.info());
    }

    public static Object narrow(Integer n, String string, Continuation continuation) throws EvaluateError {
        int n2 = n;
        if (string.equals(BYTE)) {
            return new Byte((byte)n2);
        }
        if (string.equals(SHORT)) {
            return new Short((short)n2);
        }
        if (string.equals(CHAR)) {
            return new Character((char)n2);
        }
        String string2 = "Arithmetic.narrow(Integer): not a narrowing -- " + string;
        throw new EvaluateError(string2, continuation.info());
    }

    public static Object narrow(Long l, String string, Continuation continuation) throws EvaluateError {
        long l2 = l;
        if (string.equals(BYTE)) {
            return new Byte((byte)l2);
        }
        if (string.equals(SHORT)) {
            return new Short((short)l2);
        }
        if (string.equals(CHAR)) {
            return new Character((char)l2);
        }
        if (string.equals(INT)) {
            return new Integer((int)l2);
        }
        String string2 = "Arithmetic.narrow(Long): not a narrowing: " + string;
        throw new EvaluateError(string2, continuation.info());
    }

    public static Object narrow(Float f, String string, Continuation continuation) throws EvaluateError {
        float f2 = f.floatValue();
        if (string.equals(BYTE)) {
            return new Byte((byte)f2);
        }
        if (string.equals(SHORT)) {
            return new Short((short)f2);
        }
        if (string.equals(CHAR)) {
            return new Character((char)f2);
        }
        if (string.equals(INT)) {
            return new Integer((int)f2);
        }
        if (string.equals(LONG)) {
            return new Long((long)f2);
        }
        String string2 = "Arithmetic.narrow(Float): not a narrowing -- " + string;
        throw new EvaluateError(string2, continuation.info());
    }

    public static Object narrow(Double d, String string, Continuation continuation) throws EvaluateError {
        double d2 = d;
        if (string.equals(BYTE)) {
            return new Byte((byte)d2);
        }
        if (string.equals(SHORT)) {
            return new Short((short)d2);
        }
        if (string.equals(CHAR)) {
            return new Character((char)d2);
        }
        if (string.equals(INT)) {
            return new Integer((int)d2);
        }
        if (string.equals(LONG)) {
            return new Long((long)d2);
        }
        if (string.equals(FLOAT)) {
            return new Float((float)d2);
        }
        String string2 = "Arithmetic.narrow(Double): not a narrowing -- " + string;
        throw new EvaluateError(string2, continuation.info());
    }
}

