/*
 * Decompiled with CFR 0.152.
 */
package g2d.graphviewer;

import g2d.graph.IOPNode;
import g2d.graphviewer.AbstractBaseFrame;
import g2d.graphviewer.GraphPanel;
import g2d.graphviewer.KeyStrokeDisplayer;
import g2d.graphviewer.list.ListModel;
import g2d.graphviewer.list.ListRenderer;
import g2d.jlambda.Closure;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TabFind
extends JPanel {
    private static final String COMPLETE = "complete";
    private static final String FIND_SELECT = "find_and_select";
    private final AbstractBaseFrame owner;
    private final Font font;
    private JTextField nodeField;
    private ListModel nodes = new ListModel();
    private JList<IOPNode> nodeList = new JList<IOPNode>(this.nodes);
    private int lastIndex;
    private boolean completionInProgress = false;
    private boolean completionRemove = false;
    private boolean completionInsert = false;

    public TabFind(AbstractBaseFrame abstractBaseFrame, Font font, Closure closure) {
        this.owner = abstractBaseFrame;
        this.font = font;
        this.init(abstractBaseFrame, font, closure);
    }

    public TabFind(AbstractBaseFrame abstractBaseFrame, Font font) {
        this.owner = abstractBaseFrame;
        this.font = font;
        this.init(abstractBaseFrame, font, null);
    }

    public void setCellRendererClosure(Closure closure) {
        this.nodeList.setCellRenderer(new ListRenderer(this.font, this.owner, closure));
    }

    private void init(AbstractBaseFrame abstractBaseFrame, Font font, Closure closure) {
        this.setOpaque(false);
        this.nodeList.setFont(font);
        this.nodeList.setCellRenderer(new ListRenderer(font, abstractBaseFrame, closure));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 6, 3, 6);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        JLabel jLabel = new JLabel("Find Node (" + KeyStrokeDisplayer.displayKeyStroke(KeyStroke.getKeyStroke(79, 1 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) + "):");
        jLabel.setFont(font);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        this.nodeField = this.makeField(this.nodes, this.nodeList, font);
        this.add((Component)this.nodeField, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.nodeList = this.makeList(this.nodeList, this.nodeField);
        JScrollPane jScrollPane = new JScrollPane(this.nodeList);
        jScrollPane.setBackground(Color.white);
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        JButton jButton = new JButton(this.nodeField.getAction());
        jButton.setToolTipText("Find node (or [ENTER] in text field)");
        jButton.setOpaque(false);
        this.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.makeSelectButton(this.nodeField, this.nodeList), gridBagConstraints);
        SelectingListener selectingListener = new SelectingListener(this.nodeField, this.nodes, this.nodeList);
        this.nodeField.getDocument().addDocumentListener(selectingListener);
        this.nodeField.getDocument().putProperty("SelectingListener", selectingListener);
    }

    private JTextField makeField(ListModel listModel, JList jList, Font font) {
        final JTextField jTextField = new JTextField(25);
        jTextField.setFont(font);
        jTextField.setFocusable(true);
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                super.focusGained(focusEvent);
                jTextField.setCaretPosition(0);
                jTextField.selectAll();
            }
        });
        jTextField.setAction(new FindAction(jTextField, jList, false));
        jTextField.setFocusTraversalKeysEnabled(false);
        jTextField.getInputMap().put(KeyStroke.getKeyStroke(9, 0), COMPLETE);
        jTextField.getActionMap().put(COMPLETE, new CompleteAction(jTextField, listModel));
        jTextField.getInputMap().put(KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), FIND_SELECT);
        jTextField.getActionMap().put(FIND_SELECT, new FindAction(jTextField, jList, true));
        return jTextField;
    }

    private JList<IOPNode> makeList(JList<IOPNode> jList, JTextField jTextField) {
        jList.setSelectionMode(0);
        jList.setVisibleRowCount(-1);
        jList.addMouseListener(new FindListener(jList, jTextField));
        return jList;
    }

    private JButton makeSelectButton(JTextField jTextField, JList jList) {
        JButton jButton = new JButton(new FindAction(jTextField, jList, true));
        jButton.setText("Click");
        jButton.setOpaque(false);
        jButton.setToolTipText("Find and click node\nto bring up context menu\n(or [CMD/CTRL-ENTER] in text field)\\");
        return jButton;
    }

    public void setNodes(List<IOPNode> list) {
        this.nodes.setData(list);
    }

    private void setTFText(JTextField jTextField, String string) {
        this.completionInProgress = false;
        SelectingListener selectingListener = (SelectingListener)jTextField.getDocument().getProperty("SelectingListener");
        jTextField.getDocument().removeDocumentListener(selectingListener);
        jTextField.setText(string);
        jTextField.getDocument().addDocumentListener(selectingListener);
    }

    public void focus(boolean bl) {
        this.nodeField.requestFocus();
    }

    public void wait4VisibleNFocus(boolean bl) {
        Visible2Focus visible2Focus = new Visible2Focus(this.nodeField);
        this.addComponentListener(visible2Focus);
    }

    class SelectingListener
    implements DocumentListener {
        private JTextField textField;
        private ListModel model;
        private JList list;

        public SelectingListener(JTextField jTextField, ListModel listModel, JList jList) {
            this.textField = jTextField;
            this.model = listModel;
            this.list = jList;
        }

        private void selectInList() {
            String string = this.textField.getText();
            int n = 0;
            if (TabFind.this.completionInProgress) {
                n = TabFind.this.lastIndex;
            }
            if ((n = this.model.indexOfName(string, true, n)) != -1) {
                this.list.setSelectionBackground(UIManager.getColor("List.selectionBackground"));
                this.list.setSelectionInterval(n, n);
                this.list.ensureIndexIsVisible(n);
            } else {
                n = this.model.indexOfCompletion(string, 0);
                if (n == -1) {
                    this.list.clearSelection();
                } else {
                    this.list.setSelectionBackground(Color.LIGHT_GRAY);
                    this.list.setSelectionInterval(n, n);
                    this.list.ensureIndexIsVisible(n);
                }
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.selectInList();
            if (!TabFind.this.completionInsert) {
                TabFind.this.completionInProgress = false;
            }
            TabFind.this.completionInsert = false;
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.selectInList();
            if (!TabFind.this.completionRemove) {
                TabFind.this.completionInProgress = false;
            }
            TabFind.this.completionRemove = false;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    class FindListener
    extends MouseAdapter {
        private JList list;
        private JTextField textField;

        public FindListener(JList jList, JTextField jTextField) {
            this.list = jList;
            this.textField = jTextField;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 0) {
                this.list.setSelectionBackground(UIManager.getColor("List.selectionBackground"));
                int n = this.list.locationToIndex(mouseEvent.getPoint());
                if (n != -1) {
                    this.list.setSelectionInterval(n, n);
                    this.list.ensureIndexIsVisible(n);
                    TabFind.this.setTFText(this.textField, this.list.getSelectedValue().toString());
                    if (mouseEvent.getClickCount() == 2) {
                        this.textField.getAction().actionPerformed(new ActionEvent(this.list, 1001, ""));
                    }
                }
            }
        }
    }

    class CompleteAction
    extends AbstractAction {
        private JTextField textField;
        private ListModel model;
        private String toBeCompleted = "";
        private int firstIndex;

        public CompleteAction(JTextField jTextField, ListModel listModel) {
            this.textField = jTextField;
            this.model = listModel;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            if (!TabFind.this.completionInProgress) {
                TabFind.this.completionInProgress = true;
                this.toBeCompleted = this.textField.getText();
                TabFind.this.lastIndex = this.model.indexOfCompletion(this.toBeCompleted, 0);
                this.firstIndex = TabFind.this.lastIndex;
                if (TabFind.this.lastIndex == -1) {
                    TabFind.this.completionInProgress = false;
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                string = this.model.getElementAt(TabFind.this.lastIndex).toString();
                if (this.textField.getText().equals(string)) {
                    ++this.firstIndex;
                    this.textField.dispatchEvent(new KeyEvent(this.textField, 401, 0L, 0, 9, '\uffff'));
                    return;
                }
            } else {
                TabFind.this.lastIndex = this.model.indexOfCompletion(this.toBeCompleted, TabFind.this.lastIndex + 1);
                if (TabFind.this.lastIndex == -1) {
                    TabFind.this.lastIndex = this.firstIndex - 1;
                    string = this.toBeCompleted;
                } else {
                    string = this.model.getElementAt(TabFind.this.lastIndex).toString();
                }
            }
            TabFind.this.completionInsert = true;
            TabFind.this.completionRemove = true;
            this.textField.setText(string);
        }
    }

    class FindAction
    extends AbstractAction {
        private JTextField textField;
        private JList list;
        private boolean select;

        public FindAction(JTextField jTextField, JList jList, boolean bl) {
            super("Find");
            this.textField = jTextField;
            this.list = jList;
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IOPNode iOPNode;
            Object e = this.list.getSelectedValue();
            if (e instanceof IOPNode && (iOPNode = (IOPNode)e).toString().equalsIgnoreCase(this.textField.getText())) {
                GraphPanel graphPanel;
                TabFind.this.setTFText(this.textField, iOPNode.toString());
                if (TabFind.this.owner != null && (graphPanel = TabFind.this.owner.getGraphPanel()) != null && graphPanel.getGraph() != null) {
                    graphPanel.removeLastSelection();
                    graphPanel.highlight(iOPNode);
                    graphPanel.centerOn(iOPNode.getBounds().getBounds());
                    if (this.select) {
                        graphPanel.displayMenu(iOPNode);
                    }
                }
                return;
            }
            Toolkit.getDefaultToolkit().beep();
        }
    }

    class Visible2Focus
    extends ComponentAdapter {
        JTextField textField;

        public Visible2Focus(JTextField jTextField) {
            this.textField = jTextField;
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            this.textField.requestFocus();
            TabFind.this.removeComponentListener(this);
        }
    }
}

