/*
 * Decompiled with CFR 0.152.
 */
package g2d.graphviewer;

import g2d.glyph.BufferedGlyphList;
import g2d.glyph.Glyphish;
import g2d.graph.GraphItem;
import g2d.graph.IOPGraph;
import g2d.graph.IOPNode;
import g2d.graphviewer.BaseFrame;
import g2d.swing.ZoomListener;
import g2d.swing.Zoomer;
import g2d.util.ActorMsg;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;

public class GraphPanel
extends JPanel
implements Zoomer,
ChangeListener,
MouseInputListener,
MouseWheelListener {
    protected IOPGraph graph = null;
    protected Dimension graphSize = new Dimension();
    protected Set<ZoomListener> zoomListeners = new HashSet<ZoomListener>();
    protected AffineTransform zoomTransform = new AffineTransform();
    protected GraphItem lastItem = null;
    protected Point lastPoint = null;

    public GraphPanel() {
        this.setBackground(Color.WHITE);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.checkSize();
    }

    public IOPGraph getGraph() {
        return this.graph;
    }

    public void resetGraph() {
        this.checkSize();
    }

    public void setGraph(IOPGraph iOPGraph) {
        if (this.graph != null) {
            this.graph.removeChangeListener(this);
        }
        this.graph = iOPGraph;
        if (this.graph != null) {
            this.graph.addChangeListener(this);
        }
        this.checkSize();
    }

    public Dimension getGraphSize() {
        return this.graphSize;
    }

    protected void checkSize() {
        if (this.graph != null) {
            this.graphSize = new Dimension((int)this.graph.getWidth(), (int)this.graph.getHeight());
            if (this.getZoomScale() != 1.0) {
                Shape shape = this.zoomTransform.createTransformedShape(new Rectangle(this.graphSize));
                this.graphSize = shape.getBounds().getSize();
            }
        } else {
            this.graphSize = new Dimension();
        }
        this.setPreferredSize(this.graphSize);
        this.revalidate();
    }

    public boolean isEmpty() {
        return this.graph == null || this.graph.length() == 0;
    }

    public void addZoomListener(ZoomListener zoomListener) {
        this.zoomListeners.add(zoomListener);
    }

    public void removeZoomListener(ZoomListener zoomListener) {
        this.zoomListeners.remove(zoomListener);
    }

    protected void notifyZoomListeners() {
        for (ZoomListener zoomListener : this.zoomListeners) {
            zoomListener.zoomChanged(this.getZoomScale());
        }
    }

    public double getZoomScale() {
        return this.zoomTransform.getScaleX();
    }

    protected AffineTransform getInverseZoom() {
        return AffineTransform.getScaleInstance(1.0 / this.getZoomScale(), 1.0 / this.getZoomScale());
    }

    @Override
    public void zoom(double d) {
        if (this.graph != null) {
            double d2 = this.zoomTransform.getScaleX() * d;
            if (d2 <= 0.001 || d2 >= 1000.0) {
                return;
            }
            this.zoomTransform.scale(d, d);
            if (this.getParent() instanceof JViewport) {
                JViewport jViewport = (JViewport)this.getParent();
                Point2D point2D = AffineTransform.getScaleInstance(d, d).transform(jViewport.getViewPosition(), null);
                jViewport.setViewPosition(new Point((int)point2D.getX(), (int)point2D.getY()));
            }
            this.checkSize();
            this.repaint();
            this.notifyZoomListeners();
        }
    }

    public void zoomToFit(Dimension dimension) {
        if (dimension == null) {
            return;
        }
        if (!new Dimension().equals(this.graphSize)) {
            double d = (double)dimension.width / (double)this.graphSize.width;
            double d2 = (double)dimension.height / (double)this.graphSize.height;
            this.zoom(d > d2 ? d2 : d);
        }
    }

    @Override
    public void zoomToFit() {
        Container container = this.getParent();
        if (container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            this.zoomToFit(jViewport.getExtentSize());
        }
    }

    @Override
    public void zoomToOriginal() {
        this.zoomTransform.setToIdentity();
        this.zoom(1.0);
    }

    public void centerOn(Rectangle rectangle) {
        if (rectangle == null) {
            return;
        }
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            Rectangle2D rectangle2D = rectangle.getBounds2D();
            if (this.getZoomScale() != 1.0) {
                rectangle2D = this.zoomTransform.createTransformedShape(rectangle).getBounds2D();
            }
            Dimension dimension = jViewport.getExtentSize();
            Point2D.Double double_ = new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY());
            Point2D.Double double_2 = new Point2D.Double(((Point2D)double_).getX() + dimension.getWidth() / 2.0, ((Point2D)double_).getY() + dimension.getHeight() / 2.0);
            rectangle2D.setFrameFromCenter(double_, double_2);
            if (!jViewport.getViewRect().contains(rectangle2D.getBounds())) {
                this.scrollRectToVisible(rectangle2D.getBounds());
                this.repaint();
            }
        }
    }

    public void centerOn(IOPNode iOPNode) {
        if (iOPNode == null) {
            return;
        }
        this.centerOn(iOPNode.getBounds().getBounds());
    }

    public void highlight(GraphItem graphItem) {
        this.lastItem = graphItem;
        if (this.lastItem != null) {
            this.lastItem.highlight();
            if (this.graph != null) {
                this.graph.fireChange();
            }
        }
    }

    public void displayMenu(IOPNode iOPNode) {
        this.displayContextMNode(this.getFrame(), iOPNode);
    }

    public BaseFrame getFrame() {
        Window window = SwingUtilities.getWindowAncestor(this);
        BaseFrame baseFrame = null;
        if (window instanceof BaseFrame) {
            baseFrame = (BaseFrame)window;
        }
        return baseFrame;
    }

    protected JButton makeCenterOnButton(String string, int n, GraphItem graphItem) {
        JButton jButton = this.createMenuButton(string, n);
        final GraphItem graphItem2 = graphItem;
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphPanel.this.centerOn(graphItem2.getBounds().getBounds());
            }
        });
        return jButton;
    }

    protected JButton makeG2MaudeButton(String string, int n, String string2, String string3) {
        JButton jButton = this.createMenuButton(string, n);
        final String string4 = string3;
        final String string5 = string2;
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GraphPanel.this.graph != null) {
                    ActorMsg.send("maude", string5, string4);
                }
            }
        });
        return jButton;
    }

    protected JButton makeDisplayButton(String string, int n, IOPNode iOPNode) {
        JButton jButton = this.createMenuButton(string, n);
        final IOPNode iOPNode2 = iOPNode;
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphPanel.this.displayInfo(iOPNode2);
            }
        });
        return jButton;
    }

    protected JButton createMenuButton(String string, int n) {
        JButton jButton = new JButton(string);
        jButton.setDisplayedMnemonicIndex(n);
        return jButton;
    }

    public void removeLastSelection() {
        BaseFrame baseFrame;
        if (this.lastItem != null) {
            this.lastItem.dehighlight();
        }
        this.lastItem = null;
        if (this.graph != null) {
            this.graph.fireChange();
        }
        if ((baseFrame = this.getFrame()) != null) {
            baseFrame.getSEPanel().clearMenu();
        }
    }

    public boolean isGlyphishVisible(Glyphish glyphish) {
        if (glyphish == null) {
            return false;
        }
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            Rectangle2D rectangle2D = glyphish.getBounds();
            if (this.getZoomScale() != 1.0) {
                rectangle2D = this.zoomTransform.createTransformedShape(rectangle2D).getBounds2D();
            }
            return jViewport.getViewRect().contains(rectangle2D);
        }
        return false;
    }

    public Point transformFromView(Point point) {
        if (this.getZoomScale() != 1.0) {
            Point2D point2D = this.getInverseZoom().transform(point, null);
            point.setLocation(point2D.getX(), point2D.getY());
        }
        return point;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.graph != null) {
            if (BufferedGlyphList.paintDebug) {
                System.err.println("GraphPanel.paintComponent: " + this.graph.paintCount);
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.getZoomScale() != 1.0) {
                graphics2D.transform(this.zoomTransform);
            }
            this.graph.paint(graphics2D);
        }
    }

    @Override
    public void repaint() {
        if (this.graph != null && BufferedGlyphList.paintDebug) {
            System.err.println("GraphPanel.repaint: " + this.graph.paintCount);
        }
        super.repaint(1000L);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.repaint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        double d = 0.2;
        this.zoom(Math.abs(1.0 + (double)mouseWheelEvent.getWheelRotation() * d));
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            this.removeLastSelection();
            if (this.graph != null && mouseEvent.getClickCount() > 0) {
                Point point = this.transformFromView(mouseEvent.getPoint());
                GraphItem graphItem = this.graph.getGraphItem(point, IOPGraph.hitDelta);
                this.highlight(graphItem);
                this.mouseClicked(mouseEvent, graphItem, point);
                if (graphItem != null && mouseEvent.getClickCount() < 2) {
                    graphItem.mouseClicked(mouseEvent);
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        this.lastPoint = this.graph != null && this.graph.getGraphItem(point, IOPGraph.hitDelta) == null ? point : null;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.lastPoint = null;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.lastPoint != null && this.graph != null && this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            Point point = mouseEvent.getPoint();
            if (point != null) {
                Point point2 = jViewport.getViewPosition();
                point2.x -= point.x - this.lastPoint.x;
                point2.y -= point.y - this.lastPoint.y;
                jViewport.setViewPosition(point2);
            }
            this.lastPoint = point;
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    protected void displayContextMNode(BaseFrame baseFrame, IOPNode iOPNode) {
    }

    protected void displayInfo(IOPNode iOPNode) {
        StringBuffer stringBuffer = new StringBuffer("Info:\n");
        String[] stringArray = iOPNode.getKeys();
        stringBuffer.append("  attributes: " + stringArray.length + "\n");
        for (String string : stringArray) {
            stringBuffer.append("    " + string + " = " + iOPNode.getAttribute(string) + "\n");
        }
        this.getFrame().getSEPanel().displayText("Node: " + iOPNode.toString(), stringBuffer.toString());
    }

    public void mouseClicked(MouseEvent mouseEvent, GraphItem graphItem, Point point) {
        if (mouseEvent.getClickCount() >= 2) {
            // empty if block
        }
    }
}

