/*
 * Decompiled with CFR 0.152.
 */
package g2d.graphviewer;

import g2d.graph.IOPGraph;
import g2d.graph.IOPNode;
import g2d.graphviewer.BaseFrame;
import g2d.graphviewer.FileMenu;
import g2d.graphviewer.GraphMenu;
import g2d.graphviewer.GraphPanel;
import g2d.graphviewer.NavPanel;
import g2d.graphviewer.ProgressDialog;
import g2d.graphviewer.SEPanel;
import g2d.graphviewer.TabFind;
import g2d.graphviewer.ToolBar;
import g2d.graphviewer.ZoomMenu;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractBaseFrame
extends JFrame
implements ChangeListener {
    public static final int NAV_WIDTH = 300;
    public static final int NAV_MAX_HEIGHT = 200;
    protected final boolean allowsSelections;
    protected static ProgressDialog progressDialog = new ProgressDialog();
    protected JMenu fileMenu;
    protected JMenu zoomMenu;
    protected JMenu graphMenu;
    protected JLabel subtitle = new JLabel(" ");
    protected ToolBar toolBar;
    protected JScrollPane scrollGraph;
    protected NavPanel navPanel;
    protected GraphPanel graphPanel = new GraphPanel();
    protected SEPanel sePanel = new SEPanel(this);
    protected String title = "";
    protected BufferedImage lastThumbnail = null;
    protected static Dimension initialSize = null;
    protected static final int FACTOR = 3;
    protected static final int PARENT_COLOR = 1;
    protected static final int OTHER_COLOR = 2;
    protected static final int BOTH_COLOR = 0;
    protected static final int LIGHT_COLOR = 2;
    protected static final int MEDIUM_COLOR = 1;
    protected static final int DARK_COLOR = 0;
    protected static Color[] FILL_COLORS = new Color[]{new Color(135, 135, 135), new Color(180, 180, 180), new Color(220, 220, 220), new Color(204, 76, 0), new Color(255, 99, 49), new Color(255, 192, 128), new Color(108, 154, 127), new Color(128, 182, 150), new Color(204, 232, 215), Color.black, new Color(166, 166, 166), new Color(230, 230, 230)};

    public AbstractBaseFrame(String string, JFrame jFrame, boolean bl) {
        super(string);
        this.title = string;
        this.allowsSelections = bl;
        initialSize = new Dimension(600, 600);
        this.createMenus();
        this.createPanels();
    }

    public boolean allowsSelections() {
        return this.allowsSelections;
    }

    protected JMenu createFileMenu() {
        return new FileMenu(this, this.graphPanel);
    }

    protected JMenu createGraphMenu() {
        return new GraphMenu(this, this.graphPanel, this.sePanel);
    }

    protected JMenu createZoomMenu() {
        return new ZoomMenu(this, this.graphPanel);
    }

    protected void createToolbar() {
        this.toolBar = new ToolBar(this, this.graphPanel);
    }

    protected void createMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.getFileMenu());
        super.setJMenuBar(jMenuBar);
    }

    protected void createPanels() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        this.createToolbar();
        jPanel.add((Component)this.toolBar, "First");
        this.scrollGraph = new JScrollPane(this.graphPanel);
        this.scrollGraph.setBackground(Color.white);
        this.scrollGraph.setPreferredSize(new Dimension(300, 500));
        this.scrollGraph.getViewport().setScrollMode(1);
        this.scrollGraph.getViewport().addChangeListener(this);
        this.subtitle.setBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2));
        this.subtitle.setVerticalAlignment(1);
        Dimension dimension = this.subtitle.getMinimumSize();
        this.subtitle.setMinimumSize(new Dimension(0, (int)((double)dimension.height * 1.3)));
        JSplitPane jSplitPane = new JSplitPane(0, false, this.subtitle, this.scrollGraph);
        jSplitPane.setOneTouchExpandable(false);
        jSplitPane.setDividerSize(10);
        jSplitPane.setResizeWeight(0.0);
        this.navPanel = new NavPanel(this.graphPanel, 300, 200);
        final JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this.navPanel, new GridBagConstraints());
        jPanel2.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                AbstractBaseFrame.this.navPanel.resizeThumb(jPanel2.getSize());
            }
        });
        JSplitPane jSplitPane2 = new JSplitPane(0, false, jPanel2, this.sePanel);
        jSplitPane2.setOneTouchExpandable(false);
        jSplitPane2.setDividerSize(10);
        jSplitPane2.setResizeWeight(0.0);
        JSplitPane jSplitPane3 = new JSplitPane(1, false, jSplitPane, jSplitPane2);
        jSplitPane3.setOneTouchExpandable(false);
        jSplitPane3.setDividerSize(10);
        jSplitPane3.setResizeWeight(1.0);
        jPanel.add((Component)jSplitPane3, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setContentPane(jPanel);
        this.pack();
        jSplitPane3.setDividerLocation(jSplitPane3.getSize().width - jSplitPane3.getInsets().right - jSplitPane3.getDividerSize() - 300);
    }

    public int getMenuCount() {
        JMenuBar jMenuBar = this.getJMenuBar();
        int n = jMenuBar.getMenuCount();
        this.setJMenuBar(jMenuBar);
        return n;
    }

    public void addMenuAt(JMenu jMenu, int n) {
        JMenuBar jMenuBar = this.getJMenuBar();
        JMenuBar jMenuBar2 = new JMenuBar();
        int n2 = jMenuBar.getMenuCount();
        if (jMenu == null) {
            throw new IllegalArgumentException("Cannot add NULL as a menu");
        }
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException("Cannot add menu at given position " + n);
        }
        for (int i = 0; i < n2; ++i) {
            if (n == i) {
                jMenuBar2.add(jMenu);
            }
            JMenu jMenu2 = jMenuBar.getMenu(0);
            jMenuBar2.add(jMenu2);
        }
        if (n == n2) {
            jMenuBar2.add(jMenu);
        }
        this.setJMenuBar(jMenuBar2);
    }

    @Override
    public void setTitle(String string) {
        IOPGraph iOPGraph;
        this.title = string == null ? "" : string;
        super.setTitle(string);
        if (this.graphPanel != null && (iOPGraph = this.graphPanel.getGraph()) != null) {
            super.setTitle(string + " (" + iOPGraph.getUID() + ")");
        }
    }

    public String getTitleWithoutID() {
        return this.title;
    }

    public void setSubtitle(String string) {
        if (string != null && string.indexOf(10) != -1) {
            String string2 = string.replaceAll("\n", "<br>");
            string2 = string2.replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
            string = "<html>" + string2 + "</html>";
        }
        this.subtitle.setText(string);
        this.subtitle.repaint();
    }

    public BaseFrame getTopBaseFrame() {
        AbstractBaseFrame abstractBaseFrame = this;
        return (BaseFrame)abstractBaseFrame;
    }

    public static Color[] getFILL_COLORS() {
        return FILL_COLORS;
    }

    public static void setFILL_COLORS(Color[] colorArray) {
        if (colorArray.length >= 12) {
            FILL_COLORS = colorArray;
        }
    }

    protected void focusOnTextField(boolean bl) {
        TabFind tabFind = this.sePanel.getTabFind();
        if (tabFind.isVisible()) {
            tabFind.focus(bl);
        } else {
            tabFind.wait4VisibleNFocus(bl);
            this.sePanel.setSelectedComponent(tabFind);
        }
    }

    public JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = this.createFileMenu();
        }
        return this.fileMenu;
    }

    public JMenu getZoomMenu() {
        if (this.zoomMenu == null) {
            this.zoomMenu = this.createZoomMenu();
        }
        return this.zoomMenu;
    }

    public JMenu getGraphMenu() {
        if (this.graphMenu == null) {
            this.graphMenu = this.createGraphMenu();
        }
        return this.graphMenu;
    }

    public ToolBar getToolBar() {
        return this.toolBar;
    }

    public GraphPanel getGraphPanel() {
        return this.graphPanel;
    }

    public SEPanel getSEPanel() {
        return this.sePanel;
    }

    public NavPanel getNavPanel() {
        return this.navPanel;
    }

    public void setGraph(IOPGraph iOPGraph) {
        if (iOPGraph != null) {
            iOPGraph.setAttribute("frame", this);
        }
        this.graphPanel.removeLastSelection();
        this.graphPanel.setGraph(iOPGraph);
        if (iOPGraph != null) {
            this.navPanel.setImage(iOPGraph.getBufferedImage());
        } else {
            this.navPanel.setImage(null);
        }
        this.setTitle(this.title);
        if (iOPGraph != null) {
            IOPNode[] iOPNodeArray = iOPGraph.getNodesInArray();
            this.sePanel.setNodes(iOPNodeArray);
        } else {
            this.sePanel.setNodes(null);
        }
        this.validate();
        this.stateChanged(new ChangeEvent(this.scrollGraph.getViewport()));
        this.repaint();
        AbstractBaseFrame.hideProgressDialog();
    }

    public boolean isEmpty() {
        return this.graphPanel.isEmpty();
    }

    public static void showProgressDialog(String string, Component component) {
        if (progressDialog != null) {
            progressDialog.setTitle(string);
            progressDialog.setLocationRelativeTo(component);
            progressDialog.setVisible(true);
        }
    }

    public static void hideProgressDialog() {
        if (progressDialog != null) {
            progressDialog.setVisible(false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() instanceof JViewport) {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            Dimension dimension = jViewport.getExtentSize();
            Dimension dimension2 = jViewport.getViewSize();
            if (dimension2.width <= dimension.width && dimension2.height <= dimension.height) {
                this.navPanel.setPorthole(null);
                return;
            }
            this.navPanel.setPorthole(jViewport.getViewRect());
        }
    }
}

