/*
 * Decompiled with CFR 0.152.
 */
package g2d.graph.xdotparser.visitor;

import g2d.glyph.Glyph;
import g2d.glyph.Glyphish;
import g2d.glyph.ImageGlyph;
import g2d.glyph.TextGlyph;
import g2d.graph.Dot;
import g2d.graph.IOPGraph;
import g2d.graph.Spline;
import g2d.graph.xdotparser.antlr4.xDotBaseVisitor;
import g2d.graph.xdotparser.antlr4.xDotLexer;
import g2d.graph.xdotparser.antlr4.xDotParser;
import g2d.util.IO;
import java.awt.Color;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.TerminalNode;

public class Visitor
extends xDotBaseVisitor<Object> {
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE = false;
    protected Glyph base;
    protected Point2D[] coordinates;
    protected Spline spline;
    protected ArrayList<Glyphish> glyphs;
    protected String style = null;
    protected Rectangle2D bounds;
    int graphHeight;
    Type type;
    IOPGraph graph;
    private Color fillColor = null;
    private Color penColor = null;
    private String fontName = null;
    private Integer fontSize = null;

    public Visitor(IOPGraph iOPGraph, Type type, int n) {
        this.type = type;
        this.graphHeight = n;
        this.graph = iOPGraph;
    }

    public Visitor(Type type, int n) {
        this.type = type;
        this.graphHeight = n;
    }

    @Override
    public ArrayList<Glyphish> visitAttributes(xDotParser.AttributesContext attributesContext) {
        ArrayList<Glyphish> arrayList = new ArrayList<Glyphish>();
        List<xDotParser.AttributeContext> list = attributesContext.attribute();
        for (xDotParser.AttributeContext attributeContext : list) {
            Object t = this.visit(attributeContext);
            if (!(t instanceof Glyphish)) continue;
            arrayList.add((Glyphish)t);
        }
        this.glyphs = arrayList;
        return arrayList;
    }

    @Override
    public ImageGlyph visitImage(xDotParser.ImageContext imageContext) {
        ImageGlyph imageGlyph = null;
        Point point = this.visitPoint(imageContext.point());
        int n = point.x;
        int n2 = this.graphHeight - point.y;
        int n3 = this.visitWidth(imageContext.width());
        int n4 = this.visitHeight(imageContext.height());
        String string = this.visitBytes(imageContext.bytes());
        URL uRL = null;
        if (this.graph != null && this.graph.images != null) {
            try {
                uRL = new URL(this.graph.images + string);
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println(malformedURLException);
            }
        }
        imageGlyph = uRL == null ? new ImageGlyph(string, n, n2 - n4, n3, n4) : new ImageGlyph(uRL, n, n2 - n4, n3, n4);
        return imageGlyph;
    }

    @Override
    public TextGlyph visitText(xDotParser.TextContext textContext) {
        Point point = this.visitPoint(textContext.point());
        int n = this.visitAlignment(textContext.alignment());
        int n2 = this.visitWidth(textContext.width());
        String string = this.visitBytes(textContext.bytes());
        Point2D.Double double_ = new Point2D.Double(point.x, this.graphHeight - point.y);
        TextGlyph textGlyph = new TextGlyph(string, this.fontSize - 2);
        textGlyph.alignToDotPoint(double_, n);
        return textGlyph;
    }

    private void updateBase(Glyph glyph) {
        this.base = glyph;
    }

    private Glyph visitEllipse(Point point, Point point2, Color color) {
        int n = point.x;
        int n2 = this.graphHeight - point.y;
        int n3 = point2.x;
        int n4 = point2.y;
        Ellipse2D.Double double_ = new Ellipse2D.Double(n - n3, n2 - n4, 2 * n3, 2 * n4);
        Glyph glyph = new Glyph(double_, this.penColor, color);
        this.updateBase(glyph);
        return glyph;
    }

    @Override
    public Glyph visitEllipseFilled(xDotParser.EllipseFilledContext ellipseFilledContext) {
        return this.visitEllipse(this.visitPoint(ellipseFilledContext.point(0)), this.visitPoint(ellipseFilledContext.point(1)), this.fillColor);
    }

    @Override
    public Glyph visitEllipseUnfilled(xDotParser.EllipseUnfilledContext ellipseUnfilledContext) {
        return this.visitEllipse(this.visitPoint(ellipseUnfilledContext.point(0)), this.visitPoint(ellipseUnfilledContext.point(1)), null);
    }

    private Glyph visitPolygon(Point[] pointArray, Color color) {
        int n = pointArray.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            Point point = pointArray[i];
            nArray[i] = point.x;
            nArray2[i] = this.graphHeight - point.y;
        }
        GeneralPath generalPath = new GeneralPath(0, n);
        generalPath.moveTo(nArray[0], nArray2[0]);
        for (int i = 1; i < n; ++i) {
            generalPath.lineTo(nArray[i], nArray2[i]);
        }
        generalPath.closePath();
        Glyph glyph = new Glyph(generalPath, this.penColor, color);
        this.updateBase(glyph);
        return glyph;
    }

    @Override
    public Glyph visitPolygonFilled(xDotParser.PolygonFilledContext polygonFilledContext) {
        return this.visitPolygon(this.visitPoints(polygonFilledContext.points()), this.fillColor);
    }

    @Override
    public Glyph visitPolygonUnfilled(xDotParser.PolygonUnfilledContext polygonUnfilledContext) {
        return this.visitPolygon(this.visitPoints(polygonUnfilledContext.points()), null);
    }

    public Glyph visitBezel(Point[] pointArray, Color color) {
        int n;
        Cloneable cloneable;
        int n2;
        int n3 = pointArray.length;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            cloneable = pointArray[n2];
            nArray[n2] = ((Point)cloneable).x;
            nArray2[n2] = this.graphHeight - ((Point)cloneable).y;
        }
        n2 = nArray[0] == nArray[n3 - 1] && nArray2[0] == nArray2[n3 - 1] ? 1 : 0;
        cloneable = new GeneralPath();
        ((Path2D.Float)cloneable).moveTo(nArray[0], nArray2[0]);
        if (n2 == 0) {
            this.bounds = new Rectangle2D.Double(nArray[0], nArray2[0], 0.0, 0.0);
            for (n = 1; n < n3; ++n) {
                this.bounds.add(pointArray[n]);
            }
        }
        for (n = 1; n < n3; n += 3) {
            ((Path2D.Float)cloneable).curveTo(nArray[n], nArray2[n], nArray[n + 1], nArray2[n + 1], nArray[n + 2], nArray2[n + 2]);
        }
        Glyph glyph = new Glyph((Shape)((Object)cloneable), this.penColor, color);
        if (n2 != 0) {
            this.updateBase(glyph);
        }
        return glyph;
    }

    private Point2D[] points2Points2D(Point[] pointArray) {
        Point2D[] point2DArray = null;
        if (pointArray != null) {
            point2DArray = new Point2D[pointArray.length];
            for (int i = 0; i < pointArray.length; ++i) {
                Point point = pointArray[i];
                point2DArray[i] = new Point2D.Double(point.x, this.graphHeight - point.y);
            }
        }
        return point2DArray;
    }

    private Spline coords2Spline(Point2D[] point2DArray) {
        Spline spline = null;
        if (point2DArray != null && point2DArray.length > 1) {
            spline = new Spline(point2DArray[0], point2DArray[point2DArray.length - 1]);
            spline.setCoordinates(point2DArray);
        }
        return spline;
    }

    @Override
    public Glyphish visitBezelUnfilled(xDotParser.BezelUnfilledContext bezelUnfilledContext) {
        Glyphish glyphish = null;
        Point[] pointArray = this.visitPoints(bezelUnfilledContext.points());
        if (this.type == Type.EDGE) {
            this.coordinates = this.points2Points2D(pointArray);
            this.spline = this.coords2Spline(this.coordinates);
            this.spline.setStyle(this.style);
            this.spline.setColor(this.penColor);
            glyphish = this.spline;
        } else {
            glyphish = this.visitBezel(pointArray, null);
        }
        return glyphish;
    }

    @Override
    public Glyph visitBezelFilled(xDotParser.BezelFilledContext bezelFilledContext) {
        return this.visitBezel(this.visitPoints(bezelFilledContext.points()), this.fillColor);
    }

    @Override
    public Glyph visitPolyline(xDotParser.PolylineContext polylineContext) {
        int n;
        Point[] pointArray = this.visitPoints(polylineContext.points());
        int n2 = pointArray.length;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            Point point = pointArray[i];
            nArray[i] = point.x;
            nArray2[i] = this.graphHeight - point.y;
        }
        GeneralPath generalPath = new GeneralPath(0, n2);
        generalPath.moveTo(nArray[0], nArray2[0]);
        if (this.bounds == null) {
            this.bounds = new Rectangle2D.Double(nArray[0], nArray2[0], 0.0, 0.0);
        } else {
            this.bounds.add(pointArray[0]);
        }
        for (n = 1; n < n2; ++n) {
            this.bounds.add(pointArray[n]);
        }
        for (n = 1; n < n2; ++n) {
            generalPath.lineTo(nArray[n], nArray2[n]);
        }
        Glyph glyph = new Glyph(generalPath, this.penColor, null);
        return glyph;
    }

    @Override
    public String visitBytes(xDotParser.BytesContext bytesContext) {
        String string = this.visitCharSequence(bytesContext.charSequence());
        return string;
    }

    @Override
    public Integer visitAlignment(xDotParser.AlignmentContext alignmentContext) {
        Integer n = this.visitInteger(alignmentContext.integer());
        return n;
    }

    @Override
    public Point[] visitPointSequence(xDotParser.PointSequenceContext pointSequenceContext) {
        Point[] pointArray = new Point[pointSequenceContext.m];
        for (int i = 0; i < pointSequenceContext.m; ++i) {
            pointArray[i] = this.visitPoint(pointSequenceContext.point(i));
        }
        return pointArray;
    }

    @Override
    public Color visitFillColor(xDotParser.FillColorContext fillColorContext) {
        Color color;
        String string = this.visitBytes(fillColorContext.bytes());
        this.fillColor = color = Dot.rgba2Color(string);
        return color;
    }

    @Override
    public Color visitPenColor(xDotParser.PenColorContext penColorContext) {
        Color color;
        String string = this.visitBytes(penColorContext.bytes());
        this.penColor = color = Dot.rgba2Color(string);
        return color;
    }

    @Override
    public String visitFont(xDotParser.FontContext fontContext) {
        String string;
        Integer n = this.visitFontsize(fontContext.fontsize());
        this.fontName = string = this.visitBytes(fontContext.bytes());
        this.fontSize = n;
        return string + "_" + n;
    }

    @Override
    public Integer visitWidth(xDotParser.WidthContext widthContext) {
        Integer n = this.visitNumber(widthContext.number());
        return n;
    }

    @Override
    public Integer visitHeight(xDotParser.HeightContext heightContext) {
        Integer n = this.visitNumber(heightContext.number());
        return n;
    }

    @Override
    public String visitCharSequence(xDotParser.CharSequenceContext charSequenceContext) {
        List<xDotParser.CharElementContext> list = charSequenceContext.charElement();
        StringBuffer stringBuffer = new StringBuffer();
        for (xDotParser.CharElementContext charElementContext : list) {
            stringBuffer.append(this.visitCharElement(charElementContext));
        }
        return stringBuffer.toString();
    }

    @Override
    public String visitCharElement(xDotParser.CharElementContext charElementContext) {
        TerminalNode terminalNode = null;
        terminalNode = charElementContext.CHARACTER();
        if (terminalNode != null) {
            return terminalNode.toString();
        }
        terminalNode = charElementContext.DIGIT();
        if (terminalNode != null) {
            return terminalNode.toString();
        }
        terminalNode = charElementContext.SYMBOL();
        if (terminalNode != null) {
            return terminalNode.toString();
        }
        terminalNode = charElementContext.SPACE();
        if (terminalNode != null) {
            return terminalNode.toString();
        }
        terminalNode = charElementContext.DOT();
        if (terminalNode != null) {
            return terminalNode.toString();
        }
        terminalNode = charElementContext.DASH();
        if (terminalNode != null) {
            return terminalNode.toString();
        }
        terminalNode = charElementContext.KUE();
        if (terminalNode != null) {
            return terminalNode.toString();
        }
        terminalNode = charElementContext.KLE();
        if (terminalNode != null) {
            return terminalNode.toString();
        }
        terminalNode = charElementContext.KUB();
        if (terminalNode != null) {
            return terminalNode.toString();
        }
        terminalNode = charElementContext.KLB();
        if (terminalNode != null) {
            return terminalNode.toString();
        }
        terminalNode = charElementContext.KUC();
        if (terminalNode != null) {
            return terminalNode.toString();
        }
        terminalNode = charElementContext.KLC();
        if (terminalNode != null) {
            return terminalNode.toString();
        }
        terminalNode = charElementContext.KUF();
        if (terminalNode != null) {
            return terminalNode.toString();
        }
        terminalNode = charElementContext.KUI();
        if (terminalNode != null) {
            return terminalNode.toString();
        }
        terminalNode = charElementContext.KUL();
        if (terminalNode != null) {
            return terminalNode.toString();
        }
        terminalNode = charElementContext.KUP();
        if (terminalNode != null) {
            return terminalNode.toString();
        }
        terminalNode = charElementContext.KLP();
        if (terminalNode != null) {
            return terminalNode.toString();
        }
        terminalNode = charElementContext.KUT();
        if (terminalNode != null) {
            return terminalNode.toString();
        }
        terminalNode = charElementContext.KLT();
        if (terminalNode != null) {
            return terminalNode.toString();
        }
        terminalNode = charElementContext.KUS();
        if (terminalNode != null) {
            return terminalNode.toString();
        }
        return "?";
    }

    @Override
    public String visitStyle(xDotParser.StyleContext styleContext) {
        String string;
        this.style = string = this.visitBytes(styleContext.bytes());
        return string;
    }

    @Override
    public Point[] visitPoints(xDotParser.PointsContext pointsContext) {
        Point[] pointArray = this.visitPointSequence(pointsContext.pointSequence());
        return pointArray;
    }

    @Override
    public Point visitPoint(xDotParser.PointContext pointContext) {
        Integer n = this.visitNumber(pointContext.number(0));
        Integer n2 = this.visitNumber(pointContext.number(1));
        Point point = new Point(n, n2);
        return point;
    }

    @Override
    public Integer visitFontsize(xDotParser.FontsizeContext fontsizeContext) {
        return this.visitNumber(fontsizeContext.number());
    }

    @Override
    public Integer visitInteger(xDotParser.IntegerContext integerContext) {
        Integer n = integerContext.v;
        return n;
    }

    @Override
    public Integer visitNumber(xDotParser.NumberContext numberContext) {
        Integer n = this.visitInteger(numberContext.integer(0));
        if (numberContext.DOT() != null) {
            Integer n2 = this.visitInteger(numberContext.integer(1));
        }
        return n;
    }

    public static xDotParser parseString(String string) {
        xDotParser xDotParser2 = null;
        if (string != null) {
            try {
                CodePointCharStream codePointCharStream = CharStreams.fromString(string);
                xDotLexer xDotLexer2 = new xDotLexer(codePointCharStream);
                CommonTokenStream commonTokenStream = new CommonTokenStream(xDotLexer2);
                xDotParser2 = new xDotParser(commonTokenStream);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        return xDotParser2;
    }

    public static void testFromString(String string) {
        xDotParser xDotParser2 = Visitor.parseString(string);
        Visitor.test(xDotParser2);
    }

    public static void testFromFile(String string) {
        String string2 = IO.file2String(string);
        Visitor.testFromString(string2);
    }

    public static void test(xDotParser xDotParser2) {
        Visitor visitor = null;
        if (xDotParser2 != null) {
            xDotParser.AttributesContext attributesContext = xDotParser2.attributes();
            visitor = new Visitor(Type.NODE, 0);
            visitor.visit(attributesContext);
        }
    }

    public static void main(String[] stringArray) {
        Visitor.testFromFile(stringArray[0]);
    }

    public static enum Type {
        NODE,
        EDGE,
        SUBGRAPH;

    }
}

