/*
 * Decompiled with CFR 0.152.
 */
package g2d.graph.dotparser.visitor;

import g2d.glyph.Glyphish;
import g2d.graph.DotParserUtils;
import g2d.graph.IOPEdge;
import g2d.graph.IOPGraph;
import g2d.graph.IOPNode;
import g2d.graph.IOPSubgraph;
import g2d.graph.Manifold;
import g2d.graph.dotparser.antlr4.DotBaseVisitor;
import g2d.graph.dotparser.antlr4.DotLexer;
import g2d.graph.dotparser.antlr4.DotParser;
import g2d.swing.IOPFrame;
import g2d.swing.IOPView;
import g2d.util.IO;
import java.awt.Dimension;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class Visitor
extends DotBaseVisitor<Object> {
    public static final boolean DEBUG = false;
    public final IOPGraph graph;
    public final boolean isNew;
    private IOPSubgraph currentSubgraph = null;
    private HashMap<String, Attributes> subGraphAttributes = new HashMap();
    private Attributes globalNodeAttributes;
    private Attributes globalEdgeAttributes;
    private Attributes globalGraphAttributes;

    public static DotParser parseString(String string) {
        DotParser dotParser = null;
        if (string != null) {
            try {
                CodePointCharStream codePointCharStream = CharStreams.fromString(string);
                DotLexer dotLexer = new DotLexer(codePointCharStream);
                CommonTokenStream commonTokenStream = new CommonTokenStream(dotLexer);
                dotParser = new DotParser(commonTokenStream);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        return dotParser;
    }

    public static DotParser parseFile(String string) {
        DotParser dotParser = null;
        if (string != null) {
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                CharStream charStream = CharStreams.fromStream(fileInputStream);
                DotLexer dotLexer = new DotLexer(charStream);
                CommonTokenStream commonTokenStream = new CommonTokenStream(dotLexer);
                dotParser = new DotParser(commonTokenStream);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        return dotParser;
    }

    public Visitor(IOPGraph iOPGraph) {
        if (iOPGraph != null) {
            this.graph = iOPGraph;
            this.isNew = false;
        } else {
            this.graph = new IOPGraph();
            this.isNew = true;
        }
    }

    private void setGlobalGraphAttributes(Attributes attributes) {
        if (this.currentSubgraph == null) {
            String string = (String)attributes.get("bb");
            if (string != null && !string.equals("\"\"")) {
                Dimension dimension = DotParserUtils.parseBoundingBoxAttribute(string);
                this.graph.setWidth(dimension.getWidth());
                this.graph.setHeight(dimension.getHeight());
                if (this.graph.size() > Manifold.THRESHOLD) {
                    this.graph.createManifold();
                }
            }
            if (this.globalGraphAttributes == null) {
                this.globalGraphAttributes = attributes;
            } else {
                this.globalGraphAttributes.putAll(attributes);
            }
        } else {
            Attributes attributes2 = this.subGraphAttributes.get(this.currentSubgraph.name);
            if (attributes2 != null) {
                attributes2.putAll(attributes);
            } else {
                System.err.println("This graph is crazy. No comprendo esta graph.");
            }
        }
    }

    private void setGlobalNodeAttributes(Attributes attributes) {
        if (this.globalNodeAttributes == null) {
            this.globalNodeAttributes = attributes;
        } else {
            this.globalNodeAttributes.putAll(attributes);
        }
    }

    private void setGlobalEdgeAttributes(Attributes attributes) {
        if (this.globalEdgeAttributes == null) {
            this.globalEdgeAttributes = attributes;
        } else {
            this.globalEdgeAttributes.putAll(attributes);
        }
    }

    @Override
    public Object visitGraph(DotParser.GraphContext graphContext) {
        Object t = super.visitChildren(graphContext);
        return t;
    }

    @Override
    public Object visitSubgraph(DotParser.SubgraphContext subgraphContext) {
        Object t;
        IOPSubgraph iOPSubgraph;
        String string = subgraphContext.id() != null ? subgraphContext.id().getText() : null;
        IOPSubgraph iOPSubgraph2 = this.currentSubgraph;
        IOPSubgraph iOPSubgraph3 = this.isNew ? new IOPSubgraph(string, iOPSubgraph2 == null) : (iOPSubgraph = this.graph.getSubgraph(string));
        if (iOPSubgraph == null) {
            t = this.visitChildren(subgraphContext);
        } else {
            if (string == null) {
                string = iOPSubgraph.name;
            }
            Attributes attributes = new Attributes();
            this.subGraphAttributes.put(string, attributes);
            this.currentSubgraph = iOPSubgraph;
            t = this.visitChildren(subgraphContext);
            this.currentSubgraph = iOPSubgraph2;
            double d = this.graph.getHeight();
            if (string != null) {
                DotParserUtils.parseSubgraphAttributes(iOPSubgraph, string, attributes, d);
                if (this.isNew) {
                    this.graph.addSubgraph(iOPSubgraph);
                    if (iOPSubgraph2 != null) {
                        iOPSubgraph2.addSubgraph(iOPSubgraph);
                    }
                }
            } else {
                System.err.println("Skipping subgraph with null id: name is " + iOPSubgraph.name);
            }
        }
        return t;
    }

    @Override
    public Object visitAttr_stmt(DotParser.Attr_stmtContext attr_stmtContext) {
        Attributes attributes = (Attributes)this.visit(attr_stmtContext.attr_list());
        if (attr_stmtContext.GRAPH() != null) {
            this.setGlobalGraphAttributes(attributes);
        } else if (attr_stmtContext.NODE() != null) {
            this.setGlobalNodeAttributes(attributes);
        } else if (attr_stmtContext.EDGE() != null) {
            this.setGlobalEdgeAttributes(attributes);
        }
        return attributes;
    }

    @Override
    public Object visitEdge_stmt(DotParser.Edge_stmtContext edge_stmtContext) {
        IOPEdge iOPEdge;
        Object t = super.visitChildren(edge_stmtContext);
        String string = "?";
        if (edge_stmtContext.subgraph() != null) {
            string = "subgraph";
        } else if (edge_stmtContext.node_id() != null) {
            string = "node_id";
        }
        EdgeRHS edgeRHS = (EdgeRHS)this.visit(edge_stmtContext.edgeRHS());
        String string2 = edge_stmtContext.node_id().id().getText();
        String string3 = edgeRHS.node;
        DotParser.Attr_listContext attr_listContext = edge_stmtContext.attr_list();
        Attributes attributes = new Attributes();
        if (attr_listContext != null) {
            attributes = (Attributes)this.visit(edge_stmtContext.attr_list());
        }
        IOPNode iOPNode = this.graph.getNode(string2);
        IOPNode iOPNode2 = this.graph.getNode(string3);
        if (iOPNode == null || iOPNode2 == null) {
            System.err.println("Skipping edge whose nodes are missing: ");
            System.err.println("source: " + string2 + " = " + iOPNode);
            System.err.println("target: " + string3 + " = " + iOPNode2);
            return t;
        }
        if (this.isNew) {
            iOPEdge = new IOPEdge(iOPNode, iOPNode2);
            this.graph.addEdge(iOPEdge);
            if (this.currentSubgraph != null) {
                this.currentSubgraph.addEdge(iOPEdge);
            }
        } else {
            String string4 = (String)attributes.get("id");
            if (string4 != null) {
                Integer n = Integer.parseInt(string4);
                iOPEdge = (IOPEdge)this.graph.getGraphItemByGid(n);
            } else {
                System.err.println("Edge: " + string + " " + string2 + " " + edgeRHS + " has null id. isNew = " + this.isNew);
                return t;
            }
        }
        double d = this.graph.getHeight();
        boolean bl = DotParserUtils.parseEdgeAttributes(iOPEdge, attributes, d);
        this.graph.add2Manifold(iOPEdge);
        return t;
    }

    @Override
    public Object visitEdgeRHS(DotParser.EdgeRHSContext edgeRHSContext) {
        List<DotParser.SubgraphContext> list = edgeRHSContext.subgraph();
        List<DotParser.EdgeopContext> list2 = edgeRHSContext.edgeop();
        List<DotParser.Node_idContext> list3 = edgeRHSContext.node_id();
        if (list3.size() != 1 && list2.size() != 1) {
            System.err.println("EdgeRHS:");
            System.err.println("\tsubgraphs = " + list.size());
            System.err.println("\tnodes = " + list3.size());
            System.err.println("\tedgeops = " + list2.size());
        } else if (list2.get(0).ARROW() != null) {
            return new EdgeRHS("->", list3.get(0).id().getText());
        }
        return null;
    }

    @Override
    public Object visitEdgeop(DotParser.EdgeopContext edgeopContext) {
        return this.visitChildren(edgeopContext);
    }

    @Override
    public Object visitNode_stmt(DotParser.Node_stmtContext node_stmtContext) {
        String string = node_stmtContext.node_id().getText();
        try {
            Attributes attributes = null;
            DotParser.Attr_listContext attr_listContext = node_stmtContext.attr_list();
            if (attr_listContext == null) {
                return string;
            }
            attributes = (Attributes)this.visit(attr_listContext);
            double d = this.graph.getHeight();
            IOPNode iOPNode = null;
            if (this.isNew) {
                iOPNode = DotParserUtils.parseNodeAttributes(this.graph, null, string, attributes, d, this.globalNodeAttributes);
                this.graph.addNode(iOPNode);
                if (this.currentSubgraph != null) {
                    this.currentSubgraph.addNode(iOPNode);
                }
            } else {
                iOPNode = DotParserUtils.parseNodeAttributes(this.graph, this.graph.getNode(string), string, attributes, d, this.globalNodeAttributes);
            }
            this.graph.add2Manifold(iOPNode);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
        }
        return string;
    }

    @Override
    public Object visitAttr_list(DotParser.Attr_listContext attr_listContext) {
        List<DotParser.A_listContext> list = attr_listContext.a_list();
        Attributes attributes = null;
        for (DotParser.A_listContext a_listContext : list) {
            Attributes attributes2 = (Attributes)this.visit(a_listContext);
            if (attributes == null) {
                attributes = attributes2;
                continue;
            }
            attributes.putAll(attributes2);
        }
        return attributes;
    }

    @Override
    public Object visitA_list(DotParser.A_listContext a_listContext) {
        List<DotParser.IdContext> list = a_listContext.id();
        Attributes attributes = new Attributes();
        for (int i = 0; i < list.size(); i += 2) {
            String string = this.value(list.get(i));
            String string2 = this.value(list.get(i + 1));
            attributes.put(string, string2);
        }
        return attributes;
    }

    private String value(DotParser.IdContext idContext) {
        TerminalNode terminalNode = null;
        terminalNode = idContext.ID();
        if (terminalNode != null) {
            return terminalNode.toString();
        }
        terminalNode = idContext.STRING();
        if (terminalNode != null) {
            String string = terminalNode.toString();
            return string.replaceAll("\\\\\n", "");
        }
        terminalNode = idContext.NUMBER();
        if (terminalNode != null) {
            return terminalNode.toString();
        }
        terminalNode = idContext.HTML_STRING();
        if (terminalNode != null) {
            return terminalNode.toString();
        }
        return null;
    }

    private static void testFromFile(String string) {
        DotParser dotParser = Visitor.parseFile(string);
        Visitor.test(dotParser);
    }

    private static void testFromString(String string) {
        DotParser dotParser = Visitor.parseString(string);
        Visitor.test(dotParser);
    }

    private static void test(DotParser dotParser) {
        Object object;
        Visitor visitor = null;
        if (dotParser != null) {
            object = dotParser.graph();
            visitor = new Visitor(null);
            visitor.visit((ParseTree)object);
        }
        object = visitor.graph;
        IOPView iOPView = new IOPView(true, true);
        IOPFrame iOPFrame = new IOPFrame("Layout by dot, Parsing by Antl4", iOPView);
        iOPView.add((Glyphish)object);
        iOPFrame.setVisible(true);
        iOPView.repaint();
    }

    public static void main(String[] stringArray) {
        String string = IO.file2String(stringArray[0]);
        Visitor.testFromString(string);
    }

    public static class EdgeRHS {
        public final String node;
        public final String op;

        public EdgeRHS(String string, String string2) {
            this.node = string2;
            this.op = string;
        }

        public String toString() {
            return this.op + " " + this.node;
        }
    }

    public static class Attributes
    extends HashMap<String, String> {
    }
}

