/*
 * Decompiled with CFR 0.152.
 */
package g2d.graph;

import g2d.graph.IOPGraph;
import g2d.graph.Json2Dot;
import java.io.File;
import org.json.simple.JSONObject;

public class Json2Graph {
    public static boolean debug = false;

    public static IOPGraph make(String string) {
        JSONObject jSONObject = Json2Dot.file2JObj(string);
        if (jSONObject != null) {
            return Json2Graph.make(jSONObject);
        }
        return null;
    }

    public static IOPGraph make(JSONObject jSONObject) {
        try {
            File file = File.createTempFile("Json2Graph", ".dot");
            if (!debug) {
                file.deleteOnExit();
            } else {
                System.err.format("Json2Graph.make: dot file %s  is not being deleted on exit!\n", file);
            }
            if (jSONObject != null) {
                return Json2Graph.make(jSONObject, file);
            }
        }
        catch (Exception exception) {
            System.err.format("Json2Graph.make: exception msg was %s  from %s\n", exception.getMessage(), exception);
            exception.printStackTrace(System.err);
        }
        return null;
    }

    private static IOPGraph make(JSONObject jSONObject, File file) {
        boolean bl = Json2Dot.translate(jSONObject, file);
        if (bl) {
            IOPGraph iOPGraph = new IOPGraph();
            iOPGraph.setGraph(file);
            return iOPGraph;
        }
        return null;
    }
}

