/*
 * Decompiled with CFR 0.152.
 */
package g2d.graph;

import g2d.glyph.Glyph;
import g2d.graph.Diamond;
import g2d.graph.Dot;
import g2d.graph.DotAttributes;
import g2d.graph.DotNodeAttributes;
import g2d.graph.GraphItem;
import g2d.graph.Hexagon;
import g2d.graph.IOPGraph;
import g2d.graph.Seed;
import g2d.graph.Triangle;
import g2d.graph.xdotparser.visitor.xDotNode;
import g2d.jlambda.Attributable;
import g2d.jlambda.Closure;
import g2d.swing.IOPConstants;
import g2d.util.Orderings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Comparator;

public class IOPNode
extends GraphItem
implements Comparable<IOPNode> {
    public final NodeType type;
    public final String id;
    public final String longName;
    public final String shortName;
    public static int PERIPHERIES_DEFAULT = 1;
    protected int peripheries = PERIPHERIES_DEFAULT;
    private Glyph base = new Glyph(new Ellipse2D.Double(0.0, 0.0, 50.0, 30.0), IOPConstants.NODE_BORDER_COLOR, IOPConstants.NODE_FILL_COLOR);
    private String shape = "ellipse";
    private volatile boolean stale = true;
    private String displayLabel = "";
    public xDotNode dotRendering;
    public DotNodeAttributes dotNodeAttributes;
    Color borderColor = IOPConstants.NODE_BORDER_COLOR;
    Color fillColor = IOPConstants.NODE_FILL_COLOR;
    protected Seed seed = null;
    public static Comparator<IOPNode> COMPARATOR = new Comparator<IOPNode>(){

        @Override
        public int compare(IOPNode iOPNode, IOPNode iOPNode2) {
            return IOPNode.compareNodes(iOPNode, iOPNode2);
        }
    };
    public static Comparator<IOPNode> RULE_COMPARATOR = new Comparator<IOPNode>(){

        @Override
        public int compare(IOPNode iOPNode, IOPNode iOPNode2) {
            return IOPNode.compareToAsRule(iOPNode, iOPNode2);
        }
    };
    public static Comparator<IOPNode> OCC_COMPARATOR = new Comparator<IOPNode>(){

        @Override
        public int compare(IOPNode iOPNode, IOPNode iOPNode2) {
            return IOPNode.compareToAsOcc(iOPNode, iOPNode2);
        }
    };

    public IOPNode(NodeType nodeType, String string, String string2, String string3) {
        this.id = string == null ? this.gid.toString() : string;
        this.longName = string3;
        this.shortName = string2;
        this.type = nodeType;
    }

    public IOPNode(String string) {
        this(NodeType.NONE, string, string, string);
        this.setGuts(null, null, null, null, PERIPHERIES_DEFAULT, false);
    }

    public IOPNode(NodeType nodeType, String string) {
        this(nodeType, string, string, string);
        this.setGuts(null, null, null, null, PERIPHERIES_DEFAULT, false);
    }

    public IOPNode(String string, String string2, DotNodeAttributes dotNodeAttributes) {
        this(NodeType.NONE, string, string2, string2, dotNodeAttributes);
    }

    public IOPNode(String string, DotNodeAttributes dotNodeAttributes) {
        this(NodeType.NONE, null, string, string, dotNodeAttributes);
    }

    public IOPNode(NodeType nodeType, String string, String string2, String string3, DotNodeAttributes dotNodeAttributes) {
        this(nodeType, string, string2, string3);
        this.dotNodeAttributes = dotNodeAttributes;
        this.setGuts((String)dotNodeAttributes.getDotAttribute(DotAttributes.LABEL), (String)dotNodeAttributes.getDotAttribute(DotAttributes.SHAPE), (Color)dotNodeAttributes.getDotAttribute(DotAttributes.COLOR), (Color)dotNodeAttributes.getDotAttribute(DotAttributes.FILLCOLOR), (Integer)dotNodeAttributes.getDotAttribute(DotAttributes.PERIPHERIES), true);
    }

    public IOPNode(NodeType nodeType, String string, String string2, String string3, String string4, String string5, Color color, Color color2, int n) {
        this(nodeType, string, string2, string3);
        this.setGuts(string4, string5, color, color2, n, false);
    }

    public IOPNode(String string, int n) {
        this(NodeType.NONE, string, string, string);
        this.setGuts(null, null, null, null, n, false);
    }

    public IOPNode(String string, String string2) {
        this(NodeType.NONE, string, string, string);
        this.setGuts(null, string2, null, null, PERIPHERIES_DEFAULT, false);
    }

    public IOPNode(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Id of IOPNode cannot be NULL.");
        }
        this.id = string;
        this.longName = string;
        this.shortName = string;
        this.type = NodeType.NONE;
        this.setGuts(null, null, null, null, PERIPHERIES_DEFAULT, bl);
    }

    public IOPNode(String string, String string2, String string3, Color color, Color color2) {
        this(NodeType.NONE, string, string, string);
        this.setGuts(string2, string3, color, color2, PERIPHERIES_DEFAULT, false);
    }

    public IOPNode(String string, String string2, String string3, Color color, Color color2, boolean bl) {
        this(NodeType.NONE, string, string, string);
        this.setGuts(string2, string3, color, color2, PERIPHERIES_DEFAULT, bl);
    }

    public IOPNode(String string, String string2, String string3, Color color, Color color2, int n, boolean bl) {
        this(NodeType.NONE, string, string, string);
        this.setGuts(string2, string3, color, color2, n, bl);
    }

    public IOPNode(String string, String string2, String string3, Color color, Color color2, int n) {
        this(NodeType.NONE, string, string, string);
        this.setGuts(string2, string3, color, color2, n, false);
    }

    private void setGuts(String string, String string2, Color color, Color color2, int n, boolean bl) {
        this.peripheries = n;
        if (this.dotNodeAttributes == null) {
            this.dotNodeAttributes = new DotNodeAttributes(string, string2, color, color2, n);
        }
        if (string != null) {
            this.setLabel(string);
        }
        if (string2 != null) {
            this.setNodeShape(string2);
        }
        if (!bl) {
            this.updateGlyphList();
        }
        if (color != null) {
            this.setBorderColor(color);
        }
        if (color2 != null) {
            this.setFillColor(color2);
        }
    }

    private void updateGlyphList() {
        if (this.dotRendering != null) {
            this.glyphList = this.dotRendering.glyphList;
            this.base = this.dotRendering.base;
        }
    }

    protected void setRendering(xDotNode xDotNode2) {
        if (xDotNode2 != null) {
            this.dotRendering = xDotNode2;
            this.setNodeShape(this.dotRendering);
            this.updateGlyphList();
        }
    }

    public void setDotLayout(IOPGraph iOPGraph, Point2D point2D, double d, double d2, String string, String string2, double d3) {
        if (string == null) {
            this.setBaseDimension(d, d2);
            this.setBaseCenter(point2D);
            if (string2 == null) {
                return;
            }
        }
        this.setRendering(new xDotNode(iOPGraph, this.base, string, string2, (int)d3));
    }

    protected void mimic(IOPNode iOPNode) {
        if (iOPNode.dotRendering != null) {
            this.setAttribute("rendering", this.dotRendering);
            this.dotRendering = new xDotNode(iOPNode.dotRendering);
            this.updateGlyphList();
        } else {
            this.setBaseCenter(iOPNode.getCenter());
        }
    }

    protected void revert(Point2D point2D) {
        if (this.dotRendering != null) {
            this.dotRendering = (xDotNode)this.getAttribute("rendering");
            this.updateGlyphList();
        } else {
            this.setBaseCenter(point2D);
        }
    }

    public IOPNode(IOPNode iOPNode) {
        super(iOPNode);
        this.type = iOPNode.type;
        this.dotNodeAttributes = (DotNodeAttributes)iOPNode.dotNodeAttributes.clone();
        this.id = iOPNode.id;
        this.longName = iOPNode.longName;
        this.shortName = iOPNode.shortName;
        this.stale = true;
        if (iOPNode.dotRendering != null) {
            this.dotRendering = new xDotNode(iOPNode.dotRendering);
            this.updateGlyphList();
        } else {
            this.base.setShape((Shape)((RectangularShape)this.base.getShape()).clone());
            this.setBaseCenter(iOPNode.getCenter());
        }
    }

    public String getName() {
        return this.id;
    }

    public Point2D getCenter() {
        if (this.stale) {
            this.updateGlyphList();
        }
        if (this.base != null) {
            Rectangle2D rectangle2D = this.base.getBounds();
            return new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY());
        }
        if (this.dotRendering != null) {
            Rectangle2D rectangle2D = this.dotRendering.bounds;
            return new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY());
        }
        System.err.println("WARNING: getCenter() bamboozled for node with id: " + this.id);
        return new Point2D.Double(0.0, 0.0);
    }

    public void setCenter(Point2D point2D) {
        Point2D point2D2 = this.getCenter();
        this.glyphList.translate(point2D.getX() - point2D2.getX(), point2D.getY() - point2D2.getY());
    }

    private static IOPNode makeNode(NodeType nodeType, String string, String string2, String string3, DotNodeAttributes dotNodeAttributes) {
        return new IOPNode(nodeType, string, string2, string3, dotNodeAttributes);
    }

    private static IOPNode makeNode(NodeType nodeType, String string, String string2, String string3, String string4, Color color, Color color2, int n) {
        return new IOPNode(nodeType, string, string2, string3, string2, string4, color, color2, n);
    }

    public static IOPNode makeOcc(String string, String string2, String string3, DotNodeAttributes dotNodeAttributes) {
        return IOPNode.makeNode(NodeType.OCC, string, string2, string3, dotNodeAttributes);
    }

    public static IOPNode makeOcc(String string, String string2, String string3, String string4, Color color, Color color2) {
        return IOPNode.makeNode(NodeType.OCC, string, string2, string3, string4, color, color2, PERIPHERIES_DEFAULT);
    }

    public static IOPNode makeOcc(String string, String string2, String string3, String string4, Color color, Color color2, int n) {
        return IOPNode.makeNode(NodeType.OCC, string, string2, string3, string4, color, color2, n);
    }

    public static IOPNode makeRule(String string, String string2, String string3, DotNodeAttributes dotNodeAttributes) {
        return IOPNode.makeNode(NodeType.RULE, string, string2, string3, dotNodeAttributes);
    }

    public static IOPNode makeRule(String string, String string2, String string3, String string4, Color color, Color color2) {
        return IOPNode.makeNode(NodeType.RULE, string, string2, string3, string4, color, color2, PERIPHERIES_DEFAULT);
    }

    public static IOPNode makeRule(String string, String string2, String string3, String string4, Color color, Color color2, int n) {
        return IOPNode.makeNode(NodeType.RULE, string, string2, string3, string4, color, color2, n);
    }

    public void updateFillColor() {
        try {
            Object object;
            Object object2;
            Object object3 = this.getAttribute("graph");
            if (object3 instanceof Attributable && (object2 = ((Attributable)object3).getAttribute("colorFun")) instanceof Closure && (object = ((Closure)object2).applyClosure(this)) instanceof Color) {
                this.setFillColor((Color)object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setNodeShape(String string) {
        this.shape = string == null ? "ellipse" : string;
        Shape shape = this.base.getShape();
        RectangularShape rectangularShape = (RectangularShape)shape;
        double d = rectangularShape.getX();
        double d2 = rectangularShape.getY();
        double d3 = rectangularShape.getWidth();
        double d4 = rectangularShape.getHeight();
        if (this.dotNodeAttributes != null) {
            this.dotNodeAttributes.setDotAttribute(DotAttributes.SHAPE, string);
        }
        this.base.setShape(this.string2Shape(this.shape, d, d2, d3, d4));
    }

    public void setNodeShape(xDotNode xDotNode2) {
        Glyph glyph = xDotNode2.base;
        if (glyph != null) {
            this.base = new Glyph(glyph);
        } else {
            System.err.println("WARNING setNodeShape: id = " + this.id + " hints = " + xDotNode2);
            System.err.println("WARNING setNodeShape: bounds = " + xDotNode2.bounds);
        }
    }

    public Shape string2Shape(String string, double d, double d2, double d3, double d4) {
        if (this.shape.equals("box") || this.shape.equals("rectangle") || this.shape.equals("record") || this.shape.equals("Mrecord")) {
            return new Rectangle2D.Double(d, d2, d3, d4);
        }
        if (this.shape.equals("triangle")) {
            return new Triangle(d, d2, d3, d4);
        }
        if (this.shape.equals("diamond")) {
            return new Diamond(d, d2, d3, d4);
        }
        if (this.shape.equals("hexagon")) {
            return new Hexagon(d, d2, d3, d4);
        }
        return new Ellipse2D.Double(d, d2, d3, d4);
    }

    public String getNodeShape() {
        return this.shape;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
        if (this.dotNodeAttributes != null) {
            this.dotNodeAttributes.setDotAttribute(DotAttributes.FILLCOLOR, color);
        }
        if (this.peripheries == 1) {
            this.base.setFill(color);
        } else {
            Glyph glyph = (Glyph)this.glyphList.get(0);
            if (glyph != null) {
                glyph.setFill(color);
            } else {
                this.base.setFill(color);
            }
        }
        this.stale = true;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
        if (this.dotNodeAttributes != null) {
            this.dotNodeAttributes.setDotAttribute(DotAttributes.COLOR, color);
        }
        this.stale = true;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBaseDimension(double d, double d2) {
        Shape shape = this.base.getShape();
        Rectangle rectangle = shape.getBounds();
        Point2D.Double double_ = new Point2D.Double(((RectangularShape)rectangle).getX(), ((RectangularShape)rectangle).getY());
        Dimension dimension = new Dimension();
        ((Dimension2D)dimension).setSize(d, d2);
        rectangle.setFrame(double_, dimension);
        this.stale = true;
    }

    public void setBaseCenter(Point2D point2D) {
        Shape shape = this.base.getShape();
        Rectangle rectangle = shape.getBounds();
        double d = ((RectangularShape)rectangle).getWidth();
        double d2 = ((RectangularShape)rectangle).getHeight();
        rectangle.setFrameFromCenter(point2D.getX(), point2D.getY(), point2D.getX() + d / 2.0, point2D.getY() + d2 / 2.0);
        this.stale = true;
    }

    public Rectangle2D getBaseFrame() {
        Shape shape = this.base.getShape();
        return shape.getBounds2D();
    }

    public void setLabel(String string) {
        if (string == null) {
            string = "";
        }
        this.displayLabel = string;
        this.dotNodeAttributes.setDotAttribute(DotAttributes.LABEL, string);
        this.stale = true;
    }

    public String getLabel() {
        return this.displayLabel;
    }

    public double getWidth() {
        return this.base.getBounds().getWidth();
    }

    public double getHeight() {
        return this.base.getBounds().getHeight();
    }

    public Point2D getPosition() {
        return new Point2D.Double(this.getBounds().getX(), this.getBounds().getY());
    }

    @Override
    public double distanceTo(Point2D point2D) {
        if (point2D == null) {
            return Double.MAX_VALUE;
        }
        if (this.base.inside(point2D)) {
            return 0.0;
        }
        Rectangle2D rectangle2D = this.base.getBounds();
        return point2D.distance(rectangle2D.getCenterX(), rectangle2D.getCenterY());
    }

    public Glyph scaleBase(int n) {
        Glyph glyph = new Glyph(this.base);
        Rectangle2D rectangle2D = this.base.getBounds();
        double d = rectangle2D.getWidth();
        double d2 = (d + (double)(2 * n)) / d;
        double d3 = rectangle2D.getHeight();
        double d4 = (d3 + (double)(2 * n)) / d3;
        double d5 = rectangle2D.getCenterX();
        double d6 = rectangle2D.getCenterY();
        glyph.translate(-d5, -d6);
        glyph.scale(d2, d4);
        glyph.translate(d5, d6);
        glyph.setBorder(Color.black);
        return glyph;
    }

    @Override
    public void highlight() {
        super.highlight();
        if (this.base != null) {
            this.base.setHighlighted(true);
        }
    }

    @Override
    public void dehighlight() {
        super.dehighlight();
        if (this.base != null) {
            this.base.setHighlighted(false);
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (this.stale) {
            this.updateGlyphList();
            this.stale = false;
        }
        super.paint(graphics2D);
    }

    public String toString() {
        return this.id;
    }

    public boolean equals(Object object) {
        return object instanceof IOPNode && ((IOPNode)object).id.equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public int compareTo(IOPNode iOPNode) {
        return String.CASE_INSENSITIVE_ORDER.compare(this.id, iOPNode.getName());
    }

    public String _toDotString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.id).append(" [");
        stringBuffer.append(this.dotNodeAttributes.toString());
        stringBuffer.append("]\n");
        return stringBuffer.toString();
    }

    public String toDotString() {
        String string = this.getAttributeAsString("rlabel", null);
        if (string != null) {
            DotNodeAttributes dotNodeAttributes = this.dotNodeAttributes;
            dotNodeAttributes.setDotAttribute(DotAttributes.SHAPE, "Mrecord");
            String string2 = (String)dotNodeAttributes.getDotAttribute(DotAttributes.LABEL);
            dotNodeAttributes.setDotAttribute(DotAttributes.LABEL, string);
            String string3 = this._toDotString();
            dotNodeAttributes.setDotAttribute(DotAttributes.LABEL, string2);
            return string3;
        }
        String string4 = this.getAttributeAsString("ilabel", null);
        if (string4 != null) {
            DotNodeAttributes dotNodeAttributes = this.dotNodeAttributes;
            String string5 = (String)dotNodeAttributes.getDotAttribute(DotAttributes.LABEL);
            dotNodeAttributes.setDotAttribute(DotAttributes.LABEL, string4);
            String string6 = this._toDotString();
            dotNodeAttributes.setDotAttribute(DotAttributes.LABEL, string5);
            return string6;
        }
        String string7 = this._toDotString();
        return string7;
    }

    public String deprecated_toDotString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.displayLabel;
        String string2 = this.shape;
        String string3 = "filled";
        stringBuffer.append(this.id).append(" [");
        stringBuffer.append("width=").append(0.138);
        stringBuffer.append(",height=").append(0.138);
        stringBuffer.append(",");
        if (!"".equals(string)) {
            stringBuffer.append("label=\"").append(string).append("\"");
        } else {
            stringBuffer.append("label=\" \"");
        }
        if (!"".equals(string2)) {
            stringBuffer.append(",shape=").append(string2);
        }
        if (this.peripheries != 1) {
            stringBuffer.append(",peripheries=").append(this.peripheries);
        }
        stringBuffer.append(",style=").append(string3);
        stringBuffer.append(",fillcolor=").append(Dot.colorToDotHSB(this.fillColor));
        stringBuffer.append(",color=").append(Dot.colorToDotHSB(this.borderColor));
        stringBuffer.append("]\n");
        return stringBuffer.toString();
    }

    public static int compareNodes(IOPNode iOPNode, IOPNode iOPNode2) {
        if (iOPNode.type == NodeType.OCC) {
            return IOPNode.compareToAsOcc(iOPNode, iOPNode2);
        }
        return IOPNode.compareToAsRule(iOPNode, iOPNode2);
    }

    public static int compareToAsOcc(IOPNode iOPNode, IOPNode iOPNode2) {
        String string = iOPNode.longName.replaceAll("[\\(:\\)]", "");
        String string2 = iOPNode2.longName.replaceAll("[\\(:\\)]", "");
        int n = String.CASE_INSENSITIVE_ORDER.compare(string, string2);
        return n;
    }

    public static int compareToAsRule(IOPNode iOPNode, IOPNode iOPNode2) {
        return Orderings.INTEGRAL_PREFIX.compare(iOPNode.longName, iOPNode2.longName);
    }

    public static enum NodeType {
        NONE,
        OCC,
        RULE;

    }
}

