/*
 * Decompiled with CFR 0.152.
 */
package g2d.graph;

import g2d.glyph.BufferedGlyphList;
import g2d.glyph.Glyphish;
import g2d.graph.Dot;
import g2d.graph.DotParserAPI;
import g2d.graph.GraphItem;
import g2d.graph.IOPEdge;
import g2d.graph.IOPNode;
import g2d.graph.IOPSubgraph;
import g2d.graph.Manifold;
import g2d.graph.Seed;
import g2d.graph.xdotparser.visitor.xDotEdge;
import g2d.graph.xdotparser.visitor.xDotNode;
import g2d.jlambda.Closure;
import g2d.jlambda.JMap;
import g2d.util.ActorMsg;
import g2d.util.IO;
import g2d.util.Pair;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.ChangeEvent;

public class IOPGraph
extends BufferedGlyphList {
    private static final boolean VERBOSE = false;
    private Manifold manifold = null;
    public static int hitDelta = 10;
    protected final String rankdir;
    private final Map<Integer, IOPEdge> edgesByGid = new JMap().makeMap();
    private final Map<String, IOPNode> nodesById = new JMap().makeMap();
    private final Map<String, IOPNode> nodesByLongname = new JMap().makeMap();
    private final Map<String, IOPSubgraph> subgraphsById = new JMap().makeMap();
    public final Map<Integer, GraphItem> graphItemsByGid = new JMap().makeMap();
    private final Map<Integer, Seed> seeds = new JMap().makeMap();
    public String name = null;
    public String title = null;
    public String description = null;
    public String images;
    private HashSet<IOPGraph> children = new HashSet();
    private IOPGraph parent = null;
    public Closure colorClosure = null;
    public Closure toolBarClosure = null;
    public Closure menuBarClosure = null;
    public Closure panelClosure = null;
    public Closure mouseClickedClosure = null;
    public static boolean expandAndContractDebug = false;
    public static Color cxtBorderColor = Color.DARK_GRAY;
    private HashMap<IOPNode, xDotNode> cachedDotNodeRendering = null;
    private HashMap<IOPEdge, xDotEdge> cachedDotEdgeRendering = null;
    private double dotWidth;
    private double dotHeight;
    private boolean isDotLayout = true;

    @Override
    public String toString() {
        return "IOPGraph: " + this.hashCode();
    }

    public IOPGraph getParent() {
        return this.parent;
    }

    public void setParent(IOPGraph iOPGraph) {
        this.parent = iOPGraph;
        if (iOPGraph != null) {
            iOPGraph.children.add(this);
        }
    }

    public IOPGraph[] getChildren() {
        return this.children.toArray(new IOPGraph[this.children.size()]);
    }

    public static final void setRenderableThreshold(int n, int n2) {
        BufferedGlyphList.NODE_THRESHOLD = n;
        BufferedGlyphList.EDGE_THRESHOLD = n2;
        BufferedGlyphList.THRESHOLD = BufferedGlyphList.NODE_THRESHOLD + BufferedGlyphList.EDGE_THRESHOLD;
    }

    public IOPGraph() {
        this("TB", null, null, null, null, null, null, null);
    }

    public IOPGraph(String string) {
        this(string, null, null, null, null, null, null, null);
    }

    public IOPGraph(String string, String string2, String string3, IOPGraph iOPGraph, Closure closure, Closure closure2, Closure closure3) {
        this("TB", string, string2, string3, iOPGraph, closure, closure2, closure3);
    }

    private IOPGraph(String string, String string2, String string3, String string4, IOPGraph iOPGraph, Closure closure, Closure closure2, Closure closure3) {
        if (!"TB".equals(string) && !"LR".equals(string)) {
            throw new IllegalArgumentException("Cannot instantiate IOPGraph with a rankdir other than \"LR\" or \"TB\"!");
        }
        this.rankdir = string;
        this.name = string2;
        this.title = string3;
        this.description = string4;
        this.parent = iOPGraph;
        this.colorClosure = closure;
        this.toolBarClosure = closure2;
        this.menuBarClosure = closure3;
    }

    public void cloneFromGraph(IOPGraph iOPGraph) {
        GraphItem graphItem;
        this.clear();
        for (IOPSubgraph graphItem2 : iOPGraph.subgraphsById.values()) {
            graphItem = new IOPSubgraph(graphItem2);
            this.addSubgraph((IOPSubgraph)graphItem);
        }
        for (IOPNode iOPNode : iOPGraph.nodesById.values()) {
            graphItem = new IOPNode(iOPNode);
            this.addNode((IOPNode)graphItem);
        }
        for (IOPEdge iOPEdge : iOPGraph.edgesByGid.values()) {
            graphItem = new IOPEdge(iOPEdge, this.getNode(iOPEdge.getSource().getName()), this.getNode(iOPEdge.getSink().getName()));
            this.addEdge((IOPEdge)graphItem);
        }
        this.setWidth(iOPGraph.width);
        this.setHeight(iOPGraph.height);
    }

    @Override
    public void setDisplayable() {
        this.setDisplayable(this.nodesById.size(), this.edgesByGid.size());
    }

    public boolean getDisplayable() {
        return this.displayable;
    }

    public String getGraphInfo() {
        return String.format("%d GraphItems, %d nodes, %d edges, %d subgraphs.", this.graphItemsByGid.size(), this.nodesById.size(), this.edgesByGid.size(), this.subgraphsById.size());
    }

    public void createManifold() {
        if (this.manifold != null) {
            return;
        }
        this.manifold = new Manifold((int)this.width, (int)this.height, Manifold.CHART_W, Manifold.CHART_H);
    }

    public void add2Manifold(Glyphish glyphish) {
        if (this.manifold == null) {
            return;
        }
        this.manifold.add(glyphish);
    }

    public void paint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.manifold == null) {
            System.err.println("super painting!");
            super.paint(graphics2D);
        } else {
            System.err.println("manifold painting!");
            this.manifold.paint(graphics2D, rectangle2D);
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (paintDebug) {
            System.err.println("Graph.paint(" + this.name + ")[" + this.paintCount++ + "] " + this.version + " version, " + this.nodesById.size() + " nodes, " + this.edgesByGid.size() + " edges.");
        }
        super.paint(graphics2D);
    }

    @Override
    public Glyphish getGlyphThing(Point2D point2D) {
        if (this.manifold == null) {
            return super.getGlyphThing(point2D);
        }
        return this.manifold.getGlyphThing(point2D);
    }

    public int size() {
        return this.edgesByGid.size() + this.nodesById.size();
    }

    public static void setAntiAliased(boolean bl) {
        GraphItem.antiAliased = bl;
    }

    public static boolean getAntiAliased() {
        return GraphItem.antiAliased;
    }

    public void setStrokeWidth(float f) {
        for (IOPEdge iOPEdge : this.edgesByGid.values()) {
            iOPEdge.setStrokeWidth(f);
        }
    }

    public boolean delete(IOPSubgraph iOPSubgraph) {
        if (iOPSubgraph == null) {
            return false;
        }
        if (iOPSubgraph != this.graphItemsByGid.get(iOPSubgraph.gid)) {
            return false;
        }
        this.removeSubgraph(iOPSubgraph);
        return true;
    }

    public void expand(IOPNode iOPNode) {
        boolean bl;
        if (expandAndContractDebug) {
            System.err.println("Expanding " + iOPNode);
            System.err.println("Graph edge set " + this.edgesByGid);
            System.err.println("GraphItems " + this.graphItemsByGid);
        }
        if (iOPNode == null) {
            return;
        }
        Seed seed = iOPNode.seed;
        if (seed == null) {
            System.err.println("IOPGraph.expand: cannot find any indication this node was once a subgraph.");
            return;
        }
        IOPSubgraph iOPSubgraph = seed.subgraph;
        boolean bl2 = false;
        for (IOPSubgraph object : this.subgraphsById.values()) {
            if (!object.nodes.contains(iOPNode.gid)) continue;
            object.nodes.remove(iOPNode.gid);
            object.subgraphs.add(iOPSubgraph.gid);
            bl2 = true;
        }
        iOPSubgraph.topLevel = !bl2;
        this.rmNode(iOPNode);
        this.seeds.remove(iOPNode.gid);
        for (IOPNode iOPNode2 : seed.nodes.values()) {
            this.addNode(iOPNode2);
        }
        for (IOPSubgraph iOPSubgraph2 : seed.subgraphs.values()) {
            this.addSubgraph(iOPSubgraph2);
        }
        for (IOPEdge iOPEdge : seed.edges.values()) {
            bl = this.repairEdge(iOPEdge);
            if (bl) continue;
            System.err.println("FAILURE repairEdge(4) edge = " + iOPEdge);
        }
        for (Pair pair : seed.modifiedEdges.values()) {
            bl = this.repairEdge((IOPEdge)pair.second);
            if (bl) continue;
            System.err.println("FAILURE repairEdge(6) edge = " + pair.second);
        }
        if (expandAndContractDebug) {
            System.err.println("Graph edge set " + this.edgesByGid);
            System.err.println("GraphItems " + this.graphItemsByGid);
            System.err.println("Expanded " + iOPNode);
        }
    }

    private boolean repairEdge(IOPEdge iOPEdge) {
        IOPNode iOPNode = iOPEdge.source;
        IOPNode iOPNode2 = iOPEdge.sink;
        boolean bl = this.graphItemsByGid.get(iOPNode.gid) != null;
        boolean bl2 = this.graphItemsByGid.get(iOPNode2.gid) != null;
        boolean bl3 = false;
        if (expandAndContractDebug) {
            System.err.println(">>repairEdge considering edge =  " + iOPEdge.gid + ": " + iOPEdge);
        }
        if (bl && bl2) {
            this.addEdge(iOPEdge);
            bl3 = true;
        } else {
            if (expandAndContractDebug) {
                System.err.println("Need to repair edge: " + iOPEdge.gid + " source = " + iOPNode.gid + " sink = " + iOPNode2.gid);
            }
            if (!bl) {
                iOPNode = this.findProxyForNode(iOPNode, iOPEdge.gid);
            }
            if (!bl2) {
                iOPNode2 = this.findProxyForNode(iOPNode2, iOPEdge.gid);
            }
            if (iOPNode != null && iOPNode2 != null) {
                IOPEdge iOPEdge2 = new IOPEdge(iOPEdge, iOPNode, iOPNode2);
                IOPEdge iOPEdge3 = (IOPEdge)this.graphItemsByGid.get(iOPEdge.gid);
                if (iOPEdge3 != null) {
                    this.rmEdge(iOPEdge3);
                } else {
                    System.err.println("edge " + iOPEdge + " not in " + this.edgesByGid);
                }
                if (!this.edgesByGid.containsKey(iOPEdge2)) {
                    this.addEdge(iOPEdge2);
                }
                if (expandAndContractDebug) {
                    System.err.println("Repaired edge: " + iOPEdge.gid + ", new edge: " + iOPEdge2);
                }
                bl3 = true;
            } else {
                System.err.println("Didn't find proxy for an edge node: " + iOPEdge.gid + " source = " + iOPNode.gid + " sink = " + iOPNode2.gid);
                bl3 = false;
            }
        }
        if (expandAndContractDebug) {
            System.err.println("<<repairEdge repaired edge = " + iOPEdge + " returned " + bl3);
        }
        return bl3;
    }

    private IOPNode findProxyForNode(IOPNode iOPNode, Integer n) {
        IOPNode iOPNode2 = null;
        if (iOPNode == null) {
            return iOPNode2;
        }
        Seed seed = iOPNode.seed;
        if (seed != null && this.graphItemsByGid.get(seed.subgraph.gid) != null) {
            IOPEdge iOPEdge = (IOPEdge)seed.modifiedEdges.get((Object)n).first;
            if (iOPEdge != null) {
                boolean bl;
                boolean bl2 = seed.nodes.get(iOPEdge.source.gid) != null;
                boolean bl3 = bl = seed.nodes.get(iOPEdge.sink.gid) != null;
                if (!bl2 && !bl) {
                    if (expandAndContractDebug) {
                        System.err.println("findProxyForNode(" + iOPNode.gid + ") = " + null);
                    }
                    return null;
                }
                if (bl2) {
                    iOPNode2 = iOPEdge.source;
                    if (expandAndContractDebug) {
                        System.err.println("findProxyForNode(" + iOPNode.gid + ") = " + iOPNode2);
                    }
                    return iOPNode2;
                }
                if (bl) {
                    iOPNode2 = iOPEdge.sink;
                    if (expandAndContractDebug) {
                        System.err.println("findProxyForNode(" + iOPNode.gid + ") = " + iOPNode2);
                    }
                    return iOPNode2;
                }
            } else {
                System.err.println("Bamboozled here in findProxyForNode: " + iOPNode);
            }
        }
        for (Seed seed2 : this.seeds.values()) {
            if (seed2.nodes.get(iOPNode.gid) == null) continue;
            IOPNode iOPNode3 = seed2.node;
            if (this.graphItemsByGid.get(iOPNode3.gid) != null) {
                if (expandAndContractDebug) {
                    System.err.println("findProxyForNode(" + iOPNode.gid + ") = " + iOPNode3);
                }
                return iOPNode3;
            }
            iOPNode2 = this.findProxyForNode(iOPNode3, n);
            if (expandAndContractDebug) {
                System.err.println("findProxyForNode(" + iOPNode.gid + ") = " + iOPNode2);
            }
            return iOPNode2;
        }
        if (expandAndContractDebug) {
            System.err.println("findProxyForNode(" + iOPNode.gid + ") = " + iOPNode2);
        }
        return iOPNode2;
    }

    public void contract(IOPSubgraph iOPSubgraph, IOPNode iOPNode) {
        try {
            Object object;
            Object object2;
            if (iOPSubgraph == null) {
                return;
            }
            if (iOPNode == null) {
                iOPNode = new IOPNode(iOPSubgraph.name + "_collapsed");
            }
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            HashSet<Integer> hashSet3 = new HashSet<Integer>();
            HashSet<Integer> hashSet4 = new HashSet<Integer>();
            iOPSubgraph.flatten(this, hashSet2, hashSet3, hashSet4);
            hashSet4.add(iOPSubgraph.gid);
            Seed seed = new Seed(this, iOPSubgraph, iOPNode, hashSet2, hashSet3, hashSet4);
            for (Integer serializable2 : hashSet2) {
                object2 = (IOPNode)this.graphItemsByGid.get(serializable2);
                this.rmNode((IOPNode)object2);
            }
            for (Integer n : hashSet4) {
                object2 = (IOPSubgraph)this.graphItemsByGid.get(n);
                this.deleteSubgraph((IOPSubgraph)object2);
            }
            HashMap hashMap = new HashMap();
            HashMap<Integer, IOPSubgraph> hashMap2 = new HashMap<Integer, IOPSubgraph>();
            object2 = new HashMap();
            HashMap<Integer, IOPEdge> hashMap3 = new HashMap<Integer, IOPEdge>();
            for (IOPEdge iOPEdge : this.edgesByGid.values()) {
                if (hashSet3.contains(iOPEdge.gid)) {
                    hashMap3.put(iOPEdge.gid, iOPEdge);
                    continue;
                }
                object = this.contractEdge(iOPEdge, iOPNode, hashSet2);
                if (object == null || object == iOPEdge) continue;
                hashMap.put(iOPEdge.gid, new Pair<IOPEdge, IOPEdge>(iOPEdge, (IOPEdge)object));
                hashMap3.put(iOPEdge.gid, iOPEdge);
                ((HashMap)object2).put(((IOPEdge)object).gid, object);
            }
            for (Integer n : hashMap3.keySet()) {
                this.rmEdge((IOPEdge)hashMap3.get(n));
            }
            for (Integer n : ((HashMap)object2).keySet()) {
                this.addEdge((IOPEdge)((HashMap)object2).get(n));
            }
            object2 = null;
            hashMap3 = null;
            Object object3 = new HashSet();
            HashSet<IOPSubgraph> hashSet = new HashSet<IOPSubgraph>();
            for (IOPSubgraph iOPSubgraph2 : this.subgraphsById.values()) {
                if (hashSet4.contains(iOPSubgraph2.gid) || !iOPSubgraph2.subgraphs.contains(iOPSubgraph.gid)) continue;
                IOPSubgraph iOPSubgraph3 = new IOPSubgraph(iOPSubgraph2);
                iOPSubgraph3.subgraphs.remove(iOPSubgraph.gid);
                iOPSubgraph3.nodes.add(iOPNode.gid);
                hashSet.add(iOPSubgraph2);
                ((HashSet)object3).add(iOPSubgraph3);
                hashMap2.put(iOPSubgraph2.gid, iOPSubgraph2);
            }
            for (IOPSubgraph iOPSubgraph2 : hashSet) {
                this.deleteSubgraph(iOPSubgraph2);
            }
            object = ((HashSet)object3).iterator();
            while (object.hasNext()) {
                IOPSubgraph iOPSubgraph2;
                iOPSubgraph2 = (IOPSubgraph)object.next();
                this.addSubgraph(iOPSubgraph2);
            }
            Object var12_22 = null;
            object3 = null;
            seed.setModifiedEdges(hashMap);
            seed.setModifiedSubgraphs(hashMap2);
            iOPNode.seed = seed;
            this.seeds.put(iOPNode.gid, seed);
            if (expandAndContractDebug) {
                System.err.println("Seed: " + seed);
            }
            this.addNode(iOPNode);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private IOPEdge contractEdge(IOPEdge iOPEdge, IOPNode iOPNode, HashSet<Integer> hashSet) {
        IOPNode iOPNode2 = iOPEdge.getSource();
        IOPNode iOPNode3 = iOPEdge.getSink();
        IOPNode iOPNode4 = iOPNode2;
        IOPNode iOPNode5 = iOPNode3;
        IOPEdge iOPEdge2 = null;
        boolean bl = hashSet.contains(iOPNode2.gid);
        boolean bl2 = hashSet.contains(iOPNode3.gid);
        if (bl || bl2) {
            if (bl && bl2) {
                return null;
            }
            if (bl) {
                iOPNode4 = iOPNode;
            }
            if (bl2) {
                iOPNode5 = iOPNode;
            }
            iOPEdge2 = new IOPEdge(iOPEdge, iOPNode4, iOPNode5);
        } else {
            iOPEdge2 = iOPEdge;
        }
        return iOPEdge2;
    }

    public IOPGraph collapse(IOPSubgraph iOPSubgraph, IOPNode iOPNode) {
        GraphItem graphItem;
        IOPGraph iOPGraph = null;
        if (iOPSubgraph == null) {
            return iOPGraph;
        }
        if (iOPNode == null) {
            iOPNode = new IOPNode(iOPSubgraph.name + "_collapsed");
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        HashSet<Integer> hashSet3 = new HashSet<Integer>();
        iOPSubgraph.flatten(this, hashSet, hashSet2, hashSet3);
        hashSet3.add(iOPSubgraph.gid);
        iOPGraph = new IOPGraph();
        iOPGraph.addNode(iOPNode);
        for (IOPNode graphItem2 : this.nodesById.values()) {
            if (hashSet.contains(graphItem2.gid)) continue;
            graphItem = new IOPNode(graphItem2);
            iOPGraph.addNode((IOPNode)graphItem);
        }
        for (IOPEdge iOPEdge : this.edgesByGid.values()) {
            if (hashSet2.contains(iOPEdge.gid) || (graphItem = this.collapseEdge(iOPGraph, iOPEdge, iOPNode, hashSet)) == null) continue;
            iOPGraph.addEdge((IOPEdge)graphItem);
        }
        for (IOPSubgraph iOPSubgraph2 : this.subgraphsById.values()) {
            if (hashSet3.contains(iOPSubgraph2.gid)) continue;
            graphItem = new IOPSubgraph(iOPSubgraph2);
            if (((IOPSubgraph)graphItem).subgraphs.contains(iOPSubgraph.gid)) {
                ((IOPSubgraph)graphItem).subgraphs.remove(iOPSubgraph.gid);
                ((IOPSubgraph)graphItem).nodes.add(iOPNode.gid);
            }
            iOPGraph.addSubgraph((IOPSubgraph)graphItem);
        }
        iOPGraph.setWidth(this.width);
        iOPGraph.setHeight(this.height);
        return iOPGraph;
    }

    private IOPEdge collapseEdge(IOPGraph iOPGraph, IOPEdge iOPEdge, IOPNode iOPNode, HashSet<Integer> hashSet) {
        IOPNode iOPNode2 = iOPEdge.getSource();
        IOPNode iOPNode3 = iOPEdge.getSink();
        IOPNode iOPNode4 = null;
        IOPNode iOPNode5 = null;
        boolean bl = hashSet.contains(iOPNode2.gid);
        boolean bl2 = hashSet.contains(iOPNode3.gid);
        if (bl || bl2) {
            if (bl && bl2) {
                return null;
            }
            iOPNode4 = bl ? iOPNode : (IOPNode)iOPGraph.graphItemsByGid.get(iOPNode2.gid);
            iOPNode5 = bl2 ? iOPNode : (IOPNode)iOPGraph.graphItemsByGid.get(iOPNode3.gid);
        } else {
            iOPNode4 = (IOPNode)iOPGraph.graphItemsByGid.get(iOPNode2.gid);
            iOPNode5 = (IOPNode)iOPGraph.graphItemsByGid.get(iOPNode3.gid);
        }
        IOPEdge iOPEdge2 = new IOPEdge(iOPEdge, iOPNode4, iOPNode5);
        return iOPEdge2;
    }

    private HashSet<Integer> collectGids(Collection<?> collection) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (collection != null && !collection.isEmpty()) {
            for (Object obj : collection) {
                if (obj instanceof GraphItem) {
                    GraphItem graphItem = (GraphItem)obj;
                    Integer n = graphItem.gid;
                    if (!this.graphItemsByGid.containsKey(n)) {
                        System.err.println("IOPGraph.collectGids: " + graphItem + " not in graph, failing!");
                        return null;
                    }
                    hashSet.add(n);
                    continue;
                }
                System.err.println("IOPGraph.collectGids: " + obj + " not a GraphItem, failing!");
                return null;
            }
        }
        return hashSet;
    }

    private boolean some(HashSet<Integer> hashSet, HashSet<Integer> hashSet2) {
        for (Integer n : hashSet) {
            if (!hashSet2.contains(n)) continue;
            return true;
        }
        return false;
    }

    private boolean all(HashSet<Integer> hashSet, HashSet<Integer> hashSet2) {
        return hashSet2.containsAll(hashSet);
    }

    public IOPSubgraph getParentSubgraph(IOPSubgraph iOPSubgraph) {
        if (iOPSubgraph == null) {
            return null;
        }
        Integer n = iOPSubgraph.gid;
        for (IOPSubgraph iOPSubgraph2 : this.subgraphsById.values()) {
            if (!iOPSubgraph2.subgraphs.contains(n)) continue;
            return iOPSubgraph2;
        }
        return null;
    }

    private Integer getParentSubgraphGid(HashSet<Integer> hashSet, HashSet<Integer> hashSet2, HashSet<Integer> hashSet3) {
        Integer n = new Integer(-1);
        if (this.subgraphsById.isEmpty()) {
            return n;
        }
        for (IOPSubgraph iOPSubgraph : this.subgraphsById.values()) {
            if (!this.some(hashSet, iOPSubgraph.nodes) && !this.some(hashSet2, iOPSubgraph.edges) && !this.some(hashSet3, iOPSubgraph.subgraphs)) continue;
            boolean bl = this.all(hashSet, iOPSubgraph.nodes);
            boolean bl2 = this.all(hashSet2, iOPSubgraph.edges);
            boolean bl3 = this.all(hashSet3, iOPSubgraph.subgraphs);
            if (bl && bl2 && bl3) {
                return iOPSubgraph.gid;
            }
            System.err.println("getParentSubgraphGid: failure " + iOPSubgraph.gid + " " + bl + " " + bl2 + " " + bl3);
            return null;
        }
        return n;
    }

    public IOPSubgraph makeSubgraph(Collection<GraphItem> collection) {
        IOPSubgraph iOPSubgraph = null;
        if (collection != null) {
            ArrayList<IOPNode> arrayList = new ArrayList<IOPNode>();
            ArrayList<IOPEdge> arrayList2 = new ArrayList<IOPEdge>();
            ArrayList<IOPSubgraph> arrayList3 = new ArrayList<IOPSubgraph>();
            for (GraphItem graphItem : collection) {
                if (graphItem instanceof IOPNode) {
                    arrayList.add((IOPNode)graphItem);
                    continue;
                }
                if (graphItem instanceof IOPEdge) {
                    arrayList2.add((IOPEdge)graphItem);
                    continue;
                }
                if (!(graphItem instanceof IOPSubgraph)) continue;
                arrayList3.add((IOPSubgraph)graphItem);
            }
            iOPSubgraph = this.makeSubgraph(null, arrayList, arrayList2, arrayList3);
        }
        return iOPSubgraph;
    }

    public IOPSubgraph makeSubgraph(IOPNode[] iOPNodeArray, IOPEdge[] iOPEdgeArray, IOPSubgraph[] iOPSubgraphArray) {
        return this.makeSubgraph(null, iOPNodeArray, iOPEdgeArray, iOPSubgraphArray);
    }

    public IOPSubgraph makeSubgraph(String string, IOPNode[] iOPNodeArray, IOPEdge[] iOPEdgeArray, IOPSubgraph[] iOPSubgraphArray) {
        List<IOPNode> list = null;
        List<IOPEdge> list2 = null;
        List<IOPSubgraph> list3 = null;
        if (iOPNodeArray != null) {
            list = Arrays.asList(iOPNodeArray);
        }
        if (iOPEdgeArray != null) {
            list2 = Arrays.asList(iOPEdgeArray);
        }
        if (iOPSubgraphArray != null) {
            list3 = Arrays.asList(iOPSubgraphArray);
        }
        return this.makeSubgraph(string, list, list2, list3);
    }

    public IOPSubgraph makeSubgraph(Collection<IOPNode> collection, Collection<IOPEdge> collection2, Collection<IOPSubgraph> collection3) {
        return this.makeSubgraph(null, collection, collection2, collection3);
    }

    public IOPSubgraph makeSubgraph(String string, Collection<IOPNode> collection, Collection<IOPEdge> collection2, Collection<IOPSubgraph> collection3) {
        IOPSubgraph iOPSubgraph = null;
        if (string == null) {
            string = IOPSubgraph.gensymSubgraphName(this);
        }
        if (this.subgraphsById.containsKey(string)) {
            System.err.println("IOPGraph.makeSubgraph: name already in use!");
            return iOPSubgraph;
        }
        if (collection == null && collection2 == null && collection3 == null) {
            System.err.println("IOPGraph.makeSubgraph: one of nodes, edges and subgraphs should be non null!");
            return iOPSubgraph;
        }
        HashSet<Integer> hashSet = this.collectGids(collection);
        HashSet<Integer> hashSet2 = this.collectGids(collection2);
        HashSet<Integer> hashSet3 = this.collectGids(collection3);
        if (hashSet == null || hashSet2 == null || hashSet3 == null) {
            System.err.println("IOPGraph.makeSubgraph: collection failed!");
            return iOPSubgraph;
        }
        Integer n = this.getParentSubgraphGid(hashSet, hashSet2, hashSet3);
        if (n == null) {
            System.err.println("IOPGraph.makeSubgraph: parentage failed!");
            return iOPSubgraph;
        }
        int n2 = n;
        iOPSubgraph = new IOPSubgraph(this, string, n2 == -1, hashSet, hashSet2, hashSet3);
        if (n2 != -1) {
            IOPSubgraph iOPSubgraph2 = (IOPSubgraph)this.graphItemsByGid.get(n2);
            if (iOPSubgraph2 == null) {
                System.err.println("IOPGraph.makeSubgraph: deadbeat parent!");
                return iOPSubgraph;
            }
            iOPSubgraph2.subgraphs.removeAll(hashSet3);
            iOPSubgraph2.nodes.removeAll(hashSet);
            iOPSubgraph2.edges.removeAll(iOPSubgraph.edges);
            iOPSubgraph2.addSubgraph(iOPSubgraph);
        } else {
            for (Integer n3 : hashSet3) {
                IOPSubgraph iOPSubgraph3 = (IOPSubgraph)this.graphItemsByGid.get(n3);
                iOPSubgraph3.topLevel = false;
            }
        }
        return iOPSubgraph;
    }

    public GraphItem getGraphItemByGid(Integer n) {
        return this.graphItemsByGid.get(n);
    }

    private void addGraphItem(GraphItem graphItem) {
        if (graphItem == null) {
            return;
        }
        this.graphItemsByGid.put(graphItem.gid, graphItem);
    }

    private void removeGraphItem(GraphItem graphItem) {
        if (graphItem == null) {
            return;
        }
        this.graphItemsByGid.remove(graphItem.gid);
    }

    public void addSubgraph(IOPSubgraph iOPSubgraph) {
        if (iOPSubgraph != null) {
            this.subgraphsById.put(iOPSubgraph.getName(), iOPSubgraph);
            super.add(iOPSubgraph);
            this.addGraphItem(iOPSubgraph);
        }
    }

    public void removeSubgraph(IOPSubgraph iOPSubgraph) {
        if (iOPSubgraph != null) {
            IOPSubgraph iOPSubgraph2 = this.getParentSubgraph(iOPSubgraph);
            Integer n = iOPSubgraph.gid;
            if (iOPSubgraph2 == null) {
                for (Integer object : iOPSubgraph.subgraphs) {
                    IOPSubgraph iOPSubgraph3 = (IOPSubgraph)this.graphItemsByGid.get(object);
                    iOPSubgraph3.topLevel = true;
                }
            } else {
                iOPSubgraph2.nodes.addAll(iOPSubgraph.nodes);
                iOPSubgraph2.edges.addAll(iOPSubgraph.edges);
                iOPSubgraph2.subgraphs.addAll(iOPSubgraph.subgraphs);
            }
            for (IOPSubgraph iOPSubgraph4 : this.subgraphsById.values()) {
                iOPSubgraph4.subgraphs.remove(n);
            }
            this.deleteSubgraph(iOPSubgraph);
        }
    }

    private void deleteSubgraph(IOPSubgraph iOPSubgraph) {
        if (iOPSubgraph != null) {
            this.subgraphsById.remove(iOPSubgraph.getName());
            super.remove(iOPSubgraph);
            this.removeGraphItem(iOPSubgraph);
        }
    }

    public void addNode(IOPNode iOPNode) {
        if (iOPNode != null) {
            this.nodesById.put(iOPNode.getName(), iOPNode);
            this.nodesByLongname.put(iOPNode.longName, iOPNode);
            iOPNode.setAttribute("graph", this);
            this.addGraphItem(iOPNode);
            super.add(iOPNode);
        }
    }

    public void rmNode(IOPNode iOPNode) {
        if (iOPNode != null) {
            this.nodesById.remove(iOPNode.getName());
            this.nodesByLongname.remove(iOPNode.longName);
            iOPNode.removeAttribute("graph");
            this.removeGraphItem(iOPNode);
            super.remove(iOPNode);
        }
    }

    @Override
    public void clear() {
        this.edgesByGid.clear();
        this.nodesById.clear();
        this.nodesByLongname.clear();
        this.subgraphsById.clear();
        this.graphItemsByGid.clear();
        super.clear();
    }

    public void addEdge(IOPEdge iOPEdge) {
        if (iOPEdge != null) {
            this.edgesByGid.put(iOPEdge.gid, iOPEdge);
            this.addGraphItem(iOPEdge);
            super.add(iOPEdge);
        }
    }

    public void rmEdge(IOPEdge iOPEdge) {
        if (iOPEdge != null) {
            this.edgesByGid.remove(iOPEdge.gid);
            this.removeGraphItem(iOPEdge);
            super.remove(iOPEdge);
        }
    }

    public HashMap<IOPNode, Vector<IOPNode>> makeAdjacencyList() {
        HashMap<IOPNode, Vector<IOPNode>> hashMap = new HashMap<IOPNode, Vector<IOPNode>>();
        for (IOPEdge iOPEdge : this.edgesByGid.values()) {
            Vector<IOPNode> vector = hashMap.get(iOPEdge.getSource());
            if (vector == null) {
                vector = new Vector();
                vector.add(iOPEdge.getSink());
                hashMap.put(iOPEdge.getSource(), vector);
                continue;
            }
            vector.add(iOPEdge.getSink());
        }
        return hashMap;
    }

    public void printAdjacencyList() {
        System.err.println(this.makeAdjacencyList() + "\n");
    }

    public boolean setGraph(File file) {
        File file2;
        try {
            file2 = File.createTempFile("dotOut", "." + Dot.DEFAULT_DOT_FORMAT.extension);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return false;
        }
        file2.deleteOnExit();
        if (Dot.queryDot(Dot.DEFAULT_DOT_FORMAT, file, file2)) {
            String string = IO.file2String(file2);
            IOPGraph iOPGraph = DotParserAPI.parse(null, string);
            this.cloneFromGraph(iOPGraph);
            return true;
        }
        return false;
    }

    public String makeDotInput() {
        return Dot.makeDotInput(this, this.subgraphsById.values(), new HashSet<IOPNode>(this.nodesById.values()), new HashMap<Integer, IOPEdge>(this.edgesByGid));
    }

    public boolean doLayout() {
        try {
            String string = this.makeDotInput();
            String string2 = Dot.askDot(Dot.DEFAULT_DOT_FORMAT, string);
            if (string2 == null) {
                System.err.println("Dot.askDot(input) failed\n");
                return false;
            }
            DotParserAPI.parse(this, string2);
            this.fireChange(new ChangeEvent(new Dot()));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void writeGraph(File file) {
        IO.string2File(this.makeDotInput(), file.getPath());
    }

    public void writeGraph(File file, Dot.DotFormat dotFormat) {
        this.writeGraph(file.getPath(), dotFormat);
    }

    public void writeGraph(String string, Dot.DotFormat dotFormat) {
        String string2 = this.makeDotInput();
        String string3 = Dot.askDot(dotFormat, string2);
        if (dotFormat.fileType == Dot.FileType.BINARY) {
            IO.b64String2File(string3, string);
        } else {
            IO.string2File(string3, string);
        }
    }

    public IOPEdge getEdge(Point2D point2D) {
        for (IOPEdge iOPEdge : this.edgesByGid.values()) {
            if (!iOPEdge.inside(point2D)) continue;
            return iOPEdge;
        }
        return null;
    }

    public IOPEdge getEdge(Point2D point2D, double d) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX() - d / 2.0, point2D.getY() - d / 2.0, d, d);
        ArrayList<IOPEdge> arrayList = new ArrayList<IOPEdge>();
        for (IOPEdge iOPEdge : this.edgesByGid.values()) {
            if (!iOPEdge.intersects(double_)) continue;
            arrayList.add(iOPEdge);
        }
        Object object = null;
        double d2 = Double.MAX_VALUE;
        for (IOPEdge iOPEdge : arrayList) {
            double d3 = iOPEdge.distanceTo(point2D);
            if (!(d3 <= d2)) continue;
            d3 = d2;
            object = iOPEdge;
        }
        return object;
    }

    public IOPNode getNode(Point2D point2D) {
        for (IOPNode iOPNode : this.nodesById.values()) {
            if (!iOPNode.inside(point2D)) continue;
            return iOPNode;
        }
        return null;
    }

    public IOPSubgraph getSubgraph(Point2D point2D) {
        for (IOPSubgraph iOPSubgraph : this.subgraphsById.values()) {
            if (!iOPSubgraph.inside(point2D)) continue;
            return this.getSmallestSubgraph(iOPSubgraph, point2D);
        }
        return null;
    }

    public IOPSubgraph getSmallestSubgraph(IOPSubgraph iOPSubgraph, Point2D point2D) {
        HashSet<Integer> hashSet = iOPSubgraph.subgraphs;
        if (!hashSet.isEmpty()) {
            for (Integer n : hashSet) {
                IOPSubgraph iOPSubgraph2 = (IOPSubgraph)this.graphItemsByGid.get(n);
                if (!iOPSubgraph2.inside(point2D)) continue;
                return this.getSmallestSubgraph(iOPSubgraph2, point2D);
            }
        }
        return iOPSubgraph;
    }

    public GraphItem getGraphItem(Point2D point2D, double d) {
        if (point2D == null) {
            throw new IllegalArgumentException("Cannot find graph item for point being NULL.");
        }
        IOPNode iOPNode = this.getNode(point2D);
        if (iOPNode != null) {
            return iOPNode;
        }
        IOPEdge iOPEdge = this.getEdge(point2D, d);
        if (iOPEdge != null) {
            return iOPEdge;
        }
        return this.getSubgraph(point2D);
    }

    public IOPSubgraph getSubgraph(String string) {
        return this.subgraphsById.get(string);
    }

    public IOPNode[] getNodesInArray() {
        return this.nodesById.values().toArray(new IOPNode[this.nodesById.size()]);
    }

    public Collection<IOPNode> getNodesInCollection() {
        return this.nodesById.values();
    }

    public IOPSubgraph[] getSubgraphsInArray() {
        return this.subgraphsById.values().toArray(new IOPSubgraph[this.subgraphsById.size()]);
    }

    public Collection<IOPSubgraph> getSubgraphInCollection() {
        return this.subgraphsById.values();
    }

    public GraphItem[] getGraphItemsInArray() {
        return this.graphItemsByGid.values().toArray(new GraphItem[this.graphItemsByGid.size()]);
    }

    public Collection<GraphItem> getGraphItemsInCollection() {
        return this.graphItemsByGid.values();
    }

    public IOPNode getNode(String string) {
        return this.nodesById.get(string);
    }

    public IOPEdge[] getEdgesInArray() {
        return this.edgesByGid.values().toArray(new IOPEdge[this.edgesByGid.size()]);
    }

    public IOPEdge getEdge(IOPNode iOPNode, IOPNode iOPNode2) {
        for (IOPEdge iOPEdge : this.edgesByGid.values()) {
            if (!iOPEdge.getSource().equals(iOPNode) || !iOPEdge.getSink().equals(iOPNode2)) continue;
            return iOPEdge;
        }
        return null;
    }

    @Override
    public void fireChange() {
        this.fireChange(new ChangeEvent(this));
    }

    public void fireChange(GraphItem graphItem) {
        this.fireChange(new ChangeEvent(graphItem));
    }

    public IOPNode getIOPNode(String string) {
        return this.nodesByLongname.get(string);
    }

    public void resetAllStatus() {
        for (IOPNode iOPNode : this.nodesById.values()) {
            iOPNode.setAttribute("status", "none");
            iOPNode.updateFillColor();
        }
        ActorMsg.send("maude", this.getUID(), "resetStatus");
    }

    private void cacheInfo() {
        IOPNode[] iOPNodeArray = this.getNodesInArray();
        IOPEdge[] iOPEdgeArray = this.getEdgesInArray();
        this.cachedDotNodeRendering = new HashMap();
        this.cachedDotEdgeRendering = new HashMap();
        for (IOPNode graphItem : iOPNodeArray) {
            this.cachedDotNodeRendering.put(graphItem, graphItem.dotRendering);
        }
        for (GraphItem graphItem : iOPEdgeArray) {
            this.cachedDotEdgeRendering.put((IOPEdge)graphItem, ((IOPEdge)graphItem).dotRendering);
        }
        this.dotWidth = this.getWidth();
        this.dotHeight = this.getHeight();
    }

    private boolean doNewDotLayout() {
        boolean bl = true;
        bl = this.doLayout();
        this.cacheInfo();
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private boolean redoDotLayout() {
        int n;
        boolean bl = true;
        for (IOPEdge graphItem : this.getEdgesInArray()) {
            if (!"true".equals(graphItem.getSource().getAttribute("context")) && !"true".equals(graphItem.getSink().getAttribute("context"))) continue;
            this.rmEdge(graphItem);
        }
        GraphItem[] graphItemArray = this.getNodesInArray();
        int n2 = graphItemArray.length;
        for (n = 0; n < n2; ++n) {
            GraphItem graphItem = graphItemArray[n];
            if (!"true".equals(graphItem.getAttribute("context"))) continue;
            this.rmNode((IOPNode)graphItem);
        }
        if (this.cachedDotNodeRendering == null || this.cachedDotEdgeRendering == null) {
            bl = this.doLayout();
            this.cacheInfo();
        } else {
            void var5_11;
            GraphItem[] graphItemArray2 = graphItemArray = this.getEdgesInArray();
            n = graphItemArray2.length;
            boolean bl2 = false;
            while (var5_11 < n) {
                GraphItem graphItem = graphItemArray2[var5_11];
                xDotEdge xDotEdge2 = this.cachedDotEdgeRendering.get(graphItem);
                if (xDotEdge2 != null) {
                    ((IOPEdge)graphItem).resetRendering(xDotEdge2);
                }
                ++var5_11;
            }
            for (GraphItem graphItem : graphItemArray2 = this.getNodesInArray()) {
                xDotNode xDotNode2 = this.cachedDotNodeRendering.get(graphItem);
                ((IOPNode)graphItem).setRendering(xDotNode2);
            }
            this.setWidth(this.dotWidth);
            this.setHeight(this.dotHeight);
        }
        return bl;
    }

    private boolean doContextLayout(IOPGraph iOPGraph) {
        GraphItem graphItem;
        GraphItem graphItem2;
        HashMap<String, IOPNode> hashMap = new HashMap<String, IOPNode>();
        for (IOPNode graphItem3 : iOPGraph.getNodesInArray()) {
            graphItem2 = this.getIOPNode(graphItem3.longName);
            if (graphItem2 == null) {
                graphItem = new IOPNode(graphItem3);
                graphItem.setAttribute("context", "true");
                ((IOPNode)graphItem).updateFillColor();
                ((IOPNode)graphItem).setBorderColor(cxtBorderColor);
                this.addNode((IOPNode)graphItem);
                hashMap.put(graphItem3.getName(), (IOPNode)graphItem);
                continue;
            }
            ((IOPNode)graphItem2).setRendering(new xDotNode(graphItem3.dotRendering));
            hashMap.put(graphItem3.getName(), (IOPNode)graphItem2);
        }
        for (GraphItem graphItem3 : iOPGraph.getEdgesInArray()) {
            graphItem2 = this.getEdge(((IOPEdge)graphItem3).getSource(), ((IOPEdge)graphItem3).getSink());
            if (graphItem2 == null) {
                graphItem = new IOPEdge((IOPEdge)graphItem3, (IOPNode)hashMap.get(((IOPEdge)graphItem3).getSource().getName()), (IOPNode)hashMap.get(((IOPEdge)graphItem3).getSink().getName()));
                ((IOPEdge)graphItem).setColor(cxtBorderColor);
                this.addEdge((IOPEdge)graphItem);
                continue;
            }
            ((IOPEdge)graphItem2).setRendering(new xDotEdge(((IOPEdge)graphItem3).dotRendering));
        }
        this.setWidth(iOPGraph.getWidth());
        this.setHeight(iOPGraph.getHeight());
        return true;
    }

    public boolean doLayout(IOPGraph iOPGraph) {
        boolean bl;
        if (iOPGraph == null) {
            if (this.isDotLayout) {
                bl = this.doNewDotLayout();
            } else {
                this.isDotLayout = true;
                bl = this.redoDotLayout();
            }
        } else {
            this.isDotLayout = false;
            bl = this.doContextLayout(iOPGraph);
        }
        return bl;
    }

    public boolean isDotLayout() {
        return this.isDotLayout;
    }

    public void resetDotLayout() {
        this.cachedDotNodeRendering = null;
        this.cachedDotEdgeRendering = null;
    }

    public String toInfoString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Graph ID: ").append(this.getUID()).append("\n");
        String[] stringArray = this.getKeys();
        stringBuffer.append("      attributes: " + stringArray.length + "\n");
        for (String objectArray : stringArray) {
            stringBuffer.append("        " + objectArray + " = " + this.getAttribute(objectArray) + "\n");
        }
        Object[] objectArray = this.getNodesInArray();
        int n = 0;
        int n2 = 0;
        for (Object object : objectArray) {
            IOPNode.NodeType nodeType = ((IOPNode)object).type;
            if (nodeType == IOPNode.NodeType.RULE) {
                ++n;
            }
            if (nodeType != IOPNode.NodeType.OCC) continue;
            ++n2;
        }
        if (n2 != 0 && n != 0) {
            stringBuffer.append("No. of rules: ").append(n).append("\n");
            stringBuffer.append("No. of occurences: ").append(n2).append("\n");
        } else {
            stringBuffer.append("No. of nodes: ").append(objectArray.length).append("\n");
        }
        return stringBuffer.toString();
    }
}

