/*
 * Decompiled with CFR 0.152.
 */
package g2d.graph;

import g2d.glyph.Glyph;
import g2d.glyph.GlyphList;
import g2d.graph.Dot;
import g2d.graph.GraphItem;
import g2d.graph.IOPNode;
import g2d.graph.Spline;
import g2d.graph.xdotparser.visitor.xDotEdge;
import g2d.swing.IOPConstants;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IOPEdge
extends GraphItem {
    protected xDotEdge dotRendering;
    protected IOPNode source;
    protected IOPNode sink;
    protected Spline spline;
    private ArrowHead arrowHeadSink;
    private ArrowHead arrowHeadSource;
    private boolean doubleEnded = false;
    protected Color color = IOPConstants.EDGE_COLOR;
    private List<Point2D> points = new ArrayList<Point2D>();
    private Point2D arrowTipSource = null;
    private Point2D arrowTipSink = null;
    private Color lastEdgeColor = IOPConstants.EDGE_COLOR;
    private float lastStrokeWidth = 1.25f;
    public static final String SOLID = "solid";
    public static final String DASHED = "dashed";
    public static final String DOTTED = "dotted";
    public static final String BOLD = "bold";
    public static final String INVIS = "invis";
    public static final String SPECIFIC = "setlinewidth";
    public static final String LTAIL = "ltail";
    public static final String LHEAD = "lhead";
    private static final Pattern pattern = Pattern.compile("setlinewidth\\((\\d+(\\.\\d)?)\\)");

    public boolean __intersects(Rectangle2D rectangle2D) {
        boolean bl = false;
        bl = this.sink != null && this.sink.intersects(rectangle2D) ? true : this.source != null && this.source.intersects(rectangle2D);
        return bl;
    }

    public IOPEdge(IOPNode iOPNode, IOPNode iOPNode2) {
        this.create(iOPNode, iOPNode2, null);
    }

    public IOPEdge(IOPNode iOPNode, IOPNode iOPNode2, Color color) {
        this.create(iOPNode, iOPNode2, color);
    }

    public IOPEdge(IOPEdge iOPEdge, IOPNode iOPNode, IOPNode iOPNode2) {
        super(iOPEdge);
        this.create(iOPNode, iOPNode2, iOPEdge.color);
        this.setStyle(iOPEdge.getStyle());
        this.setStrokeWidth(iOPEdge.getStrokeWidth());
        this.updatePoints(iOPEdge.points, iOPEdge.arrowTipSource, iOPEdge.arrowTipSink);
        String[] stringArray = iOPEdge.getKeys();
        for (int i = 0; i < stringArray.length; ++i) {
            this.setAttribute(stringArray[i], iOPEdge.getAttribute(stringArray[i]));
        }
        if (iOPEdge.dotRendering != null) {
            this.dotRendering = new xDotEdge(iOPEdge.dotRendering);
        }
        this.updateGlyphList();
    }

    private void create(IOPNode iOPNode, IOPNode iOPNode2, Color color) {
        if (iOPNode == null || iOPNode2 == null) {
            throw new IllegalArgumentException("Cannot instantiate IOPEdge with NULL for a node.");
        }
        this.source = iOPNode;
        this.sink = iOPNode2;
        this.create();
        if (color != null) {
            this.setColor(color);
        }
    }

    private void create() {
        this.spline = new Spline(this.source.getCenter(), this.sink.getCenter());
        this.arrowHeadSink = new ArrowHead(this.sink.getCenter(), this.getAngle(this.source.getCenter(), this.sink.getCenter()));
        this.arrowHeadSource = new ArrowHead(this.source.getCenter(), this.getAngle(this.sink.getCenter(), this.source.getCenter()));
        this.points.add(this.source.getCenter());
        this.points.add(this.sink.getCenter());
        this.updateGlyphList();
    }

    private void updateGlyphList() {
        if (this.dotRendering == null) {
            this.glyphList.clear();
            this.glyphList.add(this.spline);
            if (this.arrowTipSource != null) {
                this.glyphList.add(this.arrowHeadSource);
            }
            if (this.arrowTipSink != null) {
                this.glyphList.add(this.arrowHeadSink);
            }
        } else {
            this.glyphList = this.dotRendering.glyphList;
            this.spline = this.dotRendering.spline;
        }
    }

    public IOPNode getSource() {
        return this.source;
    }

    public IOPNode getSink() {
        return this.sink;
    }

    protected void setRendering(xDotEdge xDotEdge2) {
        this.dotRendering = xDotEdge2;
        this.updateGlyphList();
    }

    protected void resetRendering(xDotEdge xDotEdge2) {
        this.dotRendering = xDotEdge2;
        this.spline.setCoordinates(this.dotRendering.coordinates);
        this.updateGlyphList();
    }

    public void setDotLayout(String string, String string2, String string3, String string4, String string5, String string6, double d) {
        if (string != null) {
            xDotEdge xDotEdge2 = new xDotEdge(string, string2, string3, string4, string5, string6, (int)d);
            this.setRendering(xDotEdge2);
        }
    }

    public void updatePoints(List<Point2D> list, Point2D point2D, Point2D point2D2) {
        if (list == null) {
            throw new IllegalArgumentException("Cannot update points of IOPEdge to NULL");
        }
        int n = list.size();
        if (n < 2) {
            throw new RuntimeException("Expecting at least 2 points defining IOPEdge");
        }
        if (point2D != null) {
            this.arrowHeadSource.setArrowHead(point2D, this.getAngle(list.get(0), point2D));
        }
        if (point2D2 != null) {
            this.arrowHeadSink.setArrowHead(point2D2, this.getAngle(list.get(n - 1), point2D2));
        }
        this.arrowTipSource = point2D;
        this.arrowTipSink = point2D2;
        this.updateGlyphList();
        this.spline.setCoordinates(list.toArray(new Point2D[list.size()]));
        this.points = new ArrayList<Point2D>(list);
    }

    public List<Point2D> getPoints() {
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        arrayList.add(this.arrowTipSource);
        arrayList.add(this.arrowTipSink);
        arrayList.addAll(this.points);
        return arrayList;
    }

    private double getAngle(Point2D point2D, Point2D point2D2) {
        double d = point2D.getY() - point2D2.getY();
        double d2 = point2D.getX() - point2D2.getX();
        double d3 = Math.atan(d / d2);
        if (point2D2.getX() > point2D.getX()) {
            d3 = Math.PI + d3;
        }
        return d3;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.spline.setColor(color);
        if (this.dotRendering == null) {
            this.arrowHeadSink.setColor(color);
            this.arrowHeadSource.setColor(color);
        } else {
            Glyph glyph = this.dotRendering.head;
            if (glyph != null) {
                glyph.setColor(color);
            }
            if ((glyph = this.dotRendering.tail) != null) {
                glyph.setColor(color);
            }
        }
    }

    public void setDoubleEnded(boolean bl) {
        this.doubleEnded = bl;
    }

    public boolean isDoubleEnded() {
        return this.doubleEnded;
    }

    public String getStyle() {
        return this.spline.getStyle();
    }

    public void setStyle(String string) {
        this.spline.setStyle(string);
        if (this.dotRendering == null) {
            if (this.arrowHeadSink != null) {
                this.arrowHeadSink.setStyle(string);
            }
            if (this.arrowHeadSource != null) {
                this.arrowHeadSource.setStyle(string);
            }
        } else {
            this.glyphList = string == INVIS ? new GlyphList() : this.dotRendering.glyphList;
        }
    }

    public float getStrokeWidth() {
        return this.spline.getStrokeWidth();
    }

    public void setStrokeWidth(float f) {
        this.spline.setStrokeWidth(f);
    }

    private static float parsePenWidth(String string) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return Float.parseFloat(matcher.group(1));
        }
        return 1.0f;
    }

    public static BasicStroke createStroke(String string, float f) {
        if (DASHED.equals(string)) {
            return new BasicStroke(f, 1, 1, 50.0f, new float[]{9.0f}, 0.0f);
        }
        if (DOTTED.equals(string)) {
            return new BasicStroke(f, 1, 1, 50.0f, new float[]{1.0f, 4.0f}, 0.0f);
        }
        if (BOLD.equals(string)) {
            return new BasicStroke(f * 2.0f, 1, 1);
        }
        if (INVIS.equals(string)) {
            return null;
        }
        if (string != null && string.startsWith(SPECIFIC)) {
            float f2 = IOPEdge.parsePenWidth(string);
            return new BasicStroke(f * f2, 1, 1);
        }
        return new BasicStroke(f, 1, 1);
    }

    @Override
    public double distanceTo(Point2D point2D) {
        if (this.spline != null) {
            return this.spline.distanceTo(point2D);
        }
        return Double.MAX_VALUE;
    }

    @Override
    public void highlight() {
        super.highlight();
        this.sink.highlight();
        this.source.highlight();
        this.lastEdgeColor = this.getColor();
        this.lastStrokeWidth = this.getStrokeWidth();
        this.setColor(HIGHLIGHT);
        this.spline.setColor(HIGHLIGHT);
        this.setStrokeWidth(HIGHLIGHT_OFFSET);
    }

    @Override
    public void dehighlight() {
        super.dehighlight();
        this.setColor(this.lastEdgeColor);
        this.spline.setColor(this.lastEdgeColor);
        this.setStrokeWidth(this.lastStrokeWidth);
        this.sink.dehighlight();
        this.source.dehighlight();
    }

    public String toString() {
        return this.source.toString() + " -> " + this.sink.toString();
    }

    public int hashCode() {
        return this.source.hashCode() + 37 * this.sink.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof IOPEdge) {
            IOPEdge iOPEdge = (IOPEdge)object;
            return iOPEdge.source.equals(this.source) && iOPEdge.sink.equals(this.sink);
        }
        return false;
    }

    public String toDotString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.source.getName()).append(" -> ").append(this.sink.getName());
        stringBuffer.append(" [id=").append(this.gid);
        stringBuffer.append(",style=").append(this.getStyle());
        if (this.isDoubleEnded()) {
            stringBuffer.append(",dir=both");
        }
        stringBuffer.append(",color=").append(Dot.colorToDotHSB(this.getColor()));
        Object object = this.getAttribute(LTAIL);
        if (object != null) {
            stringBuffer.append(",").append(LTAIL).append("=").append(object.toString());
        }
        if ((object = this.getAttribute(LHEAD)) != null) {
            stringBuffer.append(",").append(LHEAD).append("=").append(object.toString());
        }
        stringBuffer.append("]\n");
        return stringBuffer.toString();
    }

    class ArrowHead
    extends Glyph {
        private final int[] aX = new int[]{12, 12, 2};
        private final int[] aY = new int[]{-2, 2, 0};
        private Point2D position;
        private double angle;

        public ArrowHead(Point2D point2D, double d) {
            this.setColor(IOPConstants.EDGE_COLOR);
            this.setArrowHead(point2D, d);
        }

        public ArrowHead(ArrowHead arrowHead) {
            this(arrowHead.position, arrowHead.angle);
        }

        public void setStyle(String string) {
            if (string == null) {
                return;
            }
            this.setStroke(IOPEdge.createStroke(string, 1.25f));
        }

        public void setArrowHead(Point2D point2D, double d) {
            Color color = this.getBorder();
            this.setGlyph(new Polygon(this.aX, this.aY, 3), color, color);
            this.translate(point2D.getX(), point2D.getY());
            this.rotate(d, point2D.getX(), point2D.getY());
            this.position = point2D;
            this.angle = d;
        }
    }
}

