/*
 * Decompiled with CFR 0.152.
 */
package g2d.graph;

import g2d.graph.GraphItem;
import g2d.graph.IOPEdge;
import g2d.graph.IOPGraph;
import g2d.graph.IOPNode;
import g2d.util.Pair;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Highlighter {
    public static final String STATUS = "status";
    public static final String STATUS_PREVIOUS = "status_previous";
    public static final String PAIR = "pair";
    public static final String PATH = "path";
    public static final String HIGHLIGHTER = "highlighter";
    public static final String PRIOR_FILL_COLOR = "prior_fill_color";
    public static final String PRIOR_BORDER_COLOR = "prior_border_color";
    public static Color supressBorderColor = Color.LIGHT_GRAY;
    public static Color supressFillColor = Color.WHITE;
    private static final boolean debug = false;
    private boolean loud = false;
    protected final IOPGraph graph;
    protected final IOPEdge[] edges;
    protected final IOPNode[] nodes;
    protected Set<GraphItem> pathSet;
    protected Set<GraphItem> supressSet;
    protected Pair<IOPNode, IOPNode> pair;

    public static Highlighter getHighlighter(IOPGraph iOPGraph) {
        Highlighter highlighter = null;
        if (iOPGraph != null) {
            Object object = iOPGraph.getAttribute(HIGHLIGHTER);
            if (object == null) {
                highlighter = new Highlighter(iOPGraph);
                iOPGraph.setAttribute(HIGHLIGHTER, highlighter);
            } else if (object instanceof Highlighter) {
                highlighter = (Highlighter)object;
            }
        }
        return highlighter;
    }

    private Highlighter(IOPGraph iOPGraph) {
        this.graph = iOPGraph;
        this.edges = this.graph.getEdgesInArray();
        this.nodes = this.graph.getNodesInArray();
    }

    public void clear() {
        this.dehighlight(true);
        this.graph.fireChange();
    }

    public boolean getLoudness() {
        return this.loud;
    }

    public void setLoudness(boolean bl) {
        this.dehighlight(false);
        this.loud = bl;
        this.rehighlight();
        this.graph.fireChange();
    }

    public void highlightPair(Pair<IOPNode, IOPNode> pair) {
        if (this.pair != null) {
            this.dehighlight(true);
        }
        if (pair != null) {
            this.pair = pair;
            this.highlightIOPNode((IOPNode)this.pair.first);
            this.highlightIOPNode((IOPNode)this.pair.second);
        }
        this.graph.fireChange();
    }

    private void rehighlight() {
        if (this.pair != null) {
            this.highlightIOPNode((IOPNode)this.pair.first);
            this.highlightIOPNode((IOPNode)this.pair.second);
        }
        if (this.pathSet != null) {
            for (GraphItem graphItem : this.pathSet) {
                this.highlightGraphItem(graphItem);
            }
            for (GraphItem graphItem : this.supressSet) {
                this.supressGraphItem(graphItem);
            }
        }
    }

    private void highlightIOPNode(IOPNode iOPNode) {
        iOPNode.highlight();
        if (this.loud) {
            iOPNode.setAttribute(STATUS_PREVIOUS, iOPNode.getAttribute(STATUS));
            iOPNode.setAttribute(STATUS, PAIR);
            iOPNode.updateFillColor();
        }
    }

    private void dehighlightIOPNode(IOPNode iOPNode) {
        iOPNode.dehighlight();
        if (this.loud) {
            iOPNode.setAttribute(STATUS, iOPNode.getAttribute(STATUS_PREVIOUS));
            iOPNode.updateFillColor();
        }
    }

    private void highlightGraphItem(GraphItem graphItem) {
        if (graphItem instanceof IOPNode) {
            this.highlightIOPNode((IOPNode)graphItem);
        } else {
            graphItem.highlight();
        }
    }

    private void dehighlightGraphItem(GraphItem graphItem) {
        if (graphItem instanceof IOPNode) {
            this.dehighlightIOPNode((IOPNode)graphItem);
        } else {
            graphItem.dehighlight();
        }
    }

    private void supressIOPNode(IOPNode iOPNode) {
        iOPNode.setAttribute(PRIOR_FILL_COLOR, iOPNode.getFillColor());
        iOPNode.setAttribute(PRIOR_BORDER_COLOR, iOPNode.getBorderColor());
        iOPNode.setFillColor(supressFillColor);
        iOPNode.setBorderColor(supressBorderColor);
    }

    private void unsupressIOPNode(IOPNode iOPNode) {
        Color color = (Color)iOPNode.getAttribute(PRIOR_FILL_COLOR);
        Color color2 = (Color)iOPNode.getAttribute(PRIOR_BORDER_COLOR);
        iOPNode.removeAttribute(PRIOR_FILL_COLOR);
        iOPNode.removeAttribute(PRIOR_BORDER_COLOR);
        iOPNode.setFillColor(color);
        iOPNode.setBorderColor(color2);
    }

    private void supressIOPEdge(IOPEdge iOPEdge) {
        iOPEdge.setAttribute(PRIOR_BORDER_COLOR, iOPEdge.getColor());
        iOPEdge.setColor(supressBorderColor);
    }

    private void unsupressIOPEdge(IOPEdge iOPEdge) {
        Color color = (Color)iOPEdge.getAttribute(PRIOR_BORDER_COLOR);
        iOPEdge.removeAttribute(PRIOR_BORDER_COLOR);
        iOPEdge.setColor(color);
    }

    private void supressGraphItem(GraphItem graphItem) {
        if (graphItem instanceof IOPNode) {
            this.supressIOPNode((IOPNode)graphItem);
        } else {
            this.supressIOPEdge((IOPEdge)graphItem);
        }
    }

    private void unsupressGraphItem(GraphItem graphItem) {
        if (graphItem instanceof IOPNode) {
            this.unsupressIOPNode((IOPNode)graphItem);
        } else {
            this.unsupressIOPEdge((IOPEdge)graphItem);
        }
    }

    public void highlightPath(List<IOPNode> list) {
        if (this.pathSet != null) {
            this.dehighlight(true);
        }
        if (list != null) {
            this.makePath(list);
            for (GraphItem graphItem : this.pathSet) {
                this.highlightGraphItem(graphItem);
            }
            for (GraphItem graphItem : this.supressSet) {
                this.supressGraphItem(graphItem);
            }
        }
        this.graph.fireChange();
    }

    private void makePath(List<IOPNode> list) {
        if (this.pathSet != null && this.supressSet != null) {
            this.pathSet.clear();
            this.supressSet.clear();
        } else {
            this.pathSet = new HashSet<GraphItem>();
            this.supressSet = new HashSet<GraphItem>();
        }
        for (IOPNode iOPNode : list) {
            this.pathSet.add(iOPNode);
        }
        for (IOPEdge graphItem : this.edges) {
            if (list.contains(graphItem.source) || list.contains(graphItem.sink)) {
                this.pathSet.add(graphItem);
                this.pathSet.add(graphItem.source);
                this.pathSet.add(graphItem.sink);
                continue;
            }
            this.supressSet.add(graphItem);
        }
        for (GraphItem graphItem : this.nodes) {
            if (this.pathSet.contains(graphItem)) continue;
            this.supressSet.add(graphItem);
        }
    }

    private void dehighlight(boolean bl) {
        if (this.pathSet != null && this.supressSet != null) {
            for (GraphItem graphItem : this.pathSet) {
                this.dehighlightGraphItem(graphItem);
            }
            for (GraphItem graphItem : this.supressSet) {
                this.unsupressGraphItem(graphItem);
            }
            if (bl) {
                this.pathSet.clear();
                this.supressSet.clear();
            }
        }
        if (this.pair != null) {
            this.dehighlightIOPNode((IOPNode)this.pair.first);
            this.dehighlightIOPNode((IOPNode)this.pair.second);
            if (bl) {
                this.pair = null;
            }
        }
    }
}

