/*
 * Decompiled with CFR 0.152.
 */
package g2d.glyphviewer;

import g2d.glyph.BufferedGlyphList;
import g2d.glyphviewer.GlyphView;
import g2d.jlambda.Closure;
import g2d.runtime.ShutdownHook;
import g2d.tabwin.TabFrame;
import g2d.tabwin.TabUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class Utils
extends TabUtils {
    public static final String APPLICATION_NAME;
    private static final ArrayList<BufferedGlyphList> roots;
    private static final HashMap<String, GlyphView> name2View;

    public static GlyphView launchTab(BufferedGlyphList bufferedGlyphList) {
        return Utils.launchTab(bufferedGlyphList, false);
    }

    public static GlyphView launchTab(BufferedGlyphList bufferedGlyphList, boolean bl) {
        String string = bufferedGlyphList.getAttributeAsString("title", null);
        String string2 = bufferedGlyphList.getAttributeAsString("description", null);
        GlyphView glyphView = new GlyphView(bufferedGlyphList, string, string2);
        Closure closure = bufferedGlyphList.getAttributeAsClosure("panelClosure", null);
        if (closure != null) {
            closure.applyClosure(glyphView, bufferedGlyphList);
        }
        TabFrame tabFrame = null;
        GlyphView glyphView2 = Utils.findPanel(bufferedGlyphList, bl);
        if (glyphView2 == null) {
            tabFrame = new TabFrame(glyphView, APPLICATION_NAME);
            tabFrame.pack();
            tabFrame.setVisible(true);
        } else {
            tabFrame = Utils.getTabFrame(glyphView2);
            int n = tabFrame.indexOfTabPanel(glyphView2);
            tabFrame.addTabPanel(n + 1, glyphView, true);
        }
        Utils.note(bufferedGlyphList, glyphView);
        return glyphView;
    }

    private static GlyphView findPanel(BufferedGlyphList bufferedGlyphList, boolean bl) {
        GlyphView glyphView = null;
        if (bl) {
            for (BufferedGlyphList bufferedGlyphList2 : roots) {
                glyphView = name2View.get(bufferedGlyphList2.getAttributeAsString("name", null));
                if (glyphView == null) continue;
                return glyphView;
            }
        }
        return glyphView;
    }

    private static void note(BufferedGlyphList bufferedGlyphList, GlyphView glyphView) {
        String string = bufferedGlyphList.getAttributeAsString("name", null);
        if (string == null) {
            throw new IllegalArgumentException("launchTab: needs a non-null glyphs name to work like a charm.");
        }
        name2View.put(string, glyphView);
        if (!roots.contains(bufferedGlyphList)) {
            roots.add(bufferedGlyphList);
        }
    }

    public static void dispose(BufferedGlyphList bufferedGlyphList) {
        name2View.remove(bufferedGlyphList.getAttributeAsString("name", null));
    }

    public static void bringToFront(BufferedGlyphList bufferedGlyphList) {
        GlyphView glyphView = name2View.get(bufferedGlyphList.getAttributeAsString("name", null));
        if (glyphView == null) {
            return;
        }
        TabFrame tabFrame = TabUtils.getTabFrame(glyphView);
        if (tabFrame == null) {
            return;
        }
        tabFrame.focusTabPanel(glyphView);
        tabFrame.toFront();
    }

    public static GlyphView getPanel(BufferedGlyphList bufferedGlyphList) {
        GlyphView glyphView = name2View.get(bufferedGlyphList.getAttributeAsString("name", null));
        return glyphView;
    }

    public static TabFrame getTabFrame(BufferedGlyphList bufferedGlyphList) {
        TabFrame tabFrame = null;
        GlyphView glyphView = name2View.get(bufferedGlyphList.getAttributeAsString("name", null));
        if (glyphView != null) {
            tabFrame = Utils.getTabFrame(glyphView);
        }
        return tabFrame;
    }

    public static void main(String[] stringArray) {
        BufferedGlyphList bufferedGlyphList = new BufferedGlyphList();
        Utils.launchTab(bufferedGlyphList);
    }

    static {
        String string;
        APPLICATION_NAME = string = System.getProperty("com.apple.mrj.application.apple.menu.about.name", "GlyphViewer");
        Runtime.getRuntime().addShutdownHook(new ShutdownHook(APPLICATION_NAME));
        roots = new ArrayList();
        name2View = new HashMap();
    }
}

